/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.RedundantVisibilityModifierSyntaxCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J2\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J2\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u001e\u001a\u00020\u001a*\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010#\u001a\u00020\u001a*\u0004\u0018\u00010\u00142\b\u0010$\u001a\u0004\u0018\u00010\u0016H\u0002J\u001c\u0010\u0018\u001a\u00020\u0014*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J,\u0010%\u001a\u00020\u00142\"\u0010&\u001a\u001e\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030(\u0012\u0004\u0012\u00020)0'\u0012\u0004\u0012\u00020\u00070'H\u0002J\u0018\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010-\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001cR\u0018\u0010 \u001a\u00020\u001a*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/RedundantVisibilityModifierSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "<init>", "()V", "checkPsiOrLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkPropertyAndReport", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkElementAndReport", "defaultVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "containingMemberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkElementWithImplicitVisibilityAndReport", "implicitVisibility", "isPropertyFromParameter", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;)Z", "reportElement", "canMakeSetterMoreAccessible", "setterImplicitVisibility", "hasSetterWithImplicitVisibility", "getHasSetterWithImplicitVisibility", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Z", "isEffectivelyHiddenBy", "declaration", "findBiggestVisibility", "processSymbols", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "findPropertyAccessorVisibility", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "findPropertyVisibility", "findFunctionVisibility", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkers"})
public final class RedundantVisibilityModifierSyntaxChecker
extends FirDeclarationSyntaxChecker<FirDeclaration, KtDeclaration> {
    @NotNull
    public static final RedundantVisibilityModifierSyntaxChecker INSTANCE = new RedundantVisibilityModifierSyntaxChecker();

    private RedundantVisibilityModifierSyntaxChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirDeclaration element, @NotNull KtSourceElement source, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (element instanceof FirPropertyAccessor || element instanceof FirValueParameter) {
            return;
        }
        if (element instanceof FirConstructor) {
            KtSourceElement ktSourceElement = ((FirConstructor)element).getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
                return;
            }
        }
        if (element instanceof FirProperty) {
            this.checkPropertyAndReport((FirProperty)element, context, reporter);
        } else {
            Object object = FirConflictsHelpersKt.getResolvedStatus(element.getSymbol());
            if (object == null || (object = object.getDefaultVisibility()) == null) {
                object = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
            }
            Object defaultVisibility = object;
            this.checkElementAndReport(element, (Visibility)defaultVisibility, context, reporter);
        }
    }

    private final void checkPropertyAndReport(FirProperty property, CheckerContext context, DiagnosticReporter reporter) {
        Visibility setterImplicitVisibility = null;
        FirPropertyAccessor firPropertyAccessor = property.getSetter();
        if (firPropertyAccessor != null) {
            Visibility visibility;
            FirPropertyAccessor setter = firPropertyAccessor;
            boolean bl = false;
            Visibility defaultVisibility = setter.getSymbol().getResolvedStatus().getDefaultVisibility();
            setterImplicitVisibility = visibility = INSTANCE.implicitVisibility(setter, context, defaultVisibility);
            INSTANCE.checkElementAndReport(setter, visibility, property, context, reporter);
        }
        FirPropertyAccessor firPropertyAccessor2 = property.getGetter();
        if (firPropertyAccessor2 != null) {
            FirPropertyAccessor getter = firPropertyAccessor2;
            boolean bl = false;
            INSTANCE.checkElementAndReport(getter, getter.getSymbol().getResolvedStatus().getDefaultVisibility(), property, context, reporter);
        }
        FirBackingField firBackingField = property.getBackingField();
        if (firBackingField != null) {
            FirBackingField field = firBackingField;
            boolean bl = false;
            INSTANCE.checkElementAndReport(field, field.getSymbol().getResolvedStatus().getDefaultVisibility(), property, context, reporter);
        }
        if (this.canMakeSetterMoreAccessible(property, setterImplicitVisibility)) {
            return;
        }
        this.checkElementAndReport(property, property.getSymbol().getResolvedStatus().getDefaultVisibility(), context, reporter);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkElementAndReport(FirDeclaration element, Visibility defaultVisibility, CheckerContext context, DiagnosticReporter reporter) {
        FirElement firElement;
        RedundantVisibilityModifierSyntaxChecker redundantVisibilityModifierSyntaxChecker;
        FirDeclaration firDeclaration;
        Visibility visibility;
        block3: {
            void $this$findClosest_u24default$iv;
            CheckerContext checkerContext = context;
            visibility = defaultVisibility;
            firDeclaration = element;
            redundantVisibilityModifierSyntaxChecker = this;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirDeclaration firDeclaration2 = it$iv;
                if (!(firDeclaration2 instanceof FirMemberDeclaration)) {
                    firDeclaration2 = null;
                }
                if ((firElement = (FirElement)((FirMemberDeclaration)firDeclaration2)) == null) continue;
                FirElement firElement3 = firElement2 = firElement;
                boolean bl = false;
                FirElement it = firElement3;
                firElement = true ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block3;
            }
            firElement = null;
        }
        FirElement firElement4 = firElement;
        redundantVisibilityModifierSyntaxChecker.checkElementAndReport(firDeclaration, visibility, (FirMemberDeclaration)firElement4, context, reporter);
    }

    private final void checkElementAndReport(FirDeclaration element, Visibility defaultVisibility, FirMemberDeclaration containingMemberDeclaration, CheckerContext context, DiagnosticReporter reporter) {
        this.checkElementWithImplicitVisibilityAndReport(element, this.implicitVisibility(element, context, defaultVisibility), containingMemberDeclaration, context, reporter);
    }

    private final void checkElementWithImplicitVisibilityAndReport(FirDeclaration element, Visibility implicitVisibility, FirMemberDeclaration containingMemberDeclaration, CheckerContext context, DiagnosticReporter reporter) {
        KtSourceElement ktSourceElement = element.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind && !this.isPropertyFromParameter(element)) {
            return;
        }
        if (!(element instanceof FirMemberDeclaration)) {
            return;
        }
        KtSourceElement ktSourceElement2 = ((FirMemberDeclaration)element).getSource();
        Visibility explicitVisibility = ktSourceElement2 != null ? RedundantVisibilityModifierSyntaxCheckerKt.getExplicitVisibility(ktSourceElement2) : null;
        boolean isHidden = this.isEffectivelyHiddenBy(explicitVisibility, containingMemberDeclaration);
        if (isHidden) {
            this.reportElement(element, context, reporter);
            return;
        }
        ExplicitApiMode explicitApiMode = context.getLanguageVersionSettings().getFlag(AnalysisFlags.getExplicitApiMode());
        if (explicitApiMode != ExplicitApiMode.DISABLED && Intrinsics.areEqual(explicitVisibility, Visibilities.Public.INSTANCE)) {
            return;
        }
        if (Intrinsics.areEqual(explicitVisibility, implicitVisibility)) {
            this.reportElement(element, context, reporter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPropertyFromParameter(FirElement $this$isPropertyFromParameter) {
        if (!($this$isPropertyFromParameter instanceof FirProperty)) return false;
        KtSourceElement ktSourceElement = ((FirProperty)$this$isPropertyFromParameter).getSource();
        if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) return false;
        return true;
    }

    private final void reportElement(FirDeclaration element, CheckerContext context, DiagnosticReporter reporter) {
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)element.getSource(), FirErrors.INSTANCE.getREDUNDANT_VISIBILITY_MODIFIER(), (DiagnosticContext)context, null, 8, null);
    }

    private final boolean canMakeSetterMoreAccessible(FirProperty $this$canMakeSetterMoreAccessible, Visibility setterImplicitVisibility) {
        FirMemberDeclaration $this$isOverride$iv = $this$canMakeSetterMoreAccessible;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) {
            return false;
        }
        if (!this.getHasSetterWithImplicitVisibility($this$canMakeSetterMoreAccessible)) {
            return false;
        }
        if (setterImplicitVisibility == null) {
            return false;
        }
        FirMemberDeclaration $this$visibility$iv = $this$canMakeSetterMoreAccessible;
        boolean $i$f$getVisibility = false;
        return !Intrinsics.areEqual(setterImplicitVisibility, $this$visibility$iv.getStatus().getVisibility());
    }

    private final boolean getHasSetterWithImplicitVisibility(FirProperty $this$hasSetterWithImplicitVisibility) {
        FirPropertyAccessor firPropertyAccessor = $this$hasSetterWithImplicitVisibility.getSetter();
        if (firPropertyAccessor == null) {
            return false;
        }
        FirPropertyAccessor theSetter = firPropertyAccessor;
        KtSourceElement ktSourceElement = $this$hasSetterWithImplicitVisibility.getSource();
        KtSourceElement ktSourceElement2 = theSetter.getSource();
        if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getLighterASTNode() : null, ktSourceElement2 != null ? ktSourceElement2.getLighterASTNode() : null)) {
            return true;
        }
        KtSourceElement ktSourceElement3 = theSetter.getSource();
        if (ktSourceElement3 == null) {
            return true;
        }
        KtSourceElement theSource = ktSourceElement3;
        return RedundantVisibilityModifierSyntaxCheckerKt.getExplicitVisibility(theSource) == null;
    }

    private final boolean isEffectivelyHiddenBy(Visibility $this$isEffectivelyHiddenBy, FirMemberDeclaration declaration) {
        Object object;
        block8: {
            block7: {
                if ($this$isEffectivelyHiddenBy == null || Intrinsics.areEqual($this$isEffectivelyHiddenBy, Visibilities.Protected.INSTANCE)) {
                    return false;
                }
                object = declaration;
                if (object == null) break block7;
                FirMemberDeclaration $this$effectiveVisibility$iv = object;
                boolean $i$f$getEffectiveVisibility = false;
                FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
                Object object2 = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
                if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
                    object2 = object = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
                }
                if (object2 != null && (object = ((EffectiveVisibility)object).toVisibility()) != null) break block8;
            }
            return false;
        }
        Object containerVisibility = object;
        if (Intrinsics.areEqual(containerVisibility, Visibilities.Local.INSTANCE) && Intrinsics.areEqual($this$isEffectivelyHiddenBy, Visibilities.Internal.INSTANCE)) {
            return true;
        }
        Integer n2 = $this$isEffectivelyHiddenBy.compareTo((Visibility)containerVisibility);
        if (n2 == null) {
            return false;
        }
        int difference = n2;
        return difference > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Visibility implicitVisibility(FirDeclaration $this$implicitVisibility, CheckerContext context, Visibility defaultVisibility) {
        Visibility visibility;
        boolean $i$f$isOverride;
        Object $this$isOverride$iv;
        block10: {
            block11: {
                block12: {
                    if ($this$implicitVisibility instanceof FirPropertyAccessor && ((FirPropertyAccessor)$this$implicitVisibility).isSetter() && CollectionsKt.last(context.getContainingDeclarations()) instanceof FirClass) {
                        $this$isOverride$iv = ((FirPropertyAccessor)$this$implicitVisibility).getPropertySymbol();
                        $i$f$isOverride = false;
                        if (((FirCallableSymbol)$this$isOverride$iv).getRawStatus().isOverride()) {
                            visibility = this.findPropertyAccessorVisibility((FirPropertyAccessor)$this$implicitVisibility, context);
                            return visibility;
                        }
                    }
                    if ($this$implicitVisibility instanceof FirPropertyAccessor) {
                        FirCallableSymbol $this$visibility$iv = ((FirPropertyAccessor)$this$implicitVisibility).getPropertySymbol();
                        boolean $i$f$getVisibility = false;
                        visibility = $this$visibility$iv.getResolvedStatus().getVisibility();
                        return visibility;
                    }
                    if (!($this$implicitVisibility instanceof FirConstructor)) break block10;
                    FirClassLikeSymbol<?> classSymbol = FirHelpersKt.getContainingClassSymbol($this$implicitVisibility);
                    if (!(classSymbol instanceof FirRegularClassSymbol)) break block11;
                    FirClassSymbol $this$isEnumClass$iv = (FirClassSymbol)classSymbol;
                    boolean $i$f$isEnumClass = false;
                    ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                    boolean $i$f$isEnumClass2 = false;
                    if ($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS) break block12;
                    FirClassLikeSymbol<?> $this$isSealed$iv = classSymbol;
                    boolean $i$f$isSealed = false;
                    if (!($this$isSealed$iv.getResolvedStatus().getModality() == Modality.SEALED)) break block11;
                }
                visibility = Visibilities.Private.INSTANCE;
                return visibility;
            }
            visibility = defaultVisibility;
            return visibility;
        }
        if ($this$implicitVisibility instanceof FirSimpleFunction && CollectionsKt.last(context.getContainingDeclarations()) instanceof FirClass) {
            $this$isOverride$iv = (FirMemberDeclaration)$this$implicitVisibility;
            $i$f$isOverride = false;
            if (((FirMemberDeclaration)$this$isOverride$iv).getStatus().isOverride()) {
                visibility = this.findFunctionVisibility((FirSimpleFunction)$this$implicitVisibility, context);
                return visibility;
            }
        }
        if ($this$implicitVisibility instanceof FirProperty && CollectionsKt.last(context.getContainingDeclarations()) instanceof FirClass) {
            $this$isOverride$iv = (FirMemberDeclaration)$this$implicitVisibility;
            $i$f$isOverride = false;
            if (((FirMemberDeclaration)$this$isOverride$iv).getStatus().isOverride()) {
                visibility = this.findPropertyVisibility((FirProperty)$this$implicitVisibility, context);
                return visibility;
            }
        }
        visibility = defaultVisibility;
        return visibility;
    }

    private final Visibility findBiggestVisibility(Function1<? super Function1<? super FirCallableSymbol<?>, ? extends ProcessorAction>, Unit> processSymbols) {
        Ref.ObjectRef current = new Ref.ObjectRef();
        current.element = Visibilities.Private.INSTANCE;
        processSymbols.invoke(arg_0 -> RedundantVisibilityModifierSyntaxChecker.findBiggestVisibility$lambda$3(current, arg_0));
        return (Visibility)current.element;
    }

    private final Visibility findPropertyAccessorVisibility(FirPropertyAccessor accessor, CheckerContext context) {
        FirPropertySymbol propertySymbol = accessor.getPropertySymbol();
        return this.findBiggestVisibility(arg_0 -> RedundantVisibilityModifierSyntaxChecker.findPropertyAccessorVisibility$lambda$5(propertySymbol, context, arg_0));
    }

    private final Visibility findPropertyVisibility(FirProperty property, CheckerContext context) {
        return this.findBiggestVisibility(arg_0 -> RedundantVisibilityModifierSyntaxChecker.findPropertyVisibility$lambda$6(property, context, arg_0));
    }

    private final Visibility findFunctionVisibility(FirSimpleFunction function2, CheckerContext context) {
        return this.findBiggestVisibility(arg_0 -> RedundantVisibilityModifierSyntaxChecker.findFunctionVisibility$lambda$7(function2, context, arg_0));
    }

    private static final ProcessorAction findBiggestVisibility$lambda$3(Ref.ObjectRef $current, FirCallableSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        FirCallableSymbol $this$visibility$iv = it;
        boolean $i$f$getVisibility = false;
        Integer difference = Visibilities.INSTANCE.compare((Visibility)$current.element, $this$visibility$iv.getResolvedStatus().getVisibility());
        if (difference != null && difference < 0) {
            $this$visibility$iv = it;
            $i$f$getVisibility = false;
            $current.element = $this$visibility$iv.getResolvedStatus().getVisibility();
        }
        return ProcessorAction.NEXT;
    }

    private static final ProcessorAction findPropertyAccessorVisibility$lambda$5$lambda$4(Function1 $checkVisibility, FirPropertySymbol property) {
        Intrinsics.checkNotNullParameter(property, "property");
        FirPropertyAccessorSymbol firPropertyAccessorSymbol = property.getSetterSymbol();
        return (ProcessorAction)((Object)$checkVisibility.invoke(firPropertyAccessorSymbol != null ? (FirCallableSymbol)firPropertyAccessorSymbol : (FirCallableSymbol)property));
    }

    private static final Unit findPropertyAccessorVisibility$lambda$5(FirPropertySymbol $propertySymbol, CheckerContext $context, Function1 checkVisibility) {
        Intrinsics.checkNotNullParameter(checkVisibility, "checkVisibility");
        FirHelpersKt.processOverriddenPropertiesWithActionSafe($propertySymbol, $context, arg_0 -> RedundantVisibilityModifierSyntaxChecker.findPropertyAccessorVisibility$lambda$5$lambda$4(checkVisibility, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit findPropertyVisibility$lambda$6(FirProperty $property, CheckerContext $context, Function1 it) {
        Intrinsics.checkNotNullParameter(it, "it");
        FirHelpersKt.processOverriddenPropertiesWithActionSafe($property.getSymbol(), $context, it);
        return Unit.INSTANCE;
    }

    private static final Unit findFunctionVisibility$lambda$7(FirSimpleFunction $function, CheckerContext $context, Function1 it) {
        Intrinsics.checkNotNullParameter(it, "it");
        FirHelpersKt.processOverriddenFunctionsWithActionSafe($function.getSymbol(), $context, it);
        return Unit.INSTANCE;
    }
}

