/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnderscoreChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "diagnosticsCheckNeeded", "", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "checkers"})
public final class FirUnderscoreChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirUnderscoreChecker INSTANCE = new FirUnderscoreChecker();

    private FirUnderscoreChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirStatement expression) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression, "expression");
        FirStatement firStatement = expression;
        if (firStatement instanceof FirResolvable) {
            if (this.diagnosticsCheckNeeded((FirResolvable)((Object)expression))) {
                FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(((FirResolvable)((Object)expression)).getCalleeReference().getSource(), context, reporter, true);
            }
        } else if (firStatement instanceof FirResolvedQualifier) {
            FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(((FirResolvedQualifier)expression).getSource(), context, reporter, true);
        }
    }

    private final boolean diagnosticsCheckNeeded(FirResolvable expression) {
        boolean bl;
        if (expression.getCalleeReference() instanceof FirErrorNamedReference) {
            return false;
        }
        FirResolvable firResolvable = expression;
        if (firResolvable instanceof FirImplicitInvokeCall) {
            String string = ((FirImplicitInvokeCall)expression).getCalleeReference().getName().asString();
            Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
            bl = FirUnderscoreHelpersKt.isUnderscore(string);
        } else if (firResolvable instanceof FirCall) {
            Object object;
            FirReference $this$toResolvedSymbol_u24default$iv = expression.getCalleeReference();
            boolean discardErrorReference$iv = false;
            boolean $i$f$toResolvedSymbol = false;
            FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$toResolvedSymbol_u24default$iv);
            FirBasedSymbol<Object> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
            if (!(firBasedSymbol instanceof FirFunctionSymbol)) {
                firBasedSymbol = null;
            }
            bl = (object = (FirFunctionSymbol)((FirBasedSymbol)((FirFunctionSymbol)firBasedSymbol))) != null && (object = ((FirFunctionSymbol)object).getCallableId()) != null && (object = ((CallableId)object).getCallableName()) != null && (object = ((Name)object).asString()) != null ? FirUnderscoreHelpersKt.isUnderscore((CharSequence)object) : false;
        } else {
            bl = true;
        }
        return bl;
    }
}

