/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirProtectedConstructorNotInSuperCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "shouldAllowSuchCallNonetheless", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "checkers"})
public final class FirProtectedConstructorNotInSuperCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirProtectedConstructorNotInSuperCallChecker INSTANCE = new FirProtectedConstructorNotInSuperCallChecker();

    private FirProtectedConstructorNotInSuperCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression, "expression");
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(expression.getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference = firResolvedNamedReference;
        FirConstructorSymbol firConstructorSymbol = FirReferenceUtilsKt.toResolvedConstructorSymbol$default(reference, false, 1, null);
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol symbol = firConstructorSymbol;
        FirRegularClassSymbol constructedClass = DeclarationUtilsKt.getConstructedClass(symbol, context.getSession());
        if (!this.shouldAllowSuchCallNonetheless(symbol, context)) {
            FirCallableSymbol $this$visibility$iv = symbol;
            boolean $i$f$getVisibility = false;
            if (Intrinsics.areEqual($this$visibility$iv.getResolvedStatus().getVisibility().normalize(), Visibilities.Protected.INSTANCE) && !FirReferenceUtilsKt.isError(reference)) {
                boolean bl;
                block8: {
                    Iterable $this$none$iv = context.getContainingDeclarations();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            FirDeclaration it = (FirDeclaration)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getSymbol(), constructedClass)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)expression.getCalleeReference().getSource(), FirErrors.INSTANCE.getPROTECTED_CONSTRUCTOR_NOT_IN_SUPER_CALL(), (Object)symbol, null, 16, null);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean shouldAllowSuchCallNonetheless(FirConstructorSymbol symbol, CheckerContext context) {
        v0 = context.getContainingFile();
        if (v0 == null) {
            return false;
        }
        containingFile = v0;
        if (CollectionsKt.singleOrNull(containingFile.getDeclarations()) instanceof FirCodeFragment) {
            return true;
        }
        $this$originalIfFakeOverride$iv = symbol;
        $i$f$originalIfFakeOverride = false;
        $this$originalIfFakeOverride$iv$iv = (FirCallableDeclaration)$this$originalIfFakeOverride$iv.getFir();
        $i$f$originalIfFakeOverride = false;
        $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
        $i$f$getOriginalForSubstitutionOverride = false;
        if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv)) ** GOTO lbl-1000
        $this$isSynthetic$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv;
        $i$f$isSynthetic = false;
        if ($this$isSynthetic$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
        // 2 sources

        {
            v1 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv);
        } else {
            v1 = v2 = null;
        }
        if (v1 == null) {
            $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
            $i$f$getBaseForIntersectionOverride = false;
            v2 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
        }
        if ((v3 = (FirConstructorSymbol)((FirCallableSymbol)((FirConstructorSymbol)(v2 != null ? v2.getSymbol() : null)))) == null) {
            v3 = symbol;
        }
        original = v3;
        $this$isJavaOrEnhancement$iv = original.getOrigin();
        $i$f$isJavaOrEnhancement = false;
        return ($this$isJavaOrEnhancement$iv instanceof FirDeclarationOrigin.Java != false || Intrinsics.areEqual($this$isJavaOrEnhancement$iv, FirDeclarationOrigin.Enhancement.INSTANCE) != false) != false && Intrinsics.areEqual(original.getCallableId().getPackageName(), UtilsKt.getPackageFqName(containingFile)) != false;
    }
}

