/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ/\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0013J*\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirIncompatibleClassExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkType", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "checkType$checkers", "checkSourceElement", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "checkers"})
public final class FirIncompatibleClassExpressionChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirIncompatibleClassExpressionChecker INSTANCE = new FirIncompatibleClassExpressionChecker();

    private FirIncompatibleClassExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression, "expression");
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression.getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol symbol = firCallableSymbol;
        this.checkType$checkers(symbol.getResolvedReturnType(), expression, context, reporter);
        for (FirValueParameterSymbol parameter : symbol.getContextParameterSymbols()) {
            this.checkType$checkers(parameter.getResolvedReturnType(), expression, context, reporter);
        }
        this.checkType$checkers(symbol.getResolvedReceiverType(), expression, context, reporter);
        if (symbol instanceof FirFunctionSymbol) {
            for (FirValueParameterSymbol parameter : ((FirFunctionSymbol)symbol).getValueParameterSymbols()) {
                this.checkType$checkers(parameter.getResolvedReturnTypeRef().getConeType(), expression, context, reporter);
            }
        }
        this.checkSourceElement(symbol.getContainerSource(), expression, context, reporter);
    }

    public final void checkType$checkers(@Nullable ConeKotlinType type2, @NotNull FirElement element, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirRegularClassSymbol classSymbol;
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        ConeKotlinType coneKotlinType = type2;
        FirRegularClassSymbol firRegularClassSymbol = classSymbol = coneKotlinType != null ? ToSymbolUtilsKt.toRegularClassSymbol(coneKotlinType, context.getSession()) : null;
        this.checkSourceElement(firRegularClassSymbol != null ? DeclarationAttributesKt.getSourceElement(firRegularClassSymbol) : null, element, context, reporter);
    }

    private final void checkSourceElement(SourceElement source, FirElement element, CheckerContext context, DiagnosticReporter reporter) {
        if (!(source instanceof DeserializedContainerSource)) {
            return;
        }
        IncompatibleVersionErrorData<?> incompatibility = ((DeserializedContainerSource)source).getIncompatibility();
        if (incompatibility != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)element.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_CLASS(), (Object)((DeserializedContainerSource)source).getPresentableString(), incompatibility, (DiagnosticContext)context, null, 32, null);
        }
        if (((DeserializedContainerSource)source).getPreReleaseInfo().isInvisible()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)element.getSource(), FirErrors.INSTANCE.getPRE_RELEASE_CLASS(), (Object)((DeserializedContainerSource)source).getPresentableString(), ((DeserializedContainerSource)source).getPreReleaseInfo().getPoisoningFeatures(), (DiagnosticContext)context, null, 32, null);
        }
        if (((DeserializedContainerSource)source).getAbiStability() == DeserializedContainerAbiStability.UNSTABLE) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)element.getSource(), FirErrors.INSTANCE.getIR_WITH_UNSTABLE_ABI_COMPILED_CLASS(), (Object)((DeserializedContainerSource)source).getPresentableString(), (DiagnosticContext)context, null, 16, null);
        }
    }
}

