/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.ArgumentInfo;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeCompatibilityHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.TypeInfo;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirEqualityCompatibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J!\u0010\u0015\u001a\u00020\u0007*\u00020\u000f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u0017H\u0082\bJ\"\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J4\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010 \u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J4\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\bH\u0002JT\u0010&\u001a\u00020\u0007*\u00020\n2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\bH\u0002J0\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityCompatibilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityOperatorCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;)V", "checkEqualityApplicability", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityCompatibilityChecker$Applicability;", "l", "Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;", "r", "checkIdentityApplicability", "getInapplicabilityFor", "ifInapplicable", "block", "Lkotlin/Function1;", "getGeneralInapplicabilityDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "forceWarning", "", "getIdentityLessInapplicabilityDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory2;", "isIdentityComparedWithImplicitBoxing", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "arePrimitiveAndNonPrimitiveSupertypeRespectively", "getSourceLessInapplicabilityDiagnostic", "getEnumInapplicabilityDiagnostic", "reportInapplicabilityDiagnostic", "applicability", "operation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "lUserType", "rUserType", "checkSenselessness", "lType", "rType", "Applicability", "checkers"})
public final class FirEqualityCompatibilityChecker
extends FirExpressionChecker<FirEqualityOperatorCall> {
    @NotNull
    public static final FirEqualityCompatibilityChecker INSTANCE = new FirEqualityCompatibilityChecker();

    private FirEqualityCompatibilityChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirEqualityOperatorCall expression) {
        KFunction kFunction;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression, "expression");
        List<FirExpression> arguments2 = expression.getArgumentList().getArguments();
        if (!(arguments2.size() == 2)) {
            boolean $i$a$-require-FirEqualityCompatibilityChecker$check$22 = false;
            String $i$a$-require-FirEqualityCompatibilityChecker$check$22 = "Equality operator call with non-2 arguments";
            throw new IllegalArgumentException($i$a$-require-FirEqualityCompatibilityChecker$check$22.toString());
        }
        ArgumentInfo l2 = FirTypeCompatibilityHelpersKt.toArgumentInfo(arguments2.get(0), context);
        ArgumentInfo r2 = FirTypeCompatibilityHelpersKt.toArgumentInfo(arguments2.get(1), context);
        this.checkSenselessness(l2.getSmartCastType(), r2.getSmartCastType(), context, expression, reporter);
        switch (WhenMappings.$EnumSwitchMapping$0[expression.getOperation().ordinal()]) {
            case 1: 
            case 2: {
                kFunction = (KFunction)((Object)new Function3<TypeInfo, TypeInfo, CheckerContext, Applicability>((Object)this){

                    public final Applicability invoke(TypeInfo p0, TypeInfo p1, CheckerContext p2) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        Intrinsics.checkNotNullParameter(p1, "p1");
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        return FirEqualityCompatibilityChecker.access$checkEqualityApplicability((FirEqualityCompatibilityChecker)this.receiver, p0, p1, p2);
                    }
                });
                break;
            }
            case 3: 
            case 4: {
                kFunction = (KFunction)((Object)new Function3<TypeInfo, TypeInfo, CheckerContext, Applicability>((Object)this){

                    public final Applicability invoke(TypeInfo p0, TypeInfo p1, CheckerContext p2) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        Intrinsics.checkNotNullParameter(p1, "p1");
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        return FirEqualityCompatibilityChecker.access$checkIdentityApplicability((FirEqualityCompatibilityChecker)this.receiver, p0, p1, p2);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Invalid operator of FirEqualityOperatorCall".toString());
            }
        }
        KFunction checkApplicability2 = kFunction;
        FirEqualityCompatibilityChecker firEqualityCompatibilityChecker = this;
        Applicability $this$ifInapplicable$iv = (Applicability)((Object)((Function3)((Object)checkApplicability2)).invoke(l2.getOriginalTypeInfo(), r2.getOriginalTypeInfo(), context));
        boolean $i$f$ifInapplicable = false;
        if (WhenMappings.$EnumSwitchMapping$1[$this$ifInapplicable$iv.ordinal()] != 1) {
            Applicability it = $this$ifInapplicable$iv;
            boolean bl = false;
            boolean isCaseMissedByK1 = FirEqualityCompatibilityCheckerKt.isCaseMissedByK1Intersector(l2.getOriginalTypeInfo(), r2.getOriginalTypeInfo()) && FirEqualityCompatibilityCheckerKt.isCaseMissedByAdditionalK1IncompatibleEnumsCheck(l2.getOriginalType(), r2.getOriginalType(), context.getSession());
            boolean replicateK1Behavior = !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReportErrorsForComparisonOperators);
            INSTANCE.reportInapplicabilityDiagnostic(reporter, expression, it, expression.getOperation(), isCaseMissedByK1 && replicateK1Behavior, l2.getOriginalTypeInfo(), r2.getOriginalTypeInfo(), l2.getUserType(), r2.getUserType(), context);
            return;
        }
        if (!(l2.getArgument() instanceof FirSmartCastExpression) && !(r2.getArgument() instanceof FirSmartCastExpression)) {
            return;
        }
        FirEqualityCompatibilityChecker this_$iv = this;
        $this$ifInapplicable$iv = (Applicability)((Object)((Function3)((Object)checkApplicability2)).invoke(l2.getSmartCastTypeInfo(), r2.getSmartCastTypeInfo(), context));
        $i$f$ifInapplicable = false;
        if (WhenMappings.$EnumSwitchMapping$1[$this$ifInapplicable$iv.ordinal()] != 1) {
            Applicability it = $this$ifInapplicable$iv;
            boolean bl = false;
            INSTANCE.reportInapplicabilityDiagnostic(reporter, expression, it, expression.getOperation(), true, l2.getSmartCastTypeInfo(), r2.getSmartCastTypeInfo(), l2.getUserType(), r2.getUserType(), context);
            return;
        }
    }

    private final Applicability checkEqualityApplicability(TypeInfo l2, TypeInfo r2, CheckerContext context) {
        boolean oneIsBuiltin = l2.isBuiltin() || r2.isBuiltin();
        boolean oneIsIdentityLess = FirTypeCompatibilityHelpersKt.isIdentityLess(l2, context.getSession()) || FirTypeCompatibilityHelpersKt.isIdentityLess(r2, context.getSession());
        return (oneIsBuiltin || oneIsIdentityLess) && FirTypeCompatibilityHelpersKt.shouldReportAsPerRules1(l2, r2, context) ? this.getInapplicabilityFor(l2, r2) : Applicability.APPLICABLE;
    }

    private final Applicability checkIdentityApplicability(TypeInfo l2, TypeInfo r2, CheckerContext context) {
        boolean oneIsNotNull = !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(l2.getType()) || !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(r2.getType());
        return ConeBuiltinTypeUtilsKt.isNullableNothing(l2.getType()) || ConeBuiltinTypeUtilsKt.isNullableNothing(r2.getType()) ? Applicability.APPLICABLE : (FirTypeCompatibilityHelpersKt.isIdentityLess(l2, context.getSession()) || FirTypeCompatibilityHelpersKt.isIdentityLess(r2, context.getSession()) ? Applicability.INAPPLICABLE_AS_IDENTITY_LESS : (oneIsNotNull && FirTypeCompatibilityHelpersKt.shouldReportAsPerRules1(l2, r2, context) ? this.getInapplicabilityFor(l2, r2) : Applicability.APPLICABLE));
    }

    private final Applicability getInapplicabilityFor(TypeInfo l2, TypeInfo r2) {
        boolean isNonEmptyIntersectionInK1 = FirEqualityCompatibilityCheckerKt.isCaseMissedByK1Intersector(l2, r2);
        boolean isOneEnum = l2.isEnumClass() || r2.isEnumClass();
        return isNonEmptyIntersectionInK1 && isOneEnum ? Applicability.INAPPLICABLE_AS_ENUMS : Applicability.GENERALLY_INAPPLICABLE;
    }

    private final KtDiagnosticFactory3<String, ConeKotlinType, ConeKotlinType> getGeneralInapplicabilityDiagnostic(boolean forceWarning) {
        return forceWarning ? FirErrors.INSTANCE.getEQUALITY_NOT_APPLICABLE_WARNING() : FirErrors.INSTANCE.getEQUALITY_NOT_APPLICABLE();
    }

    private final KtDiagnosticFactory2<ConeKotlinType, ConeKotlinType> getIdentityLessInapplicabilityDiagnostic(TypeInfo l2, TypeInfo r2, boolean forceWarning, CheckerContext context) {
        boolean areBothPrimitives = FirTypeCompatibilityHelpersKt.isNotNullPrimitive(l2) && FirTypeCompatibilityHelpersKt.isNotNullPrimitive(r2);
        boolean areSameTypes = Intrinsics.areEqual(ConeTypeUtilsKt.getClassId(l2.getType()), ConeTypeUtilsKt.getClassId(r2.getType()));
        boolean shouldProperlyReportError = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReportErrorsForComparisonOperators);
        boolean shouldRelaxDiagnostic = (l2.isPrimitive() || r2.isPrimitive()) && FirTypeCompatibilityHelpersKt.areRelated(l2, r2, context) && !shouldProperlyReportError;
        return areSameTypes && areBothPrimitives ? FirErrors.INSTANCE.getDEPRECATED_IDENTITY_EQUALS() : (this.isIdentityComparedWithImplicitBoxing(l2, r2, context.getSession()) ? FirErrors.INSTANCE.getIMPLICIT_BOXING_IN_IDENTITY_EQUALS() : (forceWarning || shouldRelaxDiagnostic ? FirErrors.INSTANCE.getFORBIDDEN_IDENTITY_EQUALS_WARNING() : FirErrors.INSTANCE.getFORBIDDEN_IDENTITY_EQUALS()));
    }

    private final boolean isIdentityComparedWithImplicitBoxing(TypeInfo l2, TypeInfo r2, FirSession session) {
        return this.arePrimitiveAndNonPrimitiveSupertypeRespectively(l2, r2, session) || this.arePrimitiveAndNonPrimitiveSupertypeRespectively(r2, l2, session);
    }

    private final boolean arePrimitiveAndNonPrimitiveSupertypeRespectively(TypeInfo l2, TypeInfo r2, FirSession session) {
        return FirTypeCompatibilityHelpersKt.isNotNullPrimitive(l2) && !FirTypeCompatibilityHelpersKt.isNotNullPrimitive(r2) && TypeUtilsKt.isSubtypeOf$default(l2.getType(), r2.getType(), session, false, 4, null);
    }

    private final KtDiagnosticFactory2<ConeKotlinType, ConeKotlinType> getSourceLessInapplicabilityDiagnostic(boolean forceWarning) {
        return forceWarning ? FirErrors.INSTANCE.getINCOMPATIBLE_TYPES_WARNING() : FirErrors.INSTANCE.getINCOMPATIBLE_TYPES();
    }

    private final KtDiagnosticFactory2<ConeKotlinType, ConeKotlinType> getEnumInapplicabilityDiagnostic(TypeInfo l2, TypeInfo r2, boolean forceWarning, CheckerContext context) {
        boolean bothNullableEnums = FirTypeCompatibilityHelpersKt.isNullableEnum(l2) && FirTypeCompatibilityHelpersKt.isNullableEnum(r2);
        boolean areIntersectionsInvolved = l2.getType() instanceof ConeIntersectionType || r2.getType() instanceof ConeIntersectionType;
        boolean shouldProperlyReportError = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReportErrorsForComparisonOperators);
        boolean shouldRelaxDiagnostic = (bothNullableEnums || areIntersectionsInvolved) && !shouldProperlyReportError;
        return forceWarning || shouldRelaxDiagnostic ? FirErrors.INSTANCE.getINCOMPATIBLE_ENUM_COMPARISON() : FirErrors.INSTANCE.getINCOMPATIBLE_ENUM_COMPARISON_ERROR();
    }

    private final void reportInapplicabilityDiagnostic(DiagnosticReporter $this$reportInapplicabilityDiagnostic, FirEqualityOperatorCall expression, Applicability applicability, FirOperation operation, boolean forceWarning, TypeInfo l2, TypeInfo r2, ConeKotlinType lUserType, ConeKotlinType rUserType, CheckerContext context) {
        if (applicability == Applicability.INAPPLICABLE_AS_IDENTITY_LESS) {
            KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression.getSource(), this.getIdentityLessInapplicabilityDiagnostic(l2, r2, forceWarning, context), (Object)lUserType, (Object)rUserType, (DiagnosticContext)context, null, 32, null);
        } else if (applicability == Applicability.INAPPLICABLE_AS_ENUMS) {
            KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression.getSource(), this.getEnumInapplicabilityDiagnostic(l2, r2, forceWarning, context), (Object)lUserType, (Object)rUserType, (DiagnosticContext)context, null, 32, null);
        } else {
            KtSourceElement ktSourceElement = expression.getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
                KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression.getSource(), this.getSourceLessInapplicabilityDiagnostic(forceWarning), (Object)lUserType, (Object)rUserType, (DiagnosticContext)context, null, 32, null);
            } else if (applicability == Applicability.GENERALLY_INAPPLICABLE) {
                KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression.getSource(), this.getGeneralInapplicabilityDiagnostic(forceWarning), (Object)operation.getOperator(), (Object)lUserType, (Object)rUserType, (DiagnosticContext)context, null, 64, null);
            } else {
                throw new IllegalStateException("Shouldn't be here".toString());
            }
        }
    }

    private final void checkSenselessness(ConeKotlinType lType, ConeKotlinType rType, CheckerContext context, FirEqualityOperatorCall expression, DiagnosticReporter reporter) {
        boolean bl;
        ConeKotlinType coneKotlinType;
        if (ConeBuiltinTypeUtilsKt.isNullableNothing(rType)) {
            coneKotlinType = lType;
        } else if (ConeBuiltinTypeUtilsKt.isNullableNothing(lType)) {
            coneKotlinType = rType;
        } else {
            return;
        }
        ConeKotlinType type2 = coneKotlinType;
        if (type2 instanceof ConeErrorType) {
            return;
        }
        boolean isPositiveCompare = expression.getOperation() == FirOperation.EQ || expression.getOperation() == FirOperation.IDENTITY;
        ConeInferenceContext $this$checkSenselessness_u24lambda_u243 = TypeComponentsKt.getTypeContext(context.getSession());
        boolean bl2 = false;
        if (ConeBuiltinTypeUtilsKt.isNullableNothing(type2)) {
            bl = isPositiveCompare;
        } else if (!$this$checkSenselessness_u24lambda_u243.isNullableType(type2)) {
            bl = !isPositiveCompare;
        } else {
            return;
        }
        boolean compareResult = bl;
        KtSourceElement ktSourceElement = expression.getSource();
        if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getElementType() : null, KtNodeTypes.BINARY_EXPRESSION) && type2 == lType && !compareResult) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression.getSource(), FirErrors.INSTANCE.getSENSELESS_NULL_IN_WHEN(), (DiagnosticContext)context, null, 8, null);
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression.getSource(), FirErrors.INSTANCE.getSENSELESS_COMPARISON(), (Object)compareResult, (DiagnosticContext)context, null, 16, null);
        }
    }

    public static final /* synthetic */ Applicability access$checkEqualityApplicability(FirEqualityCompatibilityChecker $this, TypeInfo l2, TypeInfo r2, CheckerContext context) {
        return $this.checkEqualityApplicability(l2, r2, context);
    }

    public static final /* synthetic */ Applicability access$checkIdentityApplicability(FirEqualityCompatibilityChecker $this, TypeInfo l2, TypeInfo r2, CheckerContext context) {
        return $this.checkIdentityApplicability(l2, r2, context);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityCompatibilityChecker$Applicability;", "", "<init>", "(Ljava/lang/String;I)V", "APPLICABLE", "GENERALLY_INAPPLICABLE", "INAPPLICABLE_AS_ENUMS", "INAPPLICABLE_AS_IDENTITY_LESS", "checkers"})
    private static final class Applicability
    extends Enum<Applicability> {
        public static final /* enum */ Applicability APPLICABLE = new Applicability();
        public static final /* enum */ Applicability GENERALLY_INAPPLICABLE = new Applicability();
        public static final /* enum */ Applicability INAPPLICABLE_AS_ENUMS = new Applicability();
        public static final /* enum */ Applicability INAPPLICABLE_AS_IDENTITY_LESS = new Applicability();
        private static final /* synthetic */ Applicability[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Applicability[] values() {
            return (Applicability[])$VALUES.clone();
        }

        public static Applicability valueOf(String value2) {
            return Enum.valueOf(Applicability.class, value2);
        }

        @NotNull
        public static EnumEntries<Applicability> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = applicabilityArray = new Applicability[]{Applicability.APPLICABLE, Applicability.GENERALLY_INAPPLICABLE, Applicability.INAPPLICABLE_AS_ENUMS, Applicability.INAPPLICABLE_AS_IDENTITY_LESS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.EQ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_EQ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.IDENTITY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IDENTITY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Applicability.values().length];
            try {
                nArray[Applicability.APPLICABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

