/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPlatformSpecificCastCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.ArgumentInfo;
import org.jetbrains.kotlin.fir.analysis.checkers.FirCastDiagnosticsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeCompatibilityHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.TypeInfo;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatusKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001%B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0002J(\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0002J8\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002J!\u0010\u0017\u001a\u00020\u0007*\u00020\u000f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u0019H\u0082\bJ<\u0010\u001a\u001a\u00020\u0007*\u00020\n2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\bH\u0002J\"\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeOperatorCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;)V", "checkIsApplicability", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker$Applicability;", "l", "Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;", "r", "checkAsApplicability", "checkAnyApplicability", "impossible", "useless", "ifInapplicable", "block", "Lkotlin/Function1;", "reportInapplicabilityDiagnostic", "applicability", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ArgumentInfo;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "rUserType", "isLastBranchOfExhaustiveWhen", "", "getImpossibilityDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "rType", "getUselessCastDiagnostic", "Applicability", "checkers"})
public final class FirCastOperatorsChecker
extends FirExpressionChecker<FirTypeOperatorCall> {
    @NotNull
    public static final FirCastOperatorsChecker INSTANCE = new FirCastOperatorsChecker();

    private FirCastOperatorsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirTypeOperatorCall expression) {
        KFunction kFunction;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression, "expression");
        List<FirExpression> arguments2 = expression.getArgumentList().getArguments();
        if (!(arguments2.size() == 1)) {
            boolean $i$a$-require-FirCastOperatorsChecker$check$22 = false;
            String $i$a$-require-FirCastOperatorsChecker$check$22 = "Type operator call with non-1 arguments";
            throw new IllegalArgumentException($i$a$-require-FirCastOperatorsChecker$check$22.toString());
        }
        ArgumentInfo l2 = FirTypeCompatibilityHelpersKt.toArgumentInfo(arguments2.get(0), context);
        TypeInfo r2 = FirTypeCompatibilityHelpersKt.toTypeInfo(FirHelpersKt.finalApproximationOrSelf(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(expression.getConversionTypeRef()), context.getSession(), null, 2, null), context), context.getSession());
        if (FirOperation.Companion.getTYPES().contains((Object)expression.getOperation()) && r2.getDirectType() instanceof ConeDynamicType) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)expression.getConversionTypeRef().getSource(), FirErrors.INSTANCE.getDYNAMIC_NOT_ALLOWED(), null, 8, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[expression.getOperation().ordinal()]) {
            case 1: 
            case 2: {
                kFunction = (KFunction)((Object)new Function4<TypeInfo, TypeInfo, FirTypeOperatorCall, CheckerContext, Applicability>((Object)this){

                    public final Applicability invoke(TypeInfo p0, TypeInfo p1, FirTypeOperatorCall p2, CheckerContext p3) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        Intrinsics.checkNotNullParameter(p1, "p1");
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        Intrinsics.checkNotNullParameter(p3, "p3");
                        return FirCastOperatorsChecker.access$checkIsApplicability((FirCastOperatorsChecker)this.receiver, p0, p1, p2, p3);
                    }
                });
                break;
            }
            case 3: 
            case 4: {
                kFunction = (KFunction)((Object)new Function4<TypeInfo, TypeInfo, FirTypeOperatorCall, CheckerContext, Applicability>((Object)this){

                    public final Applicability invoke(TypeInfo p0, TypeInfo p1, FirTypeOperatorCall p2, CheckerContext p3) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        Intrinsics.checkNotNullParameter(p1, "p1");
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        Intrinsics.checkNotNullParameter(p3, "p3");
                        return FirCastOperatorsChecker.access$checkAsApplicability((FirCastOperatorsChecker)this.receiver, p0, p1, p2, p3);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("Invalid operator of FirTypeOperatorCall".toString());
            }
        }
        KFunction checkApplicability2 = kFunction;
        ConeKotlinType rUserType = FirHelpersKt.finalApproximationOrSelf(FirTypeUtilsKt.getConeType(expression.getConversionTypeRef()), context);
        FirCastOperatorsChecker firCastOperatorsChecker = this;
        Applicability $this$ifInapplicable$iv = (Applicability)((Object)((Function4)((Object)checkApplicability2)).invoke(l2.getSmartCastTypeInfo(), r2, expression, context));
        boolean $i$f$ifInapplicable = false;
        if (WhenMappings.$EnumSwitchMapping$1[$this$ifInapplicable$iv.ordinal()] != 1) {
            Applicability it = $this$ifInapplicable$iv;
            boolean bl = false;
            INSTANCE.reportInapplicabilityDiagnostic(reporter, expression, it, l2, r2.getType(), rUserType, context);
            return;
        }
    }

    private final Applicability checkIsApplicability(TypeInfo l2, TypeInfo r2, FirTypeOperatorCall expression, CheckerContext context) {
        return this.checkAnyApplicability(l2, r2, expression, Applicability.IMPOSSIBLE_IS_CHECK, Applicability.USELESS_IS_CHECK, context);
    }

    private final Applicability checkAsApplicability(TypeInfo l2, TypeInfo r2, FirTypeOperatorCall expression, CheckerContext context) {
        boolean isNullableNothingWithNotNull = !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(l2.getType()) && ConeBuiltinTypeUtilsKt.isNullableNothing(r2.getType()) || ConeBuiltinTypeUtilsKt.isNullableNothing(l2.getType()) && !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(r2.getType());
        return ConeBuiltinTypeUtilsKt.isNothing(l2.getType()) ? Applicability.APPLICABLE : (ConeBuiltinTypeUtilsKt.isNothing(r2.getType()) ? Applicability.IMPOSSIBLE_CAST : (isNullableNothingWithNotNull ? (WhenMappings.$EnumSwitchMapping$0[expression.getOperation().ordinal()] == 4 ? Applicability.USELESS_CAST : Applicability.IMPOSSIBLE_CAST) : this.checkAnyApplicability(l2, r2, expression, Applicability.IMPOSSIBLE_CAST, Applicability.USELESS_CAST, context)));
    }

    private final Applicability checkAnyApplicability(TypeInfo l2, TypeInfo r2, FirTypeOperatorCall expression, Applicability impossible, Applicability useless, CheckerContext context) {
        boolean oneIsNotNull = !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(l2.getType()) || !ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(r2.getType());
        return FirCastDiagnosticsHelpersKt.isRefinementUseless(context, ConeTypeUtilsKt.upperBoundIfFlexible(l2.getDirectType()), r2.getDirectType(), expression) ? useless : (FirTypeCompatibilityHelpersKt.shouldReportAsPerRules1(l2, r2, context) ? (oneIsNotNull ? impossible : useless) : (FirCastDiagnosticsHelpersKt.isCastErased(l2.getDirectType(), r2.getDirectType(), context) ? Applicability.CAST_ERASED : Applicability.APPLICABLE));
    }

    private final void reportInapplicabilityDiagnostic(DiagnosticReporter $this$reportInapplicabilityDiagnostic, FirTypeOperatorCall expression, Applicability applicability, ArgumentInfo l2, ConeKotlinType r2, ConeKotlinType rUserType, CheckerContext context) {
        switch (WhenMappings.$EnumSwitchMapping$1[applicability.ordinal()]) {
            case 2: {
                KtDiagnosticFactory0 ktDiagnosticFactory0 = this.getImpossibilityDiagnostic(l2.getOriginalTypeInfo(), r2, context);
                if (ktDiagnosticFactory0 != null) {
                    KtDiagnosticFactory0 it = ktDiagnosticFactory0;
                    boolean bl = false;
                    KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression.getSource(), it, (DiagnosticContext)context, null, 8, null);
                }
                break;
            }
            case 3: {
                KtDiagnosticFactory0 ktDiagnosticFactory0 = this.getUselessCastDiagnostic(context);
                if (ktDiagnosticFactory0 != null) {
                    KtDiagnosticFactory0 it = ktDiagnosticFactory0;
                    boolean bl = false;
                    KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression.getSource(), it, (DiagnosticContext)context, null, 8, null);
                }
                break;
            }
            case 4: {
                KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression.getSource(), FirErrors.INSTANCE.getUSELESS_IS_CHECK(), (Object)(expression.getOperation() != FirOperation.IS ? 1 : 0), (DiagnosticContext)context, null, 16, null);
                break;
            }
            case 5: {
                if (this.isLastBranchOfExhaustiveWhen(l2, r2, context)) break;
                KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression.getSource(), FirErrors.INSTANCE.getUSELESS_IS_CHECK(), (Object)(expression.getOperation() == FirOperation.IS ? 1 : 0), (DiagnosticContext)context, null, 16, null);
                break;
            }
            case 6: {
                if (expression.getOperation() == FirOperation.AS || expression.getOperation() == FirOperation.SAFE_AS) {
                    KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression.getSource(), FirErrors.INSTANCE.getUNCHECKED_CAST(), (Object)l2.getUserType(), (Object)rUserType, (DiagnosticContext)context, null, 32, null);
                    break;
                }
                KtDiagnosticReportHelpersKt.reportOn$default($this$reportInapplicabilityDiagnostic, (AbstractKtSourceElement)expression.getConversionTypeRef().getSource(), FirErrors.INSTANCE.getCANNOT_CHECK_FOR_ERASED(), (Object)rUserType, (DiagnosticContext)context, null, 16, null);
                break;
            }
            default: {
                throw new IllegalStateException("Shouldn't be here".toString());
            }
        }
    }

    private final boolean isLastBranchOfExhaustiveWhen(ArgumentInfo l2, ConeKotlinType r2, CheckerContext context) {
        if (context.getContainingElements().size() < 2) {
            return false;
        }
        List<FirElement> list = CollectionsKt.takeLast(CollectionsKt.dropLast(context.getContainingElements(), 1), 2);
        FirElement whenExpression = list.get(0);
        FirElement whenBranch = list.get(1);
        return whenExpression instanceof FirWhenExpression && whenBranch instanceof FirWhenBranch && ExhaustivenessStatusKt.isExhaustive((FirWhenExpression)whenExpression) && Intrinsics.areEqual(whenBranch, CollectionsKt.lastOrNull(((FirWhenExpression)whenExpression).getBranches())) && !ConeBuiltinTypeUtilsKt.isNothing(FirTypeUtilsKt.getResolvedType(l2.getArgument())) && (((FirWhenExpression)whenExpression).getBranches().size() > 1 || TypeUtilsKt.equalTypes$default(l2.getSmartCastTypeInfo().getType(), r2, context.getSession(), false, 4, null));
    }

    private final KtDiagnosticFactory0 getImpossibilityDiagnostic(TypeInfo l2, ConeKotlinType rType, CheckerContext context) {
        return !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.EnableDfaWarningsInK2) ? null : (FirPlatformSpecificCastCheckerKt.getFirPlatformSpecificCastChecker(context.getSession()).shouldSuppressImpossibleCast(context.getSession(), l2.getType(), rType) ? null : FirErrors.INSTANCE.getCAST_NEVER_SUCCEEDS());
    }

    private final KtDiagnosticFactory0 getUselessCastDiagnostic(CheckerContext context) {
        return !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.EnableDfaWarningsInK2) ? null : FirErrors.INSTANCE.getUSELESS_CAST();
    }

    public static final /* synthetic */ Applicability access$checkIsApplicability(FirCastOperatorsChecker $this, TypeInfo l2, TypeInfo r2, FirTypeOperatorCall expression, CheckerContext context) {
        return $this.checkIsApplicability(l2, r2, expression, context);
    }

    public static final /* synthetic */ Applicability access$checkAsApplicability(FirCastOperatorsChecker $this, TypeInfo l2, TypeInfo r2, FirTypeOperatorCall expression, CheckerContext context) {
        return $this.checkAsApplicability(l2, r2, expression, context);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCastOperatorsChecker$Applicability;", "", "<init>", "(Ljava/lang/String;I)V", "APPLICABLE", "IMPOSSIBLE_CAST", "IMPOSSIBLE_IS_CHECK", "USELESS_CAST", "USELESS_IS_CHECK", "CAST_ERASED", "checkers"})
    private static final class Applicability
    extends Enum<Applicability> {
        public static final /* enum */ Applicability APPLICABLE = new Applicability();
        public static final /* enum */ Applicability IMPOSSIBLE_CAST = new Applicability();
        public static final /* enum */ Applicability IMPOSSIBLE_IS_CHECK = new Applicability();
        public static final /* enum */ Applicability USELESS_CAST = new Applicability();
        public static final /* enum */ Applicability USELESS_IS_CHECK = new Applicability();
        public static final /* enum */ Applicability CAST_ERASED = new Applicability();
        private static final /* synthetic */ Applicability[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Applicability[] values() {
            return (Applicability[])$VALUES.clone();
        }

        public static Applicability valueOf(String value2) {
            return Enum.valueOf(Applicability.class, value2);
        }

        @NotNull
        public static EnumEntries<Applicability> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = applicabilityArray = new Applicability[]{Applicability.APPLICABLE, Applicability.IMPOSSIBLE_CAST, Applicability.IMPOSSIBLE_IS_CHECK, Applicability.USELESS_CAST, Applicability.USELESS_IS_CHECK, Applicability.CAST_ERASED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.IS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.AS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.SAFE_AS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Applicability.values().length];
            try {
                nArray[Applicability.APPLICABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.IMPOSSIBLE_CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.USELESS_CAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.IMPOSSIBLE_IS_CHECK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.USELESS_IS_CHECK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Applicability.CAST_ERASED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

