/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirClassReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0005H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0006"}, d2={"isUnitBlock", "", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "(Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)Z", "hasSideEffect", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers"})
public final class FirUnusedCheckerBaseKt {
    private static final boolean isUnitBlock(FirStatement $this$isUnitBlock) {
        FirSingleExpressionBlock firSingleExpressionBlock = $this$isUnitBlock instanceof FirSingleExpressionBlock ? (FirSingleExpressionBlock)$this$isUnitBlock : null;
        if (firSingleExpressionBlock == null) {
            return false;
        }
        FirSingleExpressionBlock block = firSingleExpressionBlock;
        FirStatement firStatement = block.getStatement();
        FirResolvedQualifier firResolvedQualifier = firStatement instanceof FirResolvedQualifier ? (FirResolvedQualifier)firStatement : null;
        if (firResolvedQualifier == null) {
            return false;
        }
        FirResolvedQualifier qualifier = firResolvedQualifier;
        return Intrinsics.areEqual(qualifier.getClassId(), StandardClassIds.INSTANCE.getUnit());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasSideEffect(FirExpression $this$hasSideEffect) {
        FirExpression firExpression = $this$hasSideEffect;
        if (firExpression instanceof FirLiteralExpression) return false;
        if (firExpression instanceof FirClassReferenceExpression) return false;
        if (firExpression instanceof FirResolvedQualifier) return false;
        if (firExpression instanceof FirThisReceiverExpression) {
            return false;
        }
        if (firExpression instanceof FirAnonymousFunctionExpression) {
            return false;
        }
        if (!(firExpression instanceof FirSmartCastExpression)) {
            if (firExpression instanceof FirCallableReferenceAccess) {
                boolean bl;
                boolean bl2;
                FirExpression firExpression2 = ((FirCallableReferenceAccess)$this$hasSideEffect).getDispatchReceiver();
                if (firExpression2 != null) {
                    if (FirUnusedCheckerBaseKt.hasSideEffect(firExpression2)) {
                        return true;
                    }
                    bl2 = false;
                } else {
                    bl2 = false;
                }
                if (bl2) return true;
                FirExpression firExpression3 = ((FirCallableReferenceAccess)$this$hasSideEffect).getExtensionReceiver();
                if (firExpression3 != null) {
                    if (FirUnusedCheckerBaseKt.hasSideEffect(firExpression3)) {
                        return true;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
                if (bl) return true;
                FirExpression firExpression4 = ((FirCallableReferenceAccess)$this$hasSideEffect).getExplicitReceiver();
                if (firExpression4 == null) return false;
                if (!FirUnusedCheckerBaseKt.hasSideEffect(firExpression4)) return false;
                return true;
            }
            if (firExpression instanceof FirStringConcatenationCall || firExpression instanceof FirGetClassCall) {
                FirExpression it;
                FirCall $this$arguments$iv = (FirCall)((Object)$this$hasSideEffect);
                boolean $i$f$getArguments = false;
                Iterable $this$any$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    Object element$iv = iterator2.next();
                    it = (FirExpression)element$iv;
                    boolean bl = false;
                } while (!FirUnusedCheckerBaseKt.hasSideEffect(it));
                return true;
            }
            if (!(firExpression instanceof FirPropertyAccessExpression)) return true;
            KtSourceElement ktSourceElement = ((FirPropertyAccessExpression)$this$hasSideEffect).getSource();
            if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE)) {
                return true;
            }
            FirBasedSymbol<?> propertySymbol = FirReferenceUtilsKt.getSymbol(((FirPropertyAccessExpression)$this$hasSideEffect).getCalleeReference());
            if (propertySymbol instanceof FirValueParameterSymbol) return false;
            if (propertySymbol instanceof FirReceiverParameterSymbol) {
                return false;
            }
            if (!(propertySymbol instanceof FirPropertySymbol)) return true;
            if (!((FirPropertySymbol)propertySymbol).isLocal()) return true;
            if (!((FirPropertySymbol)propertySymbol).getHasDelegate()) return false;
            return true;
        }
        boolean bl = FirUnusedCheckerBaseKt.hasSideEffect(((FirSmartCastExpression)$this$hasSideEffect).getOriginalExpression());
        return bl;
    }

    public static final /* synthetic */ boolean access$hasSideEffect(FirExpression $receiver) {
        return FirUnusedCheckerBaseKt.hasSideEffect($receiver);
    }

    public static final /* synthetic */ boolean access$isUnitBlock(FirStatement $receiver) {
        return FirUnusedCheckerBaseKt.isUnitBlock($receiver);
    }
}

