/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.CheckResult;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.OperatorFunctionChecks;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "checkers"})
public final class FirOperatorModifierChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirOperatorModifierChecker INSTANCE = new FirOperatorModifierChecker();

    private FirOperatorModifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirMemberDeclaration $this$isOperator$iv = declaration;
        boolean $i$f$isOperator = false;
        if (!$this$isOperator$iv.getStatus().isOperator()) {
            return;
        }
        FirElement firElement = declaration;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPERATOR_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "OPERATOR_KEYWORD");
        if (!FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) {
            return;
        }
        CheckResult checkResult = OperatorFunctionChecks.INSTANCE.isOperator(declaration, context.getSession(), context.getScopeSession());
        if (!Intrinsics.areEqual(checkResult, CheckResult.SuccessCheck.INSTANCE)) {
            if (Intrinsics.areEqual(checkResult, CheckResult.IllegalFunctionName.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_OPERATOR_MODIFIER(), (Object)"illegal function name", null, 16, null);
            } else if (checkResult instanceof CheckResult.IllegalSignature) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_OPERATOR_MODIFIER(), (Object)((CheckResult.IllegalSignature)checkResult).getError(), null, 16, null);
            } else if (Intrinsics.areEqual(checkResult, CheckResult.AnonymousOperatorFunction.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_OPERATOR_MODIFIER(), (Object)"anonymous function", null, 16, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

