/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSyntaxDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCallCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeConstraintSystemHasContradiction;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeHiddenCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ*\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002J\u000e\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u0015H\u0002JH\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002J(\u0010 \u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002R\u001a\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0018\u0010%\u001a\u00020\u0012*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u0004\u0018\u00010\u001f*\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "checkInitializer", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "initializer", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isMissingInitializer", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "checkComponentCall", "destructuringDeclarationType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "property", "componentCall", "Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;", "destructuringDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "reportDefaultDiagnostics", "explicitReceiverOfQualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "getExplicitReceiverOfQualifiedAccess", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "unwrapped", "getUnwrapped", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "resolvedVariable", "getResolvedVariable", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "checkers"})
public final class FirDestructuringDeclarationChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirDestructuringDeclarationChecker INSTANCE = new FirDestructuringDeclarationChecker();

    private FirDestructuringDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration) {
        ConeDiagnostic diagnostic;
        FirElement firElement;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        KtSourceElement ktSourceElement = declaration.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (Intrinsics.areEqual(source.getElementType(), KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            this.checkInitializer(source, declaration.getInitializer(), reporter, context);
            return;
        }
        if (!Intrinsics.areEqual(source.getElementType(), KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
            return;
        }
        FirExpression firExpression = declaration.getInitializer();
        FirComponentCall firComponentCall = firExpression instanceof FirComponentCall ? (FirComponentCall)firExpression : null;
        if (firComponentCall == null) {
            return;
        }
        FirComponentCall componentCall = firComponentCall;
        FirQualifiedAccessExpression firQualifiedAccessExpression = this.getExplicitReceiverOfQualifiedAccess(componentCall);
        if (firQualifiedAccessExpression == null) {
            return;
        }
        FirQualifiedAccessExpression originalExpression2 = firQualifiedAccessExpression;
        FirVariable firVariable = this.getResolvedVariable(originalExpression2);
        if (firVariable == null) {
            return;
        }
        FirVariable originalDestructuringDeclaration = firVariable;
        FirVariable firVariable2 = originalDestructuringDeclaration;
        if (firVariable2 instanceof FirProperty) {
            FirExpression firExpression2;
            Object object = ((FirProperty)originalDestructuringDeclaration).getInitializer();
            if (Intrinsics.areEqual(object != null && (object = ((FirExpression)object).getSource()) != null ? ((KtSourceElement)object).getElementType() : null, KtNodeTypes.FOR)) {
                FirQualifiedAccessExpression iterator2;
                FirExpression firExpression3 = ((FirProperty)originalDestructuringDeclaration).getInitializer();
                FirQualifiedAccessExpression firQualifiedAccessExpression2 = iterator2 = firExpression3 != null ? this.getExplicitReceiverOfQualifiedAccess(firExpression3) : null;
                FirVariable firVariable3 = firQualifiedAccessExpression2 != null ? this.getResolvedVariable(firQualifiedAccessExpression2) : null;
                FirPureAbstractElement firPureAbstractElement = firVariable3 instanceof FirProperty ? (FirProperty)firVariable3 : null;
                firExpression2 = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getInitializer()) != null ? this.getExplicitReceiverOfQualifiedAccess((FirExpression)firPureAbstractElement) : null;
            } else {
                firExpression2 = ((FirProperty)originalDestructuringDeclaration).getInitializer();
            }
            firElement = firExpression2;
        } else {
            firElement = firVariable2 instanceof FirValueParameter ? (FirElement)originalDestructuringDeclaration : null;
        }
        if (firElement == null) {
            return;
        }
        FirElement originalDestructuringDeclarationOrInitializer = firElement;
        if (this.isMissingInitializer(originalDestructuringDeclarationOrInitializer)) {
            return;
        }
        KtSourceElement ktSourceElement2 = originalDestructuringDeclarationOrInitializer.getSource();
        if (ktSourceElement2 == null) {
            return;
        }
        KtSourceElement originalDestructuringDeclarationOrInitializerSource = ktSourceElement2;
        FirElement firElement2 = originalDestructuringDeclarationOrInitializer;
        ConeKotlinType coneKotlinType = firElement2 instanceof FirVariable ? FirTypeUtilsKt.getConeType(((FirVariable)originalDestructuringDeclarationOrInitializer).getReturnTypeRef()) : (firElement2 instanceof FirExpression ? FirTypeUtilsKt.getResolvedType((FirExpression)originalDestructuringDeclarationOrInitializer) : null);
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType originalDestructuringDeclarationType = coneKotlinType;
        FirNamedReference reference = componentCall.getCalleeReference();
        ConeDiagnostic coneDiagnostic = diagnostic = FirReferenceUtilsKt.isError(reference) ? ((FirDiagnosticHolder)((Object)reference)).getDiagnostic() : null;
        if (diagnostic != null) {
            this.checkComponentCall(originalDestructuringDeclarationOrInitializerSource, originalDestructuringDeclarationType, diagnostic, declaration, componentCall, originalDestructuringDeclaration, reporter, context);
        }
    }

    private final void checkInitializer(KtSourceElement source, FirExpression initializer, DiagnosticReporter reporter, CheckerContext context) {
        if (this.isMissingInitializer(initializer)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINITIALIZER_REQUIRED_FOR_DESTRUCTURING_DECLARATION(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean isMissingInitializer(FirElement $this$isMissingInitializer) {
        return $this$isMissingInitializer == null || $this$isMissingInitializer instanceof FirErrorExpression && ((FirErrorExpression)$this$isMissingInitializer).getDiagnostic() instanceof ConeSyntaxDiagnostic;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkComponentCall(KtSourceElement source, ConeKotlinType destructuringDeclarationType, ConeDiagnostic diagnostic, FirProperty property, FirComponentCall componentCall, FirVariable destructuringDeclaration, DiagnosticReporter reporter, CheckerContext context) {
        ConeDiagnostic coneDiagnostic = diagnostic;
        if (coneDiagnostic instanceof ConeUnresolvedNameError) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeUnresolvedNameError)diagnostic).getName(), (Object)destructuringDeclarationType, (DiagnosticContext)context, null, 32, null);
        } else if (coneDiagnostic instanceof ConeHiddenCandidateError) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeHiddenCandidateError)diagnostic).getCandidate().getCallInfo().getName(), (Object)destructuringDeclarationType, (DiagnosticContext)context, null, 32, null);
        } else if (coneDiagnostic instanceof ConeInapplicableWrongReceiver) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((AbstractCallCandidate)CollectionsKt.first((Iterable)((ConeInapplicableWrongReceiver)diagnostic).getCandidates())).getCallInfo().getName(), (Object)destructuringDeclarationType, (DiagnosticContext)context, null, 32, null);
        } else if (coneDiagnostic instanceof ConeAmbiguityError && CandidateApplicabilityKt.isSuccess(((ConeAmbiguityError)diagnostic).getApplicability())) {
            Collection<FirBasedSymbol<?>> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
            Name name = ((ConeAmbiguityError)diagnostic).getName();
            KtDiagnosticFactory2<Name, Collection<FirBasedSymbol<?>>> ktDiagnosticFactory2 = FirErrors.INSTANCE.getCOMPONENT_FUNCTION_AMBIGUITY();
            AbstractKtSourceElement abstractKtSourceElement = source;
            DiagnosticReporter diagnosticReporter = reporter;
            boolean $i$f$map = false;
            void var12_18 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AbstractCandidate abstractCandidate = (AbstractCandidate)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSymbol());
            }
            collection = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory2, (Object)name, collection, (DiagnosticContext)context, null, 32, null);
        } else if (coneDiagnostic instanceof ConeAmbiguityError) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeAmbiguityError)diagnostic).getName(), (Object)destructuringDeclarationType, (DiagnosticContext)context, null, 32, null);
        } else if (coneDiagnostic instanceof ConeInapplicableCandidateError) {
            if (ConeTypeUtilsKt.isMarkedNullable(TypeExpansionUtilsKt.fullyExpandedType$default(destructuringDeclarationType, context.getSession(), null, 2, null))) {
                AbstractKtSourceElement abstractKtSourceElement = source;
                KtDiagnosticFactory1<Name> ktDiagnosticFactory1 = FirErrors.INSTANCE.getCOMPONENT_FUNCTION_ON_NULLABLE();
                FirBasedSymbol<?> firBasedSymbol = ((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol();
                Intrinsics.checkNotNull(firBasedSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)((FirNamedFunctionSymbol)firBasedSymbol).getCallableId().getCallableName(), (DiagnosticContext)context, null, 16, null);
            } else {
                this.reportDefaultDiagnostics(diagnostic, componentCall, reporter, context);
            }
        } else if (coneDiagnostic instanceof ConeConstraintSystemHasContradiction) {
            ConeKotlinType componentType = FirTypeUtilsKt.getResolvedType(componentCall);
            if (componentType instanceof ConeErrorType) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((AbstractCallCandidate)CollectionsKt.first((Iterable)((ConeConstraintSystemHasContradiction)diagnostic).getCandidates())).getCallInfo().getName(), (Object)destructuringDeclarationType, (DiagnosticContext)context, null, 32, null);
                return;
            }
            ConeKotlinType expectedType = FirTypeUtilsKt.getConeType(property.getReturnTypeRef());
            if (!AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context.getSession()), (KotlinTypeMarker)componentType, (KotlinTypeMarker)expectedType, false, 8, null)) {
                KtSourceElement typeMismatchSource = destructuringDeclaration instanceof FirValueParameter ? property.getSource() : source;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeMismatchSource, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_RETURN_TYPE_MISMATCH(), (Object)((ConeConstraintSystemHasContradiction)diagnostic).getCandidate().getCallInfo().getName(), (Object)componentType, (Object)expectedType, (DiagnosticContext)context, null, 64, null);
            } else {
                this.reportDefaultDiagnostics(diagnostic, componentCall, reporter, context);
            }
        } else if (coneDiagnostic instanceof ConeVisibilityError) {
            reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(((ConeVisibilityError)diagnostic).getSymbol(), property.getSource(), context.getSession()), context);
        } else {
            this.reportDefaultDiagnostics(diagnostic, componentCall, reporter, context);
        }
    }

    private final void reportDefaultDiagnostics(ConeDiagnostic diagnostic, FirComponentCall componentCall, DiagnosticReporter reporter, CheckerContext context) {
        for (KtDiagnostic coneDiagnostic : ConeDiagnosticToFirDiagnosticKt.toFirDiagnostics(diagnostic, context.getSession(), componentCall.getSource(), null)) {
            reporter.report(coneDiagnostic, context);
        }
    }

    private final FirQualifiedAccessExpression getExplicitReceiverOfQualifiedAccess(FirExpression $this$explicitReceiverOfQualifiedAccess) {
        FirExpression firExpression = $this$explicitReceiverOfQualifiedAccess instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)$this$explicitReceiverOfQualifiedAccess : null;
        FirExpression firExpression2 = firExpression != null && (firExpression = firExpression.getExplicitReceiver()) != null ? this.getUnwrapped(firExpression) : null;
        return firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
    }

    private final FirExpression getUnwrapped(FirExpression $this$unwrapped) {
        FirExpression firExpression = $this$unwrapped;
        return firExpression instanceof FirSmartCastExpression ? ((FirSmartCastExpression)$this$unwrapped).getOriginalExpression() : (firExpression instanceof FirWrappedExpression ? ((FirWrappedExpression)$this$unwrapped).getExpression() : $this$unwrapped);
    }

    private final FirVariable getResolvedVariable(FirQualifiedAccessExpression $this$resolvedVariable) {
        FirVariableSymbol firVariableSymbol = FirReferenceUtilsKt.toResolvedVariableSymbol$default($this$resolvedVariable.getCalleeReference(), false, 1, null);
        if (firVariableSymbol == null) {
            return null;
        }
        FirVariableSymbol symbol = firVariableSymbol;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(symbol, FirResolvePhase.BODY_RESOLVE);
        return (FirVariable)symbol.getFir();
    }
}

