/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.types.EnrichedProjectionKind;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ$\u0010\u000e\u001a\u00020\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J.\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J4\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002JP\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001f\u001a\u00020 H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassVarianceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkCallableDeclaration", "member", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkTypeParameters", "typeParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "checkVarianceConflict", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "containingType", "isInAbbreviation", "", "checkers"})
public final class FirClassVarianceChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirClassVarianceChecker INSTANCE = new FirClassVarianceChecker();

    private FirClassVarianceChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Iterable iterable = declaration.getTypeParameters();
        FirClassVarianceChecker firClassVarianceChecker = this;
        boolean $i$f$filterIsInstance = false;
        void var6_8 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirTypeParameter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        firClassVarianceChecker.checkTypeParameters((List)destination$iv$iv, Variance.OUT_VARIANCE, context, reporter);
        for (FirTypeRef superTypeRef : declaration.getSuperTypeRefs()) {
            FirClassVarianceChecker.checkVarianceConflict$default(this, superTypeRef, Variance.OUT_VARIANCE, context, reporter, null, 16, null);
        }
        DeclarationUtilsKt.processAllDeclarations$default(declaration, context.getSession(), null, arg_0 -> FirClassVarianceChecker.check$lambda$1(context, reporter, arg_0), 2, null);
    }

    private final void checkCallableDeclaration(FirCallableSymbol<?> member, CheckerContext context, DiagnosticReporter reporter) {
        KtSourceElement memberSource = member.getSource();
        if (member instanceof FirNamedFunctionSymbol && memberSource != null && !(memberSource.getKind() instanceof KtFakeSourceElementKind)) {
            for (FirValueParameterSymbol param : ((FirNamedFunctionSymbol)member).getValueParameterSymbols()) {
                FirClassVarianceChecker.checkVarianceConflict$default(this, param.getResolvedReturnTypeRef(), Variance.IN_VARIANCE, context, reporter, null, 16, null);
            }
        }
        Variance returnTypeVariance = member instanceof FirPropertySymbol && ((FirPropertySymbol)member).isVar() ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        KtSourceElement returnSource = member.getResolvedReturnTypeRef().getSource();
        if (returnSource != null) {
            if (memberSource != null && returnSource.getKind() instanceof KtFakeSourceElementKind && !(memberSource.getKind() instanceof KtFakeSourceElementKind)) {
                returnSource = memberSource;
            }
        } else {
            returnSource = memberSource;
        }
        this.checkVarianceConflict(member.getResolvedReturnTypeRef(), returnTypeVariance, context, reporter, returnSource);
        FirResolvedTypeRef receiverTypeRef = member.getResolvedReceiverTypeRef();
        if (receiverTypeRef != null) {
            FirClassVarianceChecker.checkVarianceConflict$default(this, receiverTypeRef, Variance.IN_VARIANCE, context, reporter, null, 16, null);
        }
    }

    private final void checkTypeParameters(List<FirTypeParameterSymbol> typeParameters2, Variance variance, CheckerContext context, DiagnosticReporter reporter) {
        for (FirTypeParameterSymbol typeParameter : typeParameters2) {
            for (FirResolvedTypeRef bound : typeParameter.getResolvedBounds()) {
                FirClassVarianceChecker.checkVarianceConflict$default(this, bound, variance, context, reporter, null, 16, null);
            }
        }
    }

    private final void checkVarianceConflict(FirTypeRef typeRef, Variance variance, CheckerContext context, DiagnosticReporter reporter, KtSourceElement source) {
        ConeKotlinType expandedType = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(typeRef), context.getSession(), null, 2, null);
        KtSourceElement ktSourceElement = source;
        if (ktSourceElement == null) {
            ktSourceElement = typeRef.getSource();
        }
        FirClassVarianceChecker.checkVarianceConflict$default(this, expandedType, variance, typeRef, expandedType, context, reporter, ktSourceElement, false, 128, null);
    }

    static /* synthetic */ void checkVarianceConflict$default(FirClassVarianceChecker firClassVarianceChecker, FirTypeRef firTypeRef, Variance variance, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            ktSourceElement = null;
        }
        firClassVarianceChecker.checkVarianceConflict(firTypeRef, variance, checkerContext, diagnosticReporter, ktSourceElement);
    }

    private final void checkVarianceConflict(ConeKotlinType type2, Variance variance, FirTypeRef typeRef, ConeKotlinType containingType, CheckerContext context, DiagnosticReporter reporter, KtSourceElement source, boolean isInAbbreviation) {
        ConeClassLikeType fullyExpandedType2;
        FirClassLikeSymbol<?> classSymbol;
        if (type2 instanceof ConeTypeParameterType) {
            KtSourceElement resultSource;
            ConeSimpleKotlinType fullyExpandedType3 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeSimpleKotlinType)type2, context.getSession(), null, 2, null);
            FirTypeParameterSymbol typeParameterSymbol = ((ConeTypeParameterType)type2).getLookupTag().getTypeParameterSymbol();
            KtSourceElement ktSourceElement = source;
            if (ktSourceElement == null) {
                FirTypeRef firTypeRef = typeRef;
                ktSourceElement = firTypeRef != null ? firTypeRef.getSource() : null;
            }
            if ((resultSource = ktSourceElement) != null && !typeParameterSymbol.getVariance().allowsPosition(variance) && !fullyExpandedType3.getAttributes().contains(CompilerConeAttributes.UnsafeVariance.INSTANCE)) {
                KtDiagnosticFactory4<FirTypeParameterSymbol, Variance, Variance, ConeKotlinType> factory2 = isInAbbreviation ? FirErrors.INSTANCE.getTYPE_VARIANCE_CONFLICT_IN_EXPANDED_TYPE() : FirErrors.INSTANCE.getTYPE_VARIANCE_CONFLICT_ERROR();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resultSource, factory2, (Object)typeParameterSymbol, (Object)typeParameterSymbol.getVariance(), (Object)variance, (Object)containingType, (DiagnosticContext)context, null, 128, null);
            }
            return;
        }
        if (type2 instanceof ConeClassLikeType && (classSymbol = ToSymbolUtilsKt.toSymbol((fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)type2, context.getSession(), null, 2, null)).getLookupTag(), context.getSession())) instanceof FirClassSymbol) {
            List<FirTypeRefSource> typeRefAndSourcesForArguments = FirHelpersKt.extractArgumentsTypeRefAndSource(typeRef);
            ConeTypeProjection[] coneTypeProjectionArray = fullyExpandedType2.getTypeArguments();
            int n2 = coneTypeProjectionArray.length;
            block11: for (int i2 = 0; i2 < n2; ++i2) {
                ConeKotlinType typeArgumentType;
                FirTypeRefSource subTypeRefAndSource;
                Variance variance2;
                Variance variance3;
                int index2 = i2;
                ConeTypeProjection typeArgument = coneTypeProjectionArray[i2];
                Object object = CollectionsKt.getOrNull(((FirClassSymbol)classSymbol).getTypeParameterSymbols(), index2);
                if (object == null || (object = object.getVariance()) == null) continue;
                Object paramVariance = object;
                switch (WhenMappings.$EnumSwitchMapping$0[typeArgument.getKind().ordinal()]) {
                    case 1: {
                        variance3 = Variance.IN_VARIANCE;
                        break;
                    }
                    case 2: {
                        variance3 = Variance.OUT_VARIANCE;
                        break;
                    }
                    case 3: {
                        variance3 = Variance.INVARIANT;
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                Variance argVariance = variance3;
                if (ConeTypeProjectionKt.getType(typeArgument) == null) continue;
                switch (WhenMappings.$EnumSwitchMapping$1[EnrichedProjectionKind.Companion.getEffectiveProjectionKind((Variance)((Object)paramVariance), argVariance).ordinal()]) {
                    case 1: {
                        variance2 = variance;
                        break;
                    }
                    case 2: {
                        variance2 = variance.opposite();
                        break;
                    }
                    case 3: {
                        variance2 = Variance.INVARIANT;
                        break;
                    }
                    case 4: {
                        variance2 = null;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Variance newVariance = variance2;
                if (newVariance == null) continue;
                List<FirTypeRefSource> list = typeRefAndSourcesForArguments;
                FirTypeRefSource firTypeRefSource = subTypeRefAndSource = list != null ? CollectionsKt.getOrNull(list, index2) : null;
                FirTypeRef firTypeRef = firTypeRefSource != null ? firTypeRefSource.getTypeRef() : null;
                Object object2 = subTypeRefAndSource;
                if (object2 == null || (object2 = ((FirTypeRefSource)object2).getTypeRef()) == null || (object2 = ((FirTypeRef)object2).getSource()) == null) {
                    object2 = source;
                }
                this.checkVarianceConflict(typeArgumentType, newVariance, firTypeRef, containingType, context, reporter, (KtSourceElement)object2, AbbreviatedTypeAttributeKt.isTypealiasExpansion(type2));
            }
        }
    }

    static /* synthetic */ void checkVarianceConflict$default(FirClassVarianceChecker firClassVarianceChecker, ConeKotlinType coneKotlinType, Variance variance, FirTypeRef firTypeRef, ConeKotlinType coneKotlinType2, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, boolean bl, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            ktSourceElement = null;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        firClassVarianceChecker.checkVarianceConflict(coneKotlinType, variance, firTypeRef, coneKotlinType2, checkerContext, diagnosticReporter, ktSourceElement, bl);
    }

    private static final Unit check$lambda$1(CheckerContext $context, DiagnosticReporter $reporter, FirBasedSymbol member) {
        Intrinsics.checkNotNullParameter(member, "member");
        if (member instanceof FirCallableSymbol) {
            if (Visibilities.INSTANCE.isPrivate(((FirCallableSymbol)member).getResolvedStatus().getVisibility())) {
                return Unit.INSTANCE;
            }
            INSTANCE.checkTypeParameters(((FirCallableSymbol)member).getOwnTypeParameterSymbols(), Variance.IN_VARIANCE, $context, $reporter);
            INSTANCE.checkCallableDeclaration((FirCallableSymbol)member, $context, $reporter);
        }
        if (member instanceof FirClassLikeSymbol) {
            if (Visibilities.INSTANCE.isPrivate(((FirClassLikeSymbol)member).getResolvedStatus().getVisibility())) {
                return Unit.INSTANCE;
            }
            if (!(member instanceof FirClassSymbol)) {
                INSTANCE.checkTypeParameters(((FirClassLikeSymbol)member).getOwnTypeParameterSymbols(), Variance.IN_VARIANCE, $context, $reporter);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProjectionKind.values().length];
            try {
                nArray[ProjectionKind.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.INVARIANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[EnrichedProjectionKind.values().length];
            try {
                nArray[EnrichedProjectionKind.OUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

