/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMapKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubTypeForTypeVariableInSubtyping;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUnificationKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0003\u001a\u001e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003\u001a(\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a \u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002\u00a8\u0006\u0013"}, d2={"isCastErased", "", "supertype", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "subtype", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "findStaticallyKnownSubtype", "subTypeClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "isNonReifiedTypeParameter", "isUpcast", "candidateType", "targetType", "isRefinementUseless", "lhsType", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "isExactTypeCast", "checkers"})
public final class FirCastDiagnosticsHelpersKt {
    public static final boolean isCastErased(@NotNull ConeKotlinType supertype, @NotNull ConeKotlinType subtype, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter(supertype, "supertype");
        Intrinsics.checkNotNullParameter(subtype, "subtype");
        Intrinsics.checkNotNullParameter(context, "context");
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(context.getSession());
        boolean isNonReifiedTypeParameter = FirCastDiagnosticsHelpersKt.isNonReifiedTypeParameter(subtype);
        boolean isUpcast = FirCastDiagnosticsHelpersKt.isUpcast(context, supertype, subtype);
        if (isNonReifiedTypeParameter && !isUpcast) {
            boolean nullableToDefinitelyNotNull;
            boolean bl = nullableToDefinitelyNotNull = !TypeUtilsKt.canBeNull(subtype, context.getSession()) && Intrinsics.areEqual(TypeUtilsKt.withNullability$default(supertype, false, typeContext2, null, false, 12, null), subtype);
            if (!nullableToDefinitelyNotNull) {
                return true;
            }
        }
        if (!(supertype instanceof ConeErrorType) && ConeTypeUtilsKt.isMarkedNullable(supertype) || !(subtype instanceof ConeErrorType) && ConeTypeUtilsKt.isMarkedNullable(subtype)) {
            return FirCastDiagnosticsHelpersKt.isCastErased(TypeUtilsKt.withNullability$default(supertype, false, typeContext2, null, false, 12, null), TypeUtilsKt.withNullability$default(subtype, false, typeContext2, null, false, 12, null), context);
        }
        if (isUpcast) {
            return false;
        }
        if (isNonReifiedTypeParameter) {
            return true;
        }
        if (subtype instanceof ConeTypeParameterType) {
            return false;
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(subtype, context.getSession());
        if (firRegularClassSymbol == null) {
            return true;
        }
        FirRegularClassSymbol regularClassSymbol = firRegularClassSymbol;
        Set<FirClassLikeSymbol<?>> outerClasses = LookupTagUtilsKt.getClassAndItsOuterClassesWhenLocal(regularClassSymbol, context.getSession());
        FirClassLikeSymbol $this$isLocal$iv = regularClassSymbol;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getClassId().isLocal()) {
            boolean bl;
            block12: {
                Iterable $this$any$iv = regularClassSymbol.getTypeParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                        boolean bl2 = false;
                        if (!(!CollectionsKt.contains((Iterable)outerClasses, it.getContainingDeclarationSymbol()))) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
        }
        ConeKotlinType staticallyKnownSubtype = FirCastDiagnosticsHelpersKt.findStaticallyKnownSubtype(supertype, regularClassSymbol, context);
        return !AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context.getSession()).newTypeCheckerState(true, false, false), (KotlinTypeMarker)staticallyKnownSubtype, (KotlinTypeMarker)subtype, false, 8, null);
    }

    @NotNull
    public static final ConeKotlinType findStaticallyKnownSubtype(@NotNull ConeKotlinType supertype, @NotNull FirRegularClassSymbol subTypeClassSymbol, @NotNull CheckerContext context) {
        Collection collection;
        boolean bl;
        Intrinsics.checkNotNullParameter(supertype, "supertype");
        Intrinsics.checkNotNullParameter(subTypeClassSymbol, "subTypeClassSymbol");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean bl2 = bl = !ConeTypeUtilsKt.isMarkedNullable(supertype);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FirCastDiagnosticsHelpersKt$findStaticallyKnownSubtype$22 = false;
            String $i$a$-assert-FirCastDiagnosticsHelpersKt$findStaticallyKnownSubtype$22 = "This method only makes sense for non-nullable types";
            throw new AssertionError((Object)$i$a$-assert-FirCastDiagnosticsHelpersKt$findStaticallyKnownSubtype$22);
        }
        FirSession session = context.getSession();
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(session);
        ConeClassLikeType subtypeWithVariablesType = ScopeUtilsKt.defaultType(subTypeClassSymbol);
        TypeCheckerState typeCheckerState = TypeCheckerProviderContext.newTypeCheckerState$default(TypeComponentsKt.getTypeContext(context.getSession()), false, false, false, 4, null);
        if (supertype instanceof ConeIntersectionType) {
            collection = ((ConeIntersectionType)supertype).getIntersectedTypes();
        } else {
            ArrayList<ConeKotlinType> arrayList = new ArrayList<ConeKotlinType>(1);
            ArrayList<ConeKotlinType> it = arrayList;
            boolean bl3 = false;
            it.add(supertype);
            collection = arrayList;
        }
        Collection normalizedTypes = collection;
        Map resultSubstitution = new LinkedHashMap();
        for (ConeKotlinType normalizedType : normalizedTypes) {
            Map map2;
            RigidTypeMarker supertypeWithVariables = CollectionsKt.firstOrNull(AbstractTypeChecker.INSTANCE.findCorrespondingSupertypes(typeCheckerState, subtypeWithVariablesType, TypeSystemContextHelpersKt.typeConstructor(normalizedType, typeContext2)));
            List<FirTypeParameterSymbol> variables = subTypeClassSymbol.getTypeParameterSymbols();
            if (supertypeWithVariables != null) {
                Map result2 = new LinkedHashMap();
                map2 = TypeUnificationKt.doUnify(context.getSession(), supertype, (ConeKotlinTypeProjection)((Object)supertypeWithVariables), CollectionsKt.toSet((Iterable)variables), result2) ? result2 : (Map)new LinkedHashMap();
            } else {
                map2 = new LinkedHashMap();
            }
            Map substitution = map2;
            for (FirTypeParameterSymbol variable : variables) {
                ConeTypeProjection value2 = (ConeTypeProjection)substitution.get(variable);
                ConeKotlinType resultValue = value2 == null ? null : (value2 instanceof ConeStarProjection ? (ConeKotlinType)new ConeStubTypeForTypeVariableInSubtyping(new ConeTypeVariable("", null), true) : ConeTypeProjectionKt.getType(value2));
                if (resultValue == null) continue;
                resultSubstitution.put(variable, resultValue);
            }
        }
        ConeSubstitutor substitutor2 = ConeSubstitutorByMapKt.substitutorByMap$default(resultSubstitution, session, false, 4, null);
        return substitutor2.substituteOrSelf(subtypeWithVariablesType);
    }

    public static final boolean isNonReifiedTypeParameter(@NotNull ConeKotlinType $this$isNonReifiedTypeParameter) {
        Intrinsics.checkNotNullParameter($this$isNonReifiedTypeParameter, "<this>");
        return $this$isNonReifiedTypeParameter instanceof ConeTypeParameterType && !((ConeTypeParameterType)$this$isNonReifiedTypeParameter).getLookupTag().getTypeParameterSymbol().isReified();
    }

    public static final boolean isUpcast(@NotNull CheckerContext context, @NotNull ConeKotlinType candidateType, @NotNull ConeKotlinType targetType) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(candidateType, "candidateType");
        Intrinsics.checkNotNullParameter(targetType, "targetType");
        return AbstractTypeChecker.INSTANCE.isSubtypeOf(TypeComponentsKt.getTypeContext(context.getSession()), (KotlinTypeMarker)candidateType, (KotlinTypeMarker)targetType, false);
    }

    public static final boolean isRefinementUseless(@NotNull CheckerContext context, @NotNull ConeKotlinType lhsType, @NotNull ConeKotlinType targetType, @NotNull FirTypeOperatorCall expression) {
        boolean bl;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(lhsType, "lhsType");
        Intrinsics.checkNotNullParameter(targetType, "targetType");
        Intrinsics.checkNotNullParameter(expression, "expression");
        if (lhsType instanceof ConeErrorType || targetType instanceof ConeErrorType) {
            return false;
        }
        FirCall $this$argument$iv = expression;
        boolean $i$f$getArgument = false;
        FirExpression arg = CollectionsKt.first($this$argument$iv.getArgumentList().getArguments());
        switch (WhenMappings.$EnumSwitchMapping$0[expression.getOperation().ordinal()]) {
            case 1: 
            case 2: {
                if (arg instanceof FirFunctionCall) {
                    FirFunctionSymbol functionSymbol;
                    FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(arg, context.getSession());
                    FirFunctionSymbol firFunctionSymbol = functionSymbol = firCallableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol : null;
                    if (functionSymbol != null && FirHelpersKt.isFunctionForExpectTypeFromCastFeature(functionSymbol)) {
                        return false;
                    }
                }
                ConeKotlinType refinedTargetType = expression.getOperation() == FirOperation.SAFE_AS && ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(lhsType) ? TypeUtilsKt.withNullability$default(targetType, true, TypeComponentsKt.getTypeContext(context.getSession()), null, false, 12, null) : targetType;
                bl = FirCastDiagnosticsHelpersKt.isExactTypeCast(context, lhsType, refinedTargetType);
                break;
            }
            case 3: 
            case 4: {
                bl = FirCastDiagnosticsHelpersKt.isUpcast(context, lhsType, targetType);
                break;
            }
            default: {
                throw new AssertionError((Object)("Should not be here: " + (Object)((Object)expression.getOperation())));
            }
        }
        return bl;
    }

    private static final boolean isExactTypeCast(CheckerContext context, ConeKotlinType lhsType, ConeKotlinType targetType) {
        return AbstractTypeChecker.equalTypes$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context.getSession()), lhsType, targetType, false, false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.AS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.SAFE_AS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.IS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

