/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FE10LikeConeSubstitutorKt;
import org.jetbrains.kotlin.fir.analysis.checkers.OriginalProjectionTypeAttribute;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutionUtilitiesKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB-\b\u0016\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0014\u0010\u0011\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FE10LikeConeSubstitutor;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "substitution", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/fir/FirSession;)V", "typeParameters", "", "typeArguments", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirSession;)V", "substituteType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "withProjection", "projection", "substituteArgument", "index", "", "checkers"})
public final class FE10LikeConeSubstitutor
extends AbstractConeSubstitutor {
    @NotNull
    private final Map<FirTypeParameterSymbol, ConeTypeProjection> substitution;

    public FE10LikeConeSubstitutor(@NotNull Map<FirTypeParameterSymbol, ? extends ConeTypeProjection> substitution, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter(substitution, "substitution");
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        super(TypeComponentsKt.getTypeContext(useSiteSession));
        this.substitution = substitution;
    }

    public FE10LikeConeSubstitutor(@NotNull List<FirTypeParameterSymbol> typeParameters2, @NotNull List<? extends ConeTypeProjection> typeArguments, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter(typeParameters2, "typeParameters");
        Intrinsics.checkNotNullParameter(typeArguments, "typeArguments");
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        this(MapsKt.toMap(CollectionsKt.zip((Iterable)typeParameters2, (Iterable)typeArguments)), useSiteSession);
    }

    @Override
    @Nullable
    public ConeKotlinType substituteType(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        if (!(type2 instanceof ConeTypeParameterType)) {
            return null;
        }
        ConeTypeProjection coneTypeProjection = this.substitution.get(((ConeTypeParameterType)type2).getLookupTag().getSymbol());
        if (coneTypeProjection == null) {
            return null;
        }
        ConeTypeProjection projection = coneTypeProjection;
        if (ConeTypeProjectionKt.isStarProjection(projection)) {
            return this.withProjection(TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getAny(), new ConeTypeProjection[0], true, null, 4, null), projection);
        }
        ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(projection);
        Intrinsics.checkNotNull(coneKotlinType);
        ConeKotlinType result2 = LookupTagUtilsKt.withCombinedAttributesFrom(this.updateNullabilityIfNeeded(coneKotlinType, type2), type2);
        return this.withProjection(result2, projection);
    }

    private final ConeKotlinType withProjection(ConeKotlinType $this$withProjection, ConeTypeProjection projection) {
        if (projection.getKind() == ProjectionKind.INVARIANT) {
            return $this$withProjection;
        }
        return TypeUtilsKt.withAttributes($this$withProjection, ConeAttributes.Companion.create(CollectionsKt.listOf(new OriginalProjectionTypeAttribute(projection))));
    }

    @Override
    @Nullable
    public ConeTypeProjection substituteArgument(@NotNull ConeTypeProjection projection, int index2) {
        Object projectionFromType;
        ProjectionKind projectionKindFromType;
        Intrinsics.checkNotNullParameter(projection, "projection");
        ConeTypeProjection coneTypeProjection = super.substituteArgument(projection, index2);
        if (coneTypeProjection == null) {
            return null;
        }
        ConeTypeProjection substitutedProjection = coneTypeProjection;
        if (ConeTypeProjectionKt.isStarProjection(substitutedProjection)) {
            return null;
        }
        ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(substitutedProjection);
        Intrinsics.checkNotNull(coneKotlinType);
        ConeKotlinType type2 = coneKotlinType;
        Object object = FE10LikeConeSubstitutorKt.access$getOriginalProjection(type2.getAttributes());
        if (object == null || (object = ((OriginalProjectionTypeAttribute)object).getData()) == null) {
            object = type2;
        }
        if ((projectionKindFromType = ((ConeTypeProjection)(projectionFromType = object)).getKind()) == ProjectionKind.STAR) {
            return ConeStarProjection.INSTANCE;
        }
        if (projectionKindFromType == ProjectionKind.INVARIANT || projectionKindFromType == projection.getKind()) {
            return substitutedProjection;
        }
        if (projection.getKind() == ProjectionKind.INVARIANT) {
            return SubstitutionUtilitiesKt.wrapProjection((ConeTypeProjection)projectionFromType, type2);
        }
        return ConeStarProjection.INSTANCE;
    }
}

