/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirExceptionHandler;
import org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.MutableOrEmptyList;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusWithAlteredDefaults;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusWithAlteredDefaults;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.builder.FirWhenSubjectExpressionBuilder;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirErrorNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReplSnippetSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirDynamicTypeRef;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirIntersectionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirDynamicTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirFunctionTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirIntersectionTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirUserTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.FirFunctionTypeRefImpl;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRefKt;
import org.jetbrains.kotlin.fir.types.impl.FirResolvedTypeRefImpl;
import org.jetbrains.kotlin.fir.types.impl.FirUserTypeRefImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.util.ArrayMapAccessor;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.TypeRegistry;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00c6\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a!\u0010\u0005\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u0007*\u0002H\u00062\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u001a!\u0010\u000b\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u0007*\u0002H\u00062\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000e\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\u0016\u001a\n\u0010\u001d\u001a\u00020\u001c*\u00020\u0016\u001a\u00ea\u0001\u0010\u001e\u001a\u00020\u001f*\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\b\b\u0002\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020%2\b\b\u0002\u0010'\u001a\u00020%2\b\b\u0002\u0010(\u001a\u00020%2\b\b\u0002\u0010)\u001a\u00020%2\b\b\u0002\u0010*\u001a\u00020%2\b\b\u0002\u0010+\u001a\u00020%2\b\b\u0002\u0010,\u001a\u00020%2\b\b\u0002\u0010-\u001a\u00020%2\b\b\u0002\u0010.\u001a\u00020%2\b\b\u0002\u0010/\u001a\u00020%2\b\b\u0002\u00100\u001a\u00020%2\b\b\u0002\u00101\u001a\u00020%2\b\b\u0002\u00102\u001a\u00020%2\b\b\u0002\u00103\u001a\u00020%2\b\b\u0002\u00104\u001a\u00020%2\b\b\u0002\u00105\u001a\u00020%2\b\b\u0002\u00106\u001a\u00020%2\b\b\u0002\u00107\u001a\u00020%2\b\b\u0002\u00108\u001a\u00020%\u001a6\u00109\u001a\u00020\u001f*\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\b\b\u0002\u0010:\u001a\u00020!2\b\b\u0002\u0010;\u001a\u00020#\u001a\u00e0\u0001\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020@2\b\b\u0002\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020%2\b\b\u0002\u0010'\u001a\u00020%2\b\b\u0002\u0010(\u001a\u00020%2\b\b\u0002\u0010)\u001a\u00020%2\b\b\u0002\u0010*\u001a\u00020%2\b\b\u0002\u0010+\u001a\u00020%2\b\b\u0002\u0010,\u001a\u00020%2\b\b\u0002\u0010-\u001a\u00020%2\b\b\u0002\u0010.\u001a\u00020%2\b\b\u0002\u0010/\u001a\u00020%2\b\b\u0002\u00100\u001a\u00020%2\b\b\u0002\u00101\u001a\u00020%2\b\b\u0002\u00102\u001a\u00020%2\b\b\u0002\u00103\u001a\u00020%2\b\b\u0002\u00104\u001a\u00020%2\b\b\u0002\u00105\u001a\u00020%2\b\b\u0002\u00106\u001a\u00020%2\b\b\u0002\u00107\u001a\u00020%2\b\b\u0002\u00108\u001a\u00020%H\u0002\u001a5\u0010A\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u00162\f\u0010E\u001a\b\u0012\u0004\u0012\u0002H\u00060FH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010G\u001a-\u0010H\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010I\u001a\u00020\u00112\f\u0010E\u001a\b\u0012\u0004\u0012\u0002H\u00060FH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010J\u001a*\u0010Q\u001a\b\u0012\u0004\u0012\u0002HS0R\"\u0004\b\u0000\u0010S*\b\u0012\u0004\u0012\u0002HS0R2\f\u0010T\u001a\b\u0012\u0004\u0012\u0002HS0R\u001a\u0012\u0010U\u001a\u00020%*\u00020V2\u0006\u0010W\u001a\u00020X\u001a\u0016\u0010U\u001a\u00020%*\u00020V2\n\u0010Y\u001a\u0006\u0012\u0002\b\u00030Z\u001a\u000e\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030_\u001a\n\u0010`\u001a\u00020a*\u00020b\u001a\u0018\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020\r2\b\u0010f\u001a\u0004\u0018\u00010V\u001a\"\u0010g\u001a\u00020h*\u00020i2\n\b\u0002\u0010j\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010k\u001a\u0004\u0018\u00010\u0007\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u0015*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\"\u001f\u0010K\u001a\u00020L*\u00020C8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bO\u0010P\u001a\u0004\bM\u0010N\"\u0015\u0010[\u001a\u00020%*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\\"\u0015\u0010]\u001a\u00020%*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b]\u0010\\\"\u0018\u0010^\u001a\u00020%*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b^\u0010\\\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006l"}, d2={"lastExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "getLastExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "copyWithNewSourceKind", "R", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "newKind", "Lorg/jetbrains/kotlin/KtFakeSourceElementKind;", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/KtFakeSourceElementKind;)Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "copyWithNewSource", "newSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/KtSourceElement;)Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getPackageFqName", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)Lorg/jetbrains/kotlin/name/FqName;", "psi", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/fir/FirElement;", "getPsi", "(Lorg/jetbrains/kotlin/fir/FirElement;)Lcom/intellij/psi/PsiElement;", "realPsi", "getRealPsi", "renderWithType", "", "render", "copy", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "modality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "isExpect", "", "isActual", "isOverride", "isOperator", "isInfix", "isInline", "isValue", "isTailRec", "isExternal", "isConst", "isLateInit", "isInner", "isCompanion", "isData", "isSuspend", "isStatic", "isFromSealedClass", "isFromEnumClass", "isFun", "hasStableParameterNames", "copyWithNewDefaults", "defaultVisibility", "defaultModality", "copyStatusAttributes", "", "from", "to", "Lorg/jetbrains/kotlin/fir/declarations/impl/FirDeclarationStatusImpl;", "whileAnalysing", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "element", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/FirElement;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withFileAnalysisExceptionWrapping", "file", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "exceptionHandler", "Lorg/jetbrains/kotlin/fir/FirExceptionHandler;", "getExceptionHandler", "(Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/FirExceptionHandler;", "exceptionHandler$delegate", "Lorg/jetbrains/kotlin/util/ArrayMapAccessor;", "smartPlus", "", "T", "other", "isEnumEntries", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "containingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "containingClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "isArraySet", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "isStatementLikeExpression", "isIndexedAssignment", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "toAugmentedAssignSourceKind", "Lorg/jetbrains/kotlin/KtFakeSourceElementKind$DesugaredAugmentedAssign;", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "buildWhenSubjectAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "conditionSource", "subjectVariable", "toFirResolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "source", "delegatedTypeRef", "tree"})
public final class UtilsKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final ArrayMapAccessor exceptionHandler$delegate;

    @Nullable
    public static final FirExpression getLastExpression(@NotNull FirBlock $this$lastExpression) {
        Intrinsics.checkNotNullParameter($this$lastExpression, "<this>");
        FirStatement firStatement = CollectionsKt.lastOrNull($this$lastExpression.getStatements());
        return firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
    }

    @NotNull
    public static final <R extends FirTypeRef> R copyWithNewSourceKind(@NotNull R $this$copyWithNewSourceKind, @NotNull KtFakeSourceElementKind newKind) {
        Intrinsics.checkNotNullParameter($this$copyWithNewSourceKind, "<this>");
        Intrinsics.checkNotNullParameter(newKind, "newKind");
        KtSourceElement ktSourceElement = $this$copyWithNewSourceKind.getSource();
        if (ktSourceElement == null) {
            return $this$copyWithNewSourceKind;
        }
        KtSourceElement source = ktSourceElement;
        if (Intrinsics.areEqual(source.getKind(), newKind)) {
            return $this$copyWithNewSourceKind;
        }
        return UtilsKt.copyWithNewSource($this$copyWithNewSourceKind, KtSourceElementKt.fakeElement$default(source, newKind, 0, 0, 6, null));
    }

    @NotNull
    public static final <R extends FirTypeRef> R copyWithNewSource(@NotNull R $this$copyWithNewSource, @NotNull KtSourceElement newSource) {
        FirTypeRef firTypeRef;
        FirAnnotationContainerBuilder copyBuilder$iv;
        Intrinsics.checkNotNullParameter($this$copyWithNewSource, "<this>");
        Intrinsics.checkNotNullParameter(newSource, "newSource");
        KtSourceElement ktSourceElement = $this$copyWithNewSource.getSource();
        if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, newSource.getKind())) {
            return $this$copyWithNewSource;
        }
        R typeRef = $this$copyWithNewSource;
        if (typeRef instanceof FirResolvedTypeRefImpl) {
            FirAnnotationContainerBuilder firAnnotationContainerBuilder;
            FirResolvedTypeRef original$iv = (FirResolvedTypeRef)typeRef;
            boolean $i$f$buildResolvedTypeRefCopy = false;
            copyBuilder$iv = new FirResolvedTypeRefBuilder();
            ((FirResolvedTypeRefBuilder)copyBuilder$iv).setSource(original$iv.getSource());
            ((FirResolvedTypeRefBuilder)copyBuilder$iv).getAnnotations().addAll((Collection<FirAnnotation>)original$iv.getAnnotations());
            ((FirResolvedTypeRefBuilder)copyBuilder$iv).setConeType(original$iv.getConeType());
            ((FirResolvedTypeRefBuilder)copyBuilder$iv).setDelegatedTypeRef(original$iv.getDelegatedTypeRef());
            FirAnnotationContainerBuilder $this$copyWithNewSource_u24lambda_u240 = firAnnotationContainerBuilder = copyBuilder$iv;
            boolean bl = false;
            ((FirResolvedTypeRefBuilder)$this$copyWithNewSource_u24lambda_u240).setSource(newSource);
            firTypeRef = ((FirResolvedTypeRefBuilder)firAnnotationContainerBuilder).build();
        } else if (typeRef instanceof FirErrorTypeRef) {
            FirAnnotationContainerBuilder firAnnotationContainerBuilder;
            FirErrorTypeRef original$iv = (FirErrorTypeRef)typeRef;
            boolean $i$f$buildErrorTypeRefCopy = false;
            copyBuilder$iv = new FirErrorTypeRefBuilder();
            ((FirErrorTypeRefBuilder)copyBuilder$iv).setSource(original$iv.getSource());
            ((FirErrorTypeRefBuilder)copyBuilder$iv).setConeType(original$iv.getConeType());
            ((FirErrorTypeRefBuilder)copyBuilder$iv).setAnnotations(CollectionsKt.toMutableList((Collection)original$iv.getAnnotations()));
            ((FirErrorTypeRefBuilder)copyBuilder$iv).setDelegatedTypeRef(original$iv.getDelegatedTypeRef());
            ((FirErrorTypeRefBuilder)copyBuilder$iv).setDiagnostic(original$iv.getDiagnostic());
            FirAnnotationContainerBuilder $this$copyWithNewSource_u24lambda_u241 = firAnnotationContainerBuilder = copyBuilder$iv;
            boolean bl = false;
            ((FirErrorTypeRefBuilder)$this$copyWithNewSource_u24lambda_u241).setSource(newSource);
            firTypeRef = ((FirErrorTypeRefBuilder)firAnnotationContainerBuilder).build();
        } else if (typeRef instanceof FirUserTypeRefImpl) {
            FirUserTypeRefBuilder $i$f$buildErrorTypeRefCopy;
            boolean $i$f$buildUserTypeRef = false;
            FirUserTypeRefBuilder $this$copyWithNewSource_u24lambda_u242 = $i$f$buildErrorTypeRefCopy = new FirUserTypeRefBuilder();
            boolean bl = false;
            $this$copyWithNewSource_u24lambda_u242.setSource(newSource);
            $this$copyWithNewSource_u24lambda_u242.setMarkedNullable(((FirUserTypeRefImpl)typeRef).isMarkedNullable());
            CollectionsKt.addAll((Collection)$this$copyWithNewSource_u24lambda_u242.getQualifier(), (Iterable)((FirUserTypeRefImpl)typeRef).getQualifier());
            CollectionsKt.addAll((Collection)$this$copyWithNewSource_u24lambda_u242.getAnnotations(), MutableOrEmptyList.box-impl(((FirUserTypeRefImpl)typeRef).getAnnotations-5e3fPpI()));
            firTypeRef = $i$f$buildErrorTypeRefCopy.build();
        } else if (typeRef instanceof FirFunctionTypeRefImpl) {
            FirAnnotationContainerBuilder bl;
            FirFunctionTypeRef original$iv = (FirFunctionTypeRef)typeRef;
            boolean $i$f$buildFunctionTypeRefCopy = false;
            copyBuilder$iv = new FirFunctionTypeRefBuilder();
            ((FirFunctionTypeRefBuilder)copyBuilder$iv).getAnnotations().addAll((Collection<FirAnnotation>)original$iv.getAnnotations());
            ((FirFunctionTypeRefBuilder)copyBuilder$iv).setSource(original$iv.getSource());
            ((FirFunctionTypeRefBuilder)copyBuilder$iv).setMarkedNullable(original$iv.isMarkedNullable());
            ((FirFunctionTypeRefBuilder)copyBuilder$iv).setReceiverTypeRef(original$iv.getReceiverTypeRef());
            ((FirFunctionTypeRefBuilder)copyBuilder$iv).getParameters().addAll((Collection<FirFunctionTypeParameter>)original$iv.getParameters());
            ((FirFunctionTypeRefBuilder)copyBuilder$iv).setReturnTypeRef(original$iv.getReturnTypeRef());
            ((FirFunctionTypeRefBuilder)copyBuilder$iv).setSuspend(original$iv.isSuspend());
            ((FirFunctionTypeRefBuilder)copyBuilder$iv).getContextParameterTypeRefs().addAll((Collection<FirTypeRef>)original$iv.getContextParameterTypeRefs());
            FirAnnotationContainerBuilder $this$copyWithNewSource_u24lambda_u243 = bl = copyBuilder$iv;
            boolean bl2 = false;
            ((FirFunctionTypeRefBuilder)$this$copyWithNewSource_u24lambda_u243).setSource(newSource);
            firTypeRef = ((FirFunctionTypeRefBuilder)bl).build();
        } else if (typeRef instanceof FirDynamicTypeRef) {
            FirDynamicTypeRefBuilder firDynamicTypeRefBuilder;
            boolean $i$f$buildDynamicTypeRef = false;
            FirDynamicTypeRefBuilder $this$copyWithNewSource_u24lambda_u244 = firDynamicTypeRefBuilder = new FirDynamicTypeRefBuilder();
            boolean bl = false;
            $this$copyWithNewSource_u24lambda_u244.setSource(newSource);
            $this$copyWithNewSource_u24lambda_u244.setMarkedNullable(((FirDynamicTypeRef)typeRef).isMarkedNullable());
            CollectionsKt.addAll((Collection)$this$copyWithNewSource_u24lambda_u244.getAnnotations(), (Iterable)((FirDynamicTypeRef)typeRef).getAnnotations());
            firTypeRef = firDynamicTypeRefBuilder.build();
        } else if (typeRef instanceof FirImplicitBuiltinTypeRef) {
            firTypeRef = FirImplicitBuiltinTypeRefKt.withNewSource((FirImplicitBuiltinTypeRef)typeRef, newSource);
        } else if (typeRef instanceof FirIntersectionTypeRef) {
            FirIntersectionTypeRefBuilder firIntersectionTypeRefBuilder;
            boolean $i$f$buildIntersectionTypeRef = false;
            FirIntersectionTypeRefBuilder $this$copyWithNewSource_u24lambda_u245 = firIntersectionTypeRefBuilder = new FirIntersectionTypeRefBuilder();
            boolean bl = false;
            $this$copyWithNewSource_u24lambda_u245.setSource(newSource);
            $this$copyWithNewSource_u24lambda_u245.setMarkedNullable(((FirIntersectionTypeRef)typeRef).isMarkedNullable());
            $this$copyWithNewSource_u24lambda_u245.setLeftType(((FirIntersectionTypeRef)typeRef).getLeftType());
            $this$copyWithNewSource_u24lambda_u245.setRightType(((FirIntersectionTypeRef)typeRef).getRightType());
            firTypeRef = firIntersectionTypeRefBuilder.build();
        } else {
            String string = "Not implemented for " + Reflection.getOrCreateKotlinClass(typeRef.getClass());
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        FirTypeRef firTypeRef2 = firTypeRef;
        Intrinsics.checkNotNull(firTypeRef2, "null cannot be cast to non-null type R of org.jetbrains.kotlin.fir.UtilsKt.copyWithNewSource");
        return (R)firTypeRef2;
    }

    @NotNull
    public static final FqName getPackageFqName(@NotNull FirFile $this$packageFqName) {
        Intrinsics.checkNotNullParameter($this$packageFqName, "<this>");
        return $this$packageFqName.getPackageDirective().getPackageFqName();
    }

    @Nullable
    public static final PsiElement getPsi(@NotNull FirElement $this$psi) {
        Intrinsics.checkNotNullParameter($this$psi, "<this>");
        KtSourceElement ktSourceElement = $this$psi.getSource();
        KtPsiSourceElement ktPsiSourceElement = ktSourceElement instanceof KtPsiSourceElement ? (KtPsiSourceElement)ktSourceElement : null;
        return ktPsiSourceElement != null ? ktPsiSourceElement.getPsi() : null;
    }

    @Nullable
    public static final PsiElement getRealPsi(@NotNull FirElement $this$realPsi) {
        Intrinsics.checkNotNullParameter($this$realPsi, "<this>");
        KtSourceElement ktSourceElement = $this$realPsi.getSource();
        KtRealPsiSourceElement ktRealPsiSourceElement = ktSourceElement instanceof KtRealPsiSourceElement ? (KtRealPsiSourceElement)ktSourceElement : null;
        return ktRealPsiSourceElement != null ? ktRealPsiSourceElement.getPsi() : null;
    }

    @NotNull
    public static final String renderWithType(@NotNull FirElement $this$renderWithType) {
        Intrinsics.checkNotNullParameter($this$renderWithType, "<this>");
        return new FirRenderer(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, false, false, 0xFFFFFF, null).renderElementWithTypeAsString($this$renderWithType);
    }

    @NotNull
    public static final String render(@NotNull FirElement $this$render) {
        Intrinsics.checkNotNullParameter($this$render, "<this>");
        return FirRenderer.renderElementAsString$default(new FirRenderer(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, false, false, 0xFFFFFF, null), $this$render, false, 2, null);
    }

    @NotNull
    public static final FirDeclarationStatus copy(@NotNull FirDeclarationStatus $this$copy, @Nullable Visibility visibility, @Nullable Modality modality, boolean isExpect, boolean isActual, boolean isOverride, boolean isOperator, boolean isInfix, boolean isInline, boolean isValue, boolean isTailRec, boolean isExternal, boolean isConst, boolean isLateInit, boolean isInner2, boolean isCompanion, boolean isData, boolean isSuspend, boolean isStatic, boolean isFromSealedClass, boolean isFromEnumClass, boolean isFun, boolean hasStableParameterNames) {
        FirDeclarationStatusImpl firDeclarationStatusImpl;
        Modality newModality;
        Modality modality2;
        Visibility newVisibility;
        Intrinsics.checkNotNullParameter($this$copy, "<this>");
        Visibility visibility2 = visibility;
        if (visibility2 == null) {
            visibility2 = newVisibility = $this$copy.getVisibility();
        }
        if ((modality2 = modality) == null) {
            modality2 = newModality = $this$copy.getModality();
        }
        if ($this$copy instanceof FirResolvedDeclarationStatus) {
            Modality modality3 = newModality;
            Intrinsics.checkNotNull((Object)modality3);
            firDeclarationStatusImpl = new FirResolvedDeclarationStatusImpl(newVisibility, modality3, ((FirResolvedDeclarationStatus)$this$copy).getEffectiveVisibility());
        } else {
            firDeclarationStatusImpl = new FirDeclarationStatusImpl(newVisibility, newModality);
        }
        FirDeclarationStatusImpl newStatus = firDeclarationStatusImpl;
        UtilsKt.copyStatusAttributes($this$copy, newStatus, isExpect, isActual, isOverride, isOperator, isInfix, isInline, isValue, isTailRec, isExternal, isConst, isLateInit, isInner2, isCompanion, isData, isSuspend, isStatic, isFromSealedClass, isFromEnumClass, isFun, hasStableParameterNames);
        return newStatus;
    }

    public static /* synthetic */ FirDeclarationStatus copy$default(FirDeclarationStatus firDeclarationStatus, Visibility visibility, Modality modality, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, int n2, Object object) {
        if ((n2 & 1) != 0) {
            visibility = firDeclarationStatus.getVisibility();
        }
        if ((n2 & 2) != 0) {
            modality = firDeclarationStatus.getModality();
        }
        if ((n2 & 4) != 0) {
            bl = firDeclarationStatus.isExpect();
        }
        if ((n2 & 8) != 0) {
            bl2 = firDeclarationStatus.isActual();
        }
        if ((n2 & 0x10) != 0) {
            bl3 = firDeclarationStatus.isOverride();
        }
        if ((n2 & 0x20) != 0) {
            bl4 = firDeclarationStatus.isOperator();
        }
        if ((n2 & 0x40) != 0) {
            bl5 = firDeclarationStatus.isInfix();
        }
        if ((n2 & 0x80) != 0) {
            bl6 = firDeclarationStatus.isInline();
        }
        if ((n2 & 0x100) != 0) {
            bl7 = firDeclarationStatus.isValue();
        }
        if ((n2 & 0x200) != 0) {
            bl8 = firDeclarationStatus.isTailRec();
        }
        if ((n2 & 0x400) != 0) {
            bl9 = firDeclarationStatus.isExternal();
        }
        if ((n2 & 0x800) != 0) {
            bl10 = firDeclarationStatus.isConst();
        }
        if ((n2 & 0x1000) != 0) {
            bl11 = firDeclarationStatus.isLateInit();
        }
        if ((n2 & 0x2000) != 0) {
            bl12 = firDeclarationStatus.isInner();
        }
        if ((n2 & 0x4000) != 0) {
            bl13 = firDeclarationStatus.isCompanion();
        }
        if ((n2 & 0x8000) != 0) {
            bl14 = firDeclarationStatus.isData();
        }
        if ((n2 & 0x10000) != 0) {
            bl15 = firDeclarationStatus.isSuspend();
        }
        if ((n2 & 0x20000) != 0) {
            bl16 = firDeclarationStatus.isStatic();
        }
        if ((n2 & 0x40000) != 0) {
            bl17 = firDeclarationStatus.isFromSealedClass();
        }
        if ((n2 & 0x80000) != 0) {
            bl18 = firDeclarationStatus.isFromEnumClass();
        }
        if ((n2 & 0x100000) != 0) {
            bl19 = firDeclarationStatus.isFun();
        }
        if ((n2 & 0x200000) != 0) {
            bl20 = firDeclarationStatus.getHasStableParameterNames();
        }
        return UtilsKt.copy(firDeclarationStatus, visibility, modality, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, bl11, bl12, bl13, bl14, bl15, bl16, bl17, bl18, bl19, bl20);
    }

    @NotNull
    public static final FirDeclarationStatus copyWithNewDefaults(@NotNull FirDeclarationStatus $this$copyWithNewDefaults, @Nullable Visibility visibility, @Nullable Modality modality, @NotNull Visibility defaultVisibility, @NotNull Modality defaultModality) {
        FirDeclarationStatusImpl firDeclarationStatusImpl;
        Modality newModality;
        Modality modality2;
        Visibility newVisibility;
        Intrinsics.checkNotNullParameter($this$copyWithNewDefaults, "<this>");
        Intrinsics.checkNotNullParameter(defaultVisibility, "defaultVisibility");
        Intrinsics.checkNotNullParameter((Object)defaultModality, "defaultModality");
        Visibility visibility2 = visibility;
        if (visibility2 == null) {
            visibility2 = newVisibility = $this$copyWithNewDefaults.getVisibility();
        }
        if ((modality2 = modality) == null) {
            modality2 = newModality = $this$copyWithNewDefaults.getModality();
        }
        if ($this$copyWithNewDefaults instanceof FirResolvedDeclarationStatus) {
            Modality modality3 = newModality;
            Intrinsics.checkNotNull((Object)modality3);
            firDeclarationStatusImpl = new FirResolvedDeclarationStatusWithAlteredDefaults(newVisibility, modality3, defaultVisibility, defaultModality, ((FirResolvedDeclarationStatus)$this$copyWithNewDefaults).getEffectiveVisibility());
        } else {
            firDeclarationStatusImpl = new FirDeclarationStatusWithAlteredDefaults(newVisibility, newModality, defaultVisibility, defaultModality);
        }
        FirDeclarationStatusImpl newStatus = firDeclarationStatusImpl;
        UtilsKt.copyStatusAttributes$default($this$copyWithNewDefaults, newStatus, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, 0x3FFFFC, null);
        return newStatus;
    }

    public static /* synthetic */ FirDeclarationStatus copyWithNewDefaults$default(FirDeclarationStatus firDeclarationStatus, Visibility visibility, Modality modality, Visibility visibility2, Modality modality2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            visibility = firDeclarationStatus.getVisibility();
        }
        if ((n2 & 2) != 0) {
            modality = firDeclarationStatus.getModality();
        }
        if ((n2 & 4) != 0) {
            visibility2 = firDeclarationStatus.getDefaultVisibility();
        }
        if ((n2 & 8) != 0) {
            modality2 = firDeclarationStatus.getDefaultModality();
        }
        return UtilsKt.copyWithNewDefaults(firDeclarationStatus, visibility, modality, visibility2, modality2);
    }

    private static final void copyStatusAttributes(FirDeclarationStatus from, FirDeclarationStatusImpl to, boolean isExpect, boolean isActual, boolean isOverride, boolean isOperator, boolean isInfix, boolean isInline, boolean isValue, boolean isTailRec, boolean isExternal, boolean isConst, boolean isLateInit, boolean isInner2, boolean isCompanion, boolean isData, boolean isSuspend, boolean isStatic, boolean isFromSealedClass, boolean isFromEnumClass, boolean isFun, boolean hasStableParameterNames) {
        to.setExpect(isExpect);
        to.setActual(isActual);
        to.setOverride(isOverride);
        to.setOperator(isOperator);
        to.setInfix(isInfix);
        to.setInline(isInline);
        to.setValue(isValue);
        to.setTailRec(isTailRec);
        to.setExternal(isExternal);
        to.setConst(isConst);
        to.setLateInit(isLateInit);
        to.setInner(isInner2);
        to.setCompanion(isCompanion);
        to.setData(isData);
        to.setSuspend(isSuspend);
        to.setStatic(isStatic);
        to.setFromSealedClass(isFromSealedClass);
        to.setFromEnumClass(isFromEnumClass);
        to.setFun(isFun);
        to.setHasStableParameterNames(hasStableParameterNames);
    }

    static /* synthetic */ void copyStatusAttributes$default(FirDeclarationStatus firDeclarationStatus, FirDeclarationStatusImpl firDeclarationStatusImpl, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, boolean bl15, boolean bl16, boolean bl17, boolean bl18, boolean bl19, boolean bl20, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = firDeclarationStatus.isExpect();
        }
        if ((n2 & 8) != 0) {
            bl2 = firDeclarationStatus.isActual();
        }
        if ((n2 & 0x10) != 0) {
            bl3 = firDeclarationStatus.isOverride();
        }
        if ((n2 & 0x20) != 0) {
            bl4 = firDeclarationStatus.isOperator();
        }
        if ((n2 & 0x40) != 0) {
            bl5 = firDeclarationStatus.isInfix();
        }
        if ((n2 & 0x80) != 0) {
            bl6 = firDeclarationStatus.isInline();
        }
        if ((n2 & 0x100) != 0) {
            bl7 = firDeclarationStatus.isValue();
        }
        if ((n2 & 0x200) != 0) {
            bl8 = firDeclarationStatus.isTailRec();
        }
        if ((n2 & 0x400) != 0) {
            bl9 = firDeclarationStatus.isExternal();
        }
        if ((n2 & 0x800) != 0) {
            bl10 = firDeclarationStatus.isConst();
        }
        if ((n2 & 0x1000) != 0) {
            bl11 = firDeclarationStatus.isLateInit();
        }
        if ((n2 & 0x2000) != 0) {
            bl12 = firDeclarationStatus.isInner();
        }
        if ((n2 & 0x4000) != 0) {
            bl13 = firDeclarationStatus.isCompanion();
        }
        if ((n2 & 0x8000) != 0) {
            bl14 = firDeclarationStatus.isData();
        }
        if ((n2 & 0x10000) != 0) {
            bl15 = firDeclarationStatus.isSuspend();
        }
        if ((n2 & 0x20000) != 0) {
            bl16 = firDeclarationStatus.isStatic();
        }
        if ((n2 & 0x40000) != 0) {
            bl17 = firDeclarationStatus.isFromSealedClass();
        }
        if ((n2 & 0x80000) != 0) {
            bl18 = firDeclarationStatus.isFromEnumClass();
        }
        if ((n2 & 0x100000) != 0) {
            bl19 = firDeclarationStatus.isFun();
        }
        if ((n2 & 0x200000) != 0) {
            bl20 = firDeclarationStatus.getHasStableParameterNames();
        }
        UtilsKt.copyStatusAttributes(firDeclarationStatus, firDeclarationStatusImpl, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, bl11, bl12, bl13, bl14, bl15, bl16, bl17, bl18, bl19, bl20);
    }

    public static final <R> R whileAnalysing(@NotNull FirSession session, @NotNull FirElement element, @NotNull Function0<? extends R> block) {
        R r2;
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$whileAnalysing = false;
        try {
            r2 = block.invoke();
        }
        catch (Throwable throwable) {
            UtilsKt.getExceptionHandler(session).handleExceptionOnElementAnalysis(element, throwable);
            throw new KotlinNothingValueException();
        }
        return r2;
    }

    public static final <R> R withFileAnalysisExceptionWrapping(@NotNull FirFile file, @NotNull Function0<? extends R> block) {
        R r2;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            r2 = block.invoke();
        }
        catch (Throwable throwable) {
            UtilsKt.getExceptionHandler(file.getModuleData().getSession()).handleExceptionOnFileAnalysis(file, throwable);
            throw new KotlinNothingValueException();
        }
        return r2;
    }

    @NotNull
    public static final FirExceptionHandler getExceptionHandler(@NotNull FirSession $this$exceptionHandler) {
        Intrinsics.checkNotNullParameter($this$exceptionHandler, "<this>");
        return (FirExceptionHandler)exceptionHandler$delegate.getValue($this$exceptionHandler, (KProperty<?>)$$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> smartPlus(@NotNull List<? extends T> $this$smartPlus, @NotNull List<? extends T> other) {
        List list;
        Intrinsics.checkNotNullParameter($this$smartPlus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        if (other.isEmpty()) {
            list = $this$smartPlus;
        } else if ($this$smartPlus.isEmpty()) {
            list = other;
        } else {
            void var2_2;
            ArrayList result2 = new ArrayList($this$smartPlus.size() + other.size());
            result2.addAll($this$smartPlus);
            result2.addAll(other);
            list = (List)var2_2;
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEnumEntries(@NotNull FirVariable $this$isEnumEntries, @NotNull FirClass containingClass) {
        Intrinsics.checkNotNullParameter($this$isEnumEntries, "<this>");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        FirMemberDeclaration $this$isStatic$iv = $this$isEnumEntries;
        boolean $i$f$isStatic = false;
        if (!$this$isStatic$iv.getStatus().isStatic()) return false;
        if (!Intrinsics.areEqual($this$isEnumEntries.getName(), StandardNames.ENUM_ENTRIES)) return false;
        FirClass $this$isEnumClass$iv = containingClass;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if ($this$isEnumClass$iv$iv != ClassKind.ENUM_CLASS) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEnumEntries(@NotNull FirVariable $this$isEnumEntries, @NotNull FirClassSymbol<?> containingClassSymbol) {
        Intrinsics.checkNotNullParameter($this$isEnumEntries, "<this>");
        Intrinsics.checkNotNullParameter(containingClassSymbol, "containingClassSymbol");
        FirMemberDeclaration $this$isStatic$iv = $this$isEnumEntries;
        boolean $i$f$isStatic = false;
        if (!$this$isStatic$iv.getStatus().isStatic()) return false;
        if (!Intrinsics.areEqual($this$isEnumEntries.getName(), StandardNames.ENUM_ENTRIES)) return false;
        FirClassSymbol<?> $this$isEnumClass$iv = containingClassSymbol;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if ($this$isEnumClass$iv$iv != ClassKind.ENUM_CLASS) return false;
        return true;
    }

    public static final boolean isArraySet(@NotNull FirExpression $this$isArraySet) {
        Intrinsics.checkNotNullParameter($this$isArraySet, "<this>");
        Object object = $this$isArraySet instanceof FirFunctionCall ? (FirFunctionCall)$this$isArraySet : null;
        if (object == null || (object = ((FirFunctionCall)object).getCalleeReference()) == null || (object = ((FirNamedReference)object).getName()) == null) {
            return false;
        }
        Object name = object;
        return ((FirFunctionCall)$this$isArraySet).getOrigin() == FirFunctionCallOrigin.Operator && Intrinsics.areEqual(name, OperatorNameConventions.SET);
    }

    public static final boolean isStatementLikeExpression(@NotNull FirExpression $this$isStatementLikeExpression) {
        Intrinsics.checkNotNullParameter($this$isStatementLikeExpression, "<this>");
        return $this$isStatementLikeExpression instanceof FirFunctionCall ? ((FirFunctionCall)$this$isStatementLikeExpression).getOrigin() == FirFunctionCallOrigin.Operator && OperatorNameConventions.STATEMENT_LIKE_OPERATORS.contains(((FirFunctionCall)$this$isStatementLikeExpression).getCalleeReference().getName()) : UtilsKt.isIndexedAssignment($this$isStatementLikeExpression);
    }

    private static final boolean isIndexedAssignment(FirExpression $this$isIndexedAssignment) {
        Object object;
        return $this$isIndexedAssignment instanceof FirBlock && Intrinsics.areEqual((object = CollectionsKt.lastOrNull(((FirBlock)$this$isIndexedAssignment).getStatements())) != null && (object = object.getSource()) != null ? ((KtSourceElement)object).getKind() : null, KtFakeSourceElementKind.ImplicitUnit.IndexedAssignmentCoercion.INSTANCE);
    }

    @NotNull
    public static final FqName packageFqName(@NotNull FirBasedSymbol<?> $this$packageFqName) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$packageFqName, "<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$packageFqName;
        if (firBasedSymbol instanceof FirClassLikeSymbol) {
            fqName2 = ((FirClassLikeSymbol)$this$packageFqName).getClassId().getPackageFqName();
        } else if (firBasedSymbol instanceof FirPropertyAccessorSymbol) {
            fqName2 = UtilsKt.packageFqName(((FirPropertyAccessorSymbol)$this$packageFqName).getPropertySymbol());
        } else if (firBasedSymbol instanceof FirCallableSymbol) {
            fqName2 = ((FirCallableSymbol)$this$packageFqName).getCallableId().getPackageName();
        } else if (firBasedSymbol instanceof FirReplSnippetSymbol) {
            fqName2 = FqName.ROOT;
        } else {
            throw new IllegalStateException(("No package fq name for " + $this$packageFqName).toString());
        }
        return fqName2;
    }

    @NotNull
    public static final KtFakeSourceElementKind.DesugaredAugmentedAssign toAugmentedAssignSourceKind(@NotNull FirOperation $this$toAugmentedAssignSourceKind) {
        KtFakeSourceElementKind.DesugaredAugmentedAssign desugaredAugmentedAssign;
        Intrinsics.checkNotNullParameter((Object)$this$toAugmentedAssignSourceKind, "<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toAugmentedAssignSourceKind.ordinal()]) {
            case 1: {
                desugaredAugmentedAssign = KtFakeSourceElementKind.DesugaredPlusAssign.INSTANCE;
                break;
            }
            case 2: {
                desugaredAugmentedAssign = KtFakeSourceElementKind.DesugaredMinusAssign.INSTANCE;
                break;
            }
            case 3: {
                desugaredAugmentedAssign = KtFakeSourceElementKind.DesugaredTimesAssign.INSTANCE;
                break;
            }
            case 4: {
                desugaredAugmentedAssign = KtFakeSourceElementKind.DesugaredDivAssign.INSTANCE;
                break;
            }
            case 5: {
                desugaredAugmentedAssign = KtFakeSourceElementKind.DesugaredRemAssign.INSTANCE;
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected operator: " + $this$toAugmentedAssignSourceKind.name()).toString());
            }
        }
        return desugaredAugmentedAssign;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirPropertyAccessExpression buildWhenSubjectAccess(@NotNull KtSourceElement conditionSource, @Nullable FirVariable subjectVariable) {
        FirNamedReference firNamedReference;
        FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder;
        FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder2;
        Intrinsics.checkNotNullParameter(conditionSource, "conditionSource");
        boolean $i$f$buildWhenSubjectExpression = false;
        FirWhenSubjectExpressionBuilder $this$buildWhenSubjectAccess_u24lambda_u248 = firWhenSubjectExpressionBuilder2 = new FirWhenSubjectExpressionBuilder();
        boolean bl = false;
        $this$buildWhenSubjectAccess_u24lambda_u248.setSource(conditionSource);
        FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder3 = $this$buildWhenSubjectAccess_u24lambda_u248;
        if (subjectVariable == null) {
            void $this$buildWhenSubjectAccess_u24lambda_u248_u24lambda_u246;
            FirErrorNamedReferenceBuilder firErrorNamedReferenceBuilder;
            boolean $i$f$buildErrorNamedReference = false;
            FirErrorNamedReferenceBuilder firErrorNamedReferenceBuilder2 = firErrorNamedReferenceBuilder = new FirErrorNamedReferenceBuilder();
            FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder4 = firWhenSubjectExpressionBuilder3;
            boolean bl2 = false;
            $this$buildWhenSubjectAccess_u24lambda_u248_u24lambda_u246.setSource(KtSourceElementKt.fakeElement$default(conditionSource, KtFakeSourceElementKind.UnresolvedWhenConditionSubject.INSTANCE, 0, 0, 6, null));
            $this$buildWhenSubjectAccess_u24lambda_u248_u24lambda_u246.setName(SpecialNames.WHEN_SUBJECT);
            $this$buildWhenSubjectAccess_u24lambda_u248_u24lambda_u246.setDiagnostic(new ConeSimpleDiagnostic("No subject in when", DiagnosticKind.Other));
            firWhenSubjectExpressionBuilder = firWhenSubjectExpressionBuilder4;
            firNamedReference = firErrorNamedReferenceBuilder.build();
        } else {
            void $this$buildWhenSubjectAccess_u24lambda_u248_u24lambda_u247;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
            boolean $i$f$buildResolvedNamedReference = false;
            FirResolvedNamedReferenceBuilder $this$buildWhenSubjectAccess_u24lambda_u248_u24lambda_u246 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
            FirWhenSubjectExpressionBuilder firWhenSubjectExpressionBuilder5 = firWhenSubjectExpressionBuilder3;
            boolean bl3 = false;
            $this$buildWhenSubjectAccess_u24lambda_u248_u24lambda_u247.setSource(KtSourceElementKt.fakeElement$default(conditionSource, KtFakeSourceElementKind.WhenCondition.INSTANCE, 0, 0, 6, null));
            $this$buildWhenSubjectAccess_u24lambda_u248_u24lambda_u247.setResolvedSymbol((FirBasedSymbol)subjectVariable.getSymbol());
            $this$buildWhenSubjectAccess_u24lambda_u248_u24lambda_u247.setName(subjectVariable.getName());
            firWhenSubjectExpressionBuilder = firWhenSubjectExpressionBuilder5;
            firNamedReference = firResolvedNamedReferenceBuilder.build();
        }
        firWhenSubjectExpressionBuilder.setCalleeReference(firNamedReference);
        return firWhenSubjectExpressionBuilder2.build();
    }

    @NotNull
    public static final FirResolvedTypeRef toFirResolvedTypeRef(@NotNull ConeKotlinType $this$toFirResolvedTypeRef, @Nullable KtSourceElement source, @Nullable FirTypeRef delegatedTypeRef) {
        FirResolvedTypeRef firResolvedTypeRef;
        Intrinsics.checkNotNullParameter($this$toFirResolvedTypeRef, "<this>");
        ConeRigidType lowerBoundIfFlexible = ConeTypeUtilsKt.lowerBoundIfFlexible($this$toFirResolvedTypeRef);
        if (lowerBoundIfFlexible instanceof ConeErrorType) {
            FirErrorTypeRefBuilder firErrorTypeRefBuilder;
            boolean $i$f$buildErrorTypeRef = false;
            FirErrorTypeRefBuilder $this$toFirResolvedTypeRef_u24lambda_u249 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
            boolean bl = false;
            $this$toFirResolvedTypeRef_u24lambda_u249.setSource(source);
            $this$toFirResolvedTypeRef_u24lambda_u249.setDiagnostic(((ConeErrorType)lowerBoundIfFlexible).getDiagnostic());
            $this$toFirResolvedTypeRef_u24lambda_u249.setConeType($this$toFirResolvedTypeRef);
            $this$toFirResolvedTypeRef_u24lambda_u249.setDelegatedTypeRef(delegatedTypeRef);
            firResolvedTypeRef = firErrorTypeRefBuilder.build();
        } else {
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            boolean $i$f$buildResolvedTypeRef = false;
            FirResolvedTypeRefBuilder $this$toFirResolvedTypeRef_u24lambda_u2410 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            boolean bl = false;
            $this$toFirResolvedTypeRef_u24lambda_u2410.setSource(source);
            $this$toFirResolvedTypeRef_u24lambda_u2410.setConeType($this$toFirResolvedTypeRef);
            $this$toFirResolvedTypeRef_u24lambda_u2410.setDelegatedTypeRef(delegatedTypeRef);
            firResolvedTypeRef = firResolvedTypeRefBuilder.build();
        }
        return firResolvedTypeRef;
    }

    public static /* synthetic */ FirResolvedTypeRef toFirResolvedTypeRef$default(ConeKotlinType coneKotlinType, KtSourceElement ktSourceElement, FirTypeRef firTypeRef, int n2, Object object) {
        if ((n2 & 1) != 0) {
            ktSourceElement = null;
        }
        if ((n2 & 2) != 0) {
            firTypeRef = null;
        }
        return UtilsKt.toFirResolvedTypeRef(coneKotlinType, ktSourceElement, firTypeRef);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(UtilsKt.class, "exceptionHandler", "getExceptionHandler(Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/FirExceptionHandler;", 1))};
        $$delegatedProperties = kPropertyArray;
        FirSession.Companion this_$iv = FirSession.Companion;
        boolean $i$f$sessionComponentAccessor = false;
        exceptionHandler$delegate = TypeRegistry.generateAccessor$default((TypeRegistry)this_$iv, Reflection.getOrCreateKotlinClass(FirExceptionHandler.class), null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.PLUS_ASSIGN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.MINUS_ASSIGN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.TIMES_ASSIGN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.DIV_ASSIGN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.REM_ASSIGN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

