/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.rendering.ContextIndependentParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.SmartTypeRenderer;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

public class TabledDescriptorRenderer {
    protected final List<TableOrTextRenderer> renderers = Lists.newArrayList();

    public TabledDescriptorRenderer text(@NotNull TextRenderer textRenderer) {
        if (textRenderer == null) {
            TabledDescriptorRenderer.$$$reportNull$$$0(0);
        }
        this.renderers.add(textRenderer);
        return this;
    }

    public TabledDescriptorRenderer table(@NotNull TableRenderer tableRenderer) {
        if (tableRenderer == null) {
            TabledDescriptorRenderer.$$$reportNull$$$0(1);
        }
        this.renderers.add(tableRenderer);
        return this;
    }

    public static TextRenderer newText() {
        return new TextRenderer();
    }

    public static TableRenderer newTable() {
        return new TableRenderer();
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        for (TableOrTextRenderer tableOrTextRenderer : this.renderers) {
            if (tableOrTextRenderer instanceof TableRenderer) {
                this.renderTable((TableRenderer)tableOrTextRenderer, result2);
                continue;
            }
            this.renderText((TextRenderer)tableOrTextRenderer, result2);
        }
        return result2.toString();
    }

    @NotNull
    public DiagnosticParameterRenderer<KotlinType> getTypeRenderer() {
        SmartTypeRenderer smartTypeRenderer = Renderers.RENDER_TYPE;
        if (smartTypeRenderer == null) {
            TabledDescriptorRenderer.$$$reportNull$$$0(2);
        }
        return smartTypeRenderer;
    }

    @NotNull
    public DiagnosticParameterRenderer<TypeProjection> getTypeProjectionRenderer() {
        ContextIndependentParameterRenderer<TypeProjection> contextIndependentParameterRenderer = Renderers.TYPE_PROJECTION;
        if (contextIndependentParameterRenderer == null) {
            TabledDescriptorRenderer.$$$reportNull$$$0(3);
        }
        return contextIndependentParameterRenderer;
    }

    protected void renderText(TextRenderer textRenderer, StringBuilder result2) {
        for (TextRenderer.TextElement element : textRenderer.elements) {
            result2.append(element.text);
        }
    }

    protected void renderTable(TableRenderer table, StringBuilder result2) {
        if (table.rows.isEmpty()) {
            return;
        }
        RenderingContext context = TabledDescriptorRenderer.computeRenderingContext(table);
        for (TableRenderer.TableRow row : table.rows) {
            if (row instanceof TextRenderer) {
                this.renderText((TextRenderer)row, result2);
            }
            if (row instanceof TableRenderer.DescriptorRow) {
                result2.append(Renderers.COMPACT.render(((TableRenderer.DescriptorRow)row).descriptor, context));
            }
            if (row instanceof TableRenderer.FunctionArgumentsRow) {
                TableRenderer.FunctionArgumentsRow functionArgumentsRow = (TableRenderer.FunctionArgumentsRow)row;
                this.renderFunctionArguments(functionArgumentsRow.receiverType, functionArgumentsRow.argumentTypes, result2, context);
            }
            result2.append("\n");
        }
    }

    private void renderFunctionArguments(@Nullable KotlinType receiverType, @NotNull List<KotlinType> argumentTypes, StringBuilder result2, @NotNull RenderingContext context) {
        boolean hasReceiver;
        if (argumentTypes == null) {
            TabledDescriptorRenderer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            TabledDescriptorRenderer.$$$reportNull$$$0(5);
        }
        boolean bl = hasReceiver = receiverType != null;
        if (hasReceiver) {
            result2.append("receiver: ");
            result2.append(this.getTypeRenderer().render(receiverType, context));
            result2.append("  arguments: ");
        }
        if (argumentTypes.isEmpty()) {
            result2.append("()");
            return;
        }
        result2.append("(");
        Iterator<KotlinType> iterator2 = argumentTypes.iterator();
        while (iterator2.hasNext()) {
            KotlinType argumentType = iterator2.next();
            if (argumentType == null) {
                result2.append("<unknown>");
            } else {
                String renderedArgument = this.getTypeRenderer().render(argumentType, context);
                result2.append(renderedArgument);
            }
            if (!iterator2.hasNext()) continue;
            result2.append(",");
        }
        result2.append(")");
    }

    public static TabledDescriptorRenderer create() {
        return new TabledDescriptorRenderer();
    }

    @NotNull
    protected static RenderingContext computeRenderingContext(@NotNull TableRenderer table) {
        if (table == null) {
            TabledDescriptorRenderer.$$$reportNull$$$0(6);
        }
        ArrayList<Annotated> toRender = new ArrayList<Annotated>();
        for (TableRenderer.TableRow row : table.rows) {
            if (row instanceof TableRenderer.DescriptorRow) {
                toRender.add(((TableRenderer.DescriptorRow)row).descriptor);
                continue;
            }
            if (row instanceof TableRenderer.FunctionArgumentsRow) {
                toRender.add(((TableRenderer.FunctionArgumentsRow)row).receiverType);
                toRender.addAll(((TableRenderer.FunctionArgumentsRow)row).argumentTypes);
                continue;
            }
            if (!(row instanceof TextRenderer)) {
                throw new AssertionError((Object)("Unknown row of type " + row.getClass()));
            }
        }
        return new RenderingContext.Impl(toRender);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableRenderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeProjectionRenderer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "table";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renderFunctionArguments";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeRenderingContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TextElementType {
        STRONG,
        ERROR,
        DEFAULT;

    }

    public static class TextRenderer
    implements TableOrTextRenderer,
    TableRenderer.TableRow {
        public final List<TextElement> elements = Lists.newArrayList();

        public TextRenderer normal(@NotNull Object text) {
            if (text == null) {
                TextRenderer.$$$reportNull$$$0(0);
            }
            this.elements.add(new TextElement(TextElementType.DEFAULT, text.toString()));
            return this;
        }

        public TextRenderer error(@NotNull Object text) {
            if (text == null) {
                TextRenderer.$$$reportNull$$$0(1);
            }
            this.elements.add(new TextElement(TextElementType.ERROR, text.toString()));
            return this;
        }

        public TextRenderer strong(@NotNull Object text) {
            if (text == null) {
                TextRenderer.$$$reportNull$$$0(2);
            }
            this.elements.add(new TextElement(TextElementType.STRONG, text.toString()));
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "text";
            objectArray2[1] = "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TextRenderer";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "normal";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "strong";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static class TextElement {
            public TextElementType type;
            public String text;

            public TextElement(@NotNull TextElementType type2, @NotNull String text) {
                if (type2 == null) {
                    TextElement.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    TextElement.$$$reportNull$$$0(1);
                }
                this.type = type2;
                this.text = text;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TextRenderer$TextElement";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class TableRenderer
    implements TableOrTextRenderer {
        public final List<TableRow> rows = Lists.newArrayList();

        public TableRenderer descriptor(CallableDescriptor descriptor2) {
            this.rows.add(new DescriptorRow(descriptor2));
            return this;
        }

        public TableRenderer functionArgumentTypeList(@Nullable KotlinType receiverType, @NotNull List<KotlinType> argumentTypes) {
            if (argumentTypes == null) {
                TableRenderer.$$$reportNull$$$0(0);
            }
            return this.functionArgumentTypeList(receiverType, argumentTypes, position -> false);
        }

        public TableRenderer functionArgumentTypeList(@Nullable KotlinType receiverType, @NotNull List<KotlinType> argumentTypes, @NotNull Predicate<ConstraintPosition> isErrorPosition) {
            if (argumentTypes == null) {
                TableRenderer.$$$reportNull$$$0(1);
            }
            if (isErrorPosition == null) {
                TableRenderer.$$$reportNull$$$0(2);
            }
            this.rows.add(new FunctionArgumentsRow(receiverType, argumentTypes, isErrorPosition));
            return this;
        }

        public TableRenderer text(@NotNull String text) {
            if (text == null) {
                TableRenderer.$$$reportNull$$$0(3);
            }
            this.rows.add(TabledDescriptorRenderer.newText().normal(text));
            return this;
        }

        public TableRenderer text(@NotNull TextRenderer textRenderer) {
            if (textRenderer == null) {
                TableRenderer.$$$reportNull$$$0(4);
            }
            this.rows.add(textRenderer);
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argumentTypes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isErrorPosition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRenderer";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer$TableRenderer";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "functionArgumentTypeList";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "text";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static class FunctionArgumentsRow
        implements TableRow {
            public final KotlinType receiverType;
            public final List<KotlinType> argumentTypes;
            public final Predicate<ConstraintPosition> isErrorPosition;

            public FunctionArgumentsRow(KotlinType receiverType, List<KotlinType> argumentTypes, Predicate<ConstraintPosition> isErrorPosition) {
                this.receiverType = receiverType;
                this.argumentTypes = argumentTypes;
                this.isErrorPosition = isErrorPosition;
            }
        }

        public static class DescriptorRow
        implements TableRow {
            public final CallableDescriptor descriptor;

            public DescriptorRow(CallableDescriptor descriptor2) {
                this.descriptor = descriptor2;
            }
        }

        public static interface TableRow {
        }
    }

    public static interface TableOrTextRenderer {
    }
}

