/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.ContextIndependentParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRendererKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderersKt;
import org.jetbrains.kotlin.diagnostics.rendering.SmartDescriptorRenderer;
import org.jetbrains.kotlin.renderer.AnnotationArgumentsRenderingPolicy;
import org.jetbrains.kotlin.renderer.ClassifierNamePolicy;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualAnnotationsIncompatibilityType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/ExpectActualAnnotationIncompatibilityDiagnosticRenderers;", "", "<init>", "()V", "descriptorRender", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "DESCRIPTOR_RENDERER", "Lorg/jetbrains/kotlin/diagnostics/rendering/SmartDescriptorRenderer;", "INCOMPATIBILITY", "Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualAnnotationsIncompatibilityType;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "frontend"})
public final class ExpectActualAnnotationIncompatibilityDiagnosticRenderers {
    @NotNull
    public static final ExpectActualAnnotationIncompatibilityDiagnosticRenderers INSTANCE = new ExpectActualAnnotationIncompatibilityDiagnosticRenderers();
    @NotNull
    private static final DescriptorRenderer descriptorRender = DescriptorRenderer.Companion.withOptions(ExpectActualAnnotationIncompatibilityDiagnosticRenderers::descriptorRender$lambda$0);
    @NotNull
    public static final SmartDescriptorRenderer DESCRIPTOR_RENDERER = RenderersKt.asRenderer(descriptorRender);
    @NotNull
    public static final ContextIndependentParameterRenderer<ExpectActualAnnotationsIncompatibilityType<? extends AnnotationDescriptor>> INCOMPATIBILITY = DiagnosticParameterRendererKt.Renderer(ExpectActualAnnotationIncompatibilityDiagnosticRenderers::INCOMPATIBILITY$lambda$1);

    private ExpectActualAnnotationIncompatibilityDiagnosticRenderers() {
    }

    private static final Unit descriptorRender$lambda$0(DescriptorRendererOptions $this$withOptions) {
        Intrinsics.checkNotNullParameter($this$withOptions, "$this$withOptions");
        $this$withOptions.setAnnotationArgumentsRenderingPolicy(AnnotationArgumentsRenderingPolicy.UNLESS_EMPTY);
        $this$withOptions.setModifiers(SetsKt.emptySet());
        $this$withOptions.setWithDefinedIn(true);
        $this$withOptions.setClassifierNamePolicy(ClassifierNamePolicy.SHORT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final String INCOMPATIBILITY$lambda$1(ExpectActualAnnotationsIncompatibilityType incompatibilityType) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(incompatibilityType, "incompatibilityType");
        StringBuilder sb = new StringBuilder("Annotation `").append(DescriptorRenderer.renderAnnotation$default(descriptorRender, (AnnotationDescriptor)incompatibilityType.getExpectAnnotation(), null, 2, null)).append("` ");
        ExpectActualAnnotationsIncompatibilityType expectActualAnnotationsIncompatibilityType = incompatibilityType;
        if (expectActualAnnotationsIncompatibilityType instanceof ExpectActualAnnotationsIncompatibilityType.MissingOnActual) {
            stringBuilder = sb.append("is missing on actual declaration");
        } else if (expectActualAnnotationsIncompatibilityType instanceof ExpectActualAnnotationsIncompatibilityType.DifferentOnActual) {
            stringBuilder = sb.append("has different arguments on actual declaration: `").append(DescriptorRenderer.renderAnnotation$default(descriptorRender, (AnnotationDescriptor)((ExpectActualAnnotationsIncompatibilityType.DifferentOnActual)incompatibilityType).getActualAnnotation(), null, 2, null)).append("`");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

