/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a<\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\b\u0002\u0010\n\u001a\u00020\u0004\u001aB\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u0004\u001a<\u0010\u000e\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u0004\u001a\u001a\u0010\u0014\u001a\u00020\u0004*\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0002\u001a\u001a\u0010\u0015\u001a\u00020\u0004*\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0000\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0004\u001a\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0002\"\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0019\u001a\u00020\u0006*\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"markElement", "", "Lcom/intellij/openapi/util/TextRange;", "node", "Lcom/intellij/lang/LighterASTNode;", "startOffset", "", "endOffset", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "originalNode", "markRange", "from", "to", "markSingleElement", "DOC_AND_COMMENT_TOKENS", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "FILLER_TOKENS", "nonFillerFirstChildOrSelf", "nonFillerLastChildOrSelf", "isFiller", "", "hasSyntaxErrors", "startOffsetSkippingComments", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "getStartOffsetSkippingComments", "(Lorg/jetbrains/kotlin/KtLightSourceElement;)I", "frontend.common-psi"})
public final class LightTreePositioningStrategyKt {
    @NotNull
    private static final Set<IElementType> DOC_AND_COMMENT_TOKENS;
    @NotNull
    private static final Set<IElementType> FILLER_TOKENS;

    @NotNull
    public static final List<TextRange> markElement(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode originalNode) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(originalNode, "originalNode");
        return LightTreePositioningStrategyKt.markRange(node, node, startOffset, endOffset, tree, originalNode);
    }

    public static /* synthetic */ List markElement$default(LighterASTNode lighterASTNode, int n2, int n3, FlyweightCapableTreeStructure flyweightCapableTreeStructure, LighterASTNode lighterASTNode2, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            lighterASTNode2 = lighterASTNode;
        }
        return LightTreePositioningStrategyKt.markElement(lighterASTNode, n2, n3, flyweightCapableTreeStructure, lighterASTNode2);
    }

    @NotNull
    public static final List<TextRange> markRange(@NotNull LighterASTNode from, @NotNull LighterASTNode to, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode originalNode) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(originalNode, "originalNode");
        return CollectionsKt.listOf(LightTreePositioningStrategyKt.markSingleElement(from, to, startOffset, endOffset, tree, originalNode));
    }

    @NotNull
    public static final TextRange markSingleElement(@NotNull LighterASTNode from, @NotNull LighterASTNode to, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode originalNode) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(originalNode, "originalNode");
        LighterASTNode betterFrom = LightTreePositioningStrategyKt.nonFillerFirstChildOrSelf(from, tree);
        LighterASTNode betterTo = LightTreePositioningStrategyKt.nonFillerLastChildOrSelf(to, tree);
        int startDelta = tree.getStartOffset(betterFrom) - tree.getStartOffset(originalNode);
        int endDelta = tree.getEndOffset(betterTo) - tree.getEndOffset(originalNode);
        return new TextRange(startDelta + startOffset, endDelta + endOffset);
    }

    private static final LighterASTNode nonFillerFirstChildOrSelf(LighterASTNode $this$nonFillerFirstChildOrSelf, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        LighterASTNode lighterASTNode;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = LightTreeUtilsKt.getChildren($this$nonFillerFirstChildOrSelf, tree);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LighterASTNode it = (LighterASTNode)element$iv;
                boolean bl = false;
                if (!(!LightTreePositioningStrategyKt.isFiller(it))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((lighterASTNode = (LighterASTNode)v0) == null) {
            lighterASTNode = $this$nonFillerFirstChildOrSelf;
        }
        return lighterASTNode;
    }

    @NotNull
    public static final LighterASTNode nonFillerLastChildOrSelf(@NotNull LighterASTNode $this$nonFillerLastChildOrSelf, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
        LighterASTNode lighterASTNode;
        LighterASTNode lighterASTNode2;
        block2: {
            Intrinsics.checkNotNullParameter($this$nonFillerLastChildOrSelf, "<this>");
            Intrinsics.checkNotNullParameter(tree, "tree");
            List<LighterASTNode> $this$lastOrNull$iv = LightTreeUtilsKt.getChildren($this$nonFillerLastChildOrSelf, tree);
            boolean $i$f$lastOrNull = false;
            ListIterator<LighterASTNode> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                LighterASTNode element$iv;
                LighterASTNode it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(!LightTreePositioningStrategyKt.isFiller(it))) continue;
                lighterASTNode2 = element$iv;
                break block2;
            }
            lighterASTNode2 = null;
        }
        if ((lighterASTNode = (LighterASTNode)lighterASTNode2) == null) {
            lighterASTNode = $this$nonFillerLastChildOrSelf;
        }
        return lighterASTNode;
    }

    public static final boolean isFiller(@NotNull LighterASTNode $this$isFiller) {
        Intrinsics.checkNotNullParameter($this$isFiller, "<this>");
        return FILLER_TOKENS.contains($this$isFiller.getTokenType());
    }

    private static final boolean hasSyntaxErrors(LighterASTNode node, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        boolean bl;
        LighterASTNode lighterASTNode;
        block4: {
            List<LighterASTNode> children2;
            if (Intrinsics.areEqual(node.getTokenType(), TokenType.ERROR_ELEMENT)) {
                return true;
            }
            List<LighterASTNode> $this$lastOrNull$iv = children2 = LightTreeUtilsKt.getChildren(node, tree);
            boolean $i$f$lastOrNull = false;
            ListIterator<LighterASTNode> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                LighterASTNode element$iv;
                LighterASTNode it = element$iv = iterator$iv.previous();
                boolean bl2 = false;
                IElementType tokenType = it.getTokenType();
                if (!(!(tokenType instanceof KtSingleValueToken) && !DOC_AND_COMMENT_TOKENS.contains(tokenType))) continue;
                lighterASTNode = element$iv;
                break block4;
            }
            lighterASTNode = null;
        }
        LighterASTNode lighterASTNode2 = lighterASTNode;
        if (lighterASTNode2 != null) {
            LighterASTNode it = lighterASTNode2;
            boolean bl3 = false;
            bl = LightTreePositioningStrategyKt.hasSyntaxErrors(it, tree);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final int getStartOffsetSkippingComments(@NotNull KtLightSourceElement $this$startOffsetSkippingComments) {
        int n2;
        Intrinsics.checkNotNullParameter($this$startOffsetSkippingComments, "<this>");
        List<LighterASTNode> children2 = LightTreeUtilsKt.getChildren($this$startOffsetSkippingComments.getLighterASTNode(), $this$startOffsetSkippingComments.getTreeStructure());
        Iterable $this$takeWhile$iv = children2;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            LighterASTNode it = (LighterASTNode)item$iv;
            boolean bl = false;
            if (!FILLER_TOKENS.contains(it.getTokenType())) break;
            list$iv.add(item$iv);
        }
        List comments = list$iv;
        Iterable iterable = comments;
        int n3 = $this$startOffsetSkippingComments.getStartOffset();
        int n4 = 0;
        for (Iterator iterator2 : iterable) {
            void it;
            Object item$iv;
            item$iv = (LighterASTNode)((Object)iterator2);
            n2 = n4;
            boolean bl = false;
            int n5 = it.getTextLength();
            n4 = n2 + n5;
        }
        n2 = n4;
        return n3 + n2;
    }

    public static final /* synthetic */ boolean access$hasSyntaxErrors(LighterASTNode node, FlyweightCapableTreeStructure tree) {
        return LightTreePositioningStrategyKt.hasSyntaxErrors(node, tree);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.WHITE_SPACE, KtTokens.IDENTIFIER, KtTokens.EOL_COMMENT, KtTokens.BLOCK_COMMENT, KtTokens.SHEBANG_COMMENT, KtTokens.DOC_COMMENT};
        DOC_AND_COMMENT_TOKENS = SetsKt.setOf(iElementTypeArray);
        iElementTypeArray = new IElementType[]{KtTokens.WHITE_SPACE, KtTokens.EOL_COMMENT, KtTokens.BLOCK_COMMENT, KtTokens.SHEBANG_COMMENT, KtTokens.DOC_COMMENT};
        FILLER_TOKENS = SetsKt.setOf(iElementTypeArray);
    }
}

