/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u0000H\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0000H\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0011\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u0005\u0010\tR\u0014\u0010\u001e\u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0014\u0010 \u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibility;", "", "", "name", "", "isPublicAPI", "<init>", "(Ljava/lang/String;Z)V", "mustCheckInImports", "()Z", "visibility", "", "compareTo", "(Lorg/jetbrains/kotlin/descriptors/Visibility;)Ljava/lang/Integer;", "toString", "()Ljava/lang/String;", "normalize", "()Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "customEffectiveVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/name/FqName;", "fromPackage", "myPackage", "visibleFromPackage", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;)Z", "Ljava/lang/String;", "getName", "Z", "getInternalDisplayName", "internalDisplayName", "getExternalDisplayName", "externalDisplayName"})
public abstract class Visibility {
    @NotNull
    private final String name;
    private final boolean isPublicAPI;

    protected Visibility(@NotNull String name, boolean isPublicAPI) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
        this.isPublicAPI = isPublicAPI;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean isPublicAPI() {
        return this.isPublicAPI;
    }

    @NotNull
    public String getInternalDisplayName() {
        return this.name;
    }

    @NotNull
    public String getExternalDisplayName() {
        return this.getInternalDisplayName();
    }

    public abstract boolean mustCheckInImports();

    @Nullable
    public Integer compareTo(@NotNull Visibility visibility) {
        Intrinsics.checkNotNullParameter(visibility, "visibility");
        return Visibilities.INSTANCE.compareLocal$compiler_common(this, visibility);
    }

    @NotNull
    public final String toString() {
        return this.getInternalDisplayName();
    }

    @NotNull
    public Visibility normalize() {
        return this;
    }

    @Nullable
    public EffectiveVisibility customEffectiveVisibility() {
        return null;
    }

    public boolean visibleFromPackage(@NotNull FqName fromPackage, @NotNull FqName myPackage) {
        Intrinsics.checkNotNullParameter(fromPackage, "fromPackage");
        Intrinsics.checkNotNullParameter(myPackage, "myPackage");
        return true;
    }
}

