/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007"}, d2={"Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "", "isOverridable", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Z", "isOverridableOrOverrides", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isFinalClass", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Z", "isFinalOrEnum"})
public final class ModalityUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOverridable(@NotNull CallableMemberDescriptor $this$isOverridable) {
        Intrinsics.checkNotNullParameter($this$isOverridable, "<this>");
        if (Intrinsics.areEqual($this$isOverridable.getVisibility(), DescriptorVisibilities.PRIVATE)) return false;
        if ($this$isOverridable.getModality() == Modality.FINAL) return false;
        DeclarationDescriptor declarationDescriptor = $this$isOverridable.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) return true;
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) return true;
        if (!ModalityUtilsKt.isFinalClass(classDescriptor)) return true;
        return false;
    }

    public static final boolean isOverridableOrOverrides(@NotNull CallableMemberDescriptor $this$isOverridableOrOverrides) {
        Intrinsics.checkNotNullParameter($this$isOverridableOrOverrides, "<this>");
        return ModalityUtilsKt.isOverridable($this$isOverridableOrOverrides) || DescriptorUtils.isOverride($this$isOverridableOrOverrides);
    }

    public static final boolean isFinalClass(@NotNull ClassDescriptor $this$isFinalClass) {
        Intrinsics.checkNotNullParameter($this$isFinalClass, "<this>");
        return $this$isFinalClass.getModality() == Modality.FINAL && $this$isFinalClass.getKind() != ClassKind.ENUM_CLASS;
    }

    public static final boolean isFinalOrEnum(@NotNull ClassDescriptor $this$isFinalOrEnum) {
        Intrinsics.checkNotNullParameter($this$isFinalOrEnum, "<this>");
        return $this$isFinalOrEnum.getModality() == Modality.FINAL;
    }
}

