/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a%\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u001d\u0010\b\u001a\u0004\u0018\u00010\u0005*\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\b\u0010\t\u001a\u001b\u0010\n\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\n\u0010\t\u001a\u001b\u0010\u000e\u001a\u00020\r*\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a!\u0010\u0015\u001a\u00020\u0014*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0011\u0010\u0015\u001a\u00020\u0014*\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0017\u001a\u0015\u0010\u0019\u001a\u0004\u0018\u00010\u0018*\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a\u0011\u0010\u001c\u001a\u00020\u0014*\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a/\u0010\u001e\u001a\u00020\u0014*\u00020\u0010\u0082\u0002\u001b\n\u0019\b\u0000\u0012\r\u0010\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u0001\u0018\u0000\u001a\u0006\u0010\u0000\"\u00020\u0005\u00a2\u0006\u0004\b\u001e\u0010\u0017\u001a\u0015\u0010\u001f\u001a\u0004\u0018\u00010\u0001*\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u0011\u0010\"\u001a\u00020\u0014*\u00020!\u00a2\u0006\u0004\b\"\u0010#\u001a\u0011\u0010$\u001a\u00020\u0014*\u00020!\u00a2\u0006\u0004\b$\u0010#\u001a\u0014\u0010&\u001a\u00020%*\u00020\u0010H\u0087\u0010\u00a2\u0006\u0004\b&\u0010'"}, d2={"Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "lookupLocation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "resolveClassByFqName", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "findContinuationClassDescriptorOrNull", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "findContinuationClassDescriptor", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlinType", "Lorg/jetbrains/kotlin/types/SimpleType;", "getContinuationOfTypeOrAny", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "", "name", "packageName", "", "isTopLevelInPackage", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Ljava/lang/String;Ljava/lang/String;)Z", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getTopLevelContainingClassifier", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isSupportedForCallableReference", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Z", "isSealed", "containingPackage", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isTypedEqualsInValueClass", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "overridesEqualsFromAny", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "findPackage", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;"})
public final class DescriptorUtilKt {
    @Nullable
    public static final ClassDescriptor resolveClassByFqName(@NotNull ModuleDescriptor $this$resolveClassByFqName, @NotNull FqName fqName2, @NotNull LookupLocation lookupLocation) {
        MemberScope memberScope2;
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter($this$resolveClassByFqName, "<this>");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(lookupLocation, "lookupLocation");
        if (fqName2.isRoot()) {
            return null;
        }
        ClassifierDescriptor classifierDescriptor = $this$resolveClassByFqName.getPackage(fqName2.parent()).getMemberScope().getContributedClassifier(fqName2.shortName(), lookupLocation);
        ClassDescriptor classDescriptor2 = classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor != null) {
            ClassDescriptor it = classDescriptor;
            boolean bl = false;
            return it;
        }
        classifierDescriptor = DescriptorUtilKt.resolveClassByFqName($this$resolveClassByFqName, fqName2.parent(), lookupLocation);
        classDescriptor = classifierDescriptor != null && (memberScope2 = classifierDescriptor.getUnsubstitutedInnerClassesScope()) != null ? memberScope2.getContributedClassifier(fqName2.shortName(), lookupLocation) : null;
        return classDescriptor instanceof ClassDescriptor ? classDescriptor : null;
    }

    @Nullable
    public static final ClassDescriptor findContinuationClassDescriptorOrNull(@NotNull ModuleDescriptor $this$findContinuationClassDescriptorOrNull, @NotNull LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter($this$findContinuationClassDescriptorOrNull, "<this>");
        Intrinsics.checkNotNullParameter(lookupLocation, "lookupLocation");
        return DescriptorUtilKt.resolveClassByFqName($this$findContinuationClassDescriptorOrNull, StandardNames.CONTINUATION_INTERFACE_FQ_NAME, lookupLocation);
    }

    @NotNull
    public static final ClassDescriptor findContinuationClassDescriptor(@NotNull ModuleDescriptor $this$findContinuationClassDescriptor, @NotNull LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter($this$findContinuationClassDescriptor, "<this>");
        Intrinsics.checkNotNullParameter(lookupLocation, "lookupLocation");
        ClassDescriptor $this$sure$iv = DescriptorUtilKt.findContinuationClassDescriptorOrNull($this$findContinuationClassDescriptor, lookupLocation);
        boolean $i$f$sure = false;
        ClassDescriptor classDescriptor = $this$sure$iv;
        if (classDescriptor == null) {
            boolean bl = false;
            String string = "Continuation interface is not found";
            throw new AssertionError((Object)string);
        }
        return classDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final SimpleType getContinuationOfTypeOrAny(@NotNull ModuleDescriptor $this$getContinuationOfTypeOrAny, @NotNull KotlinType kotlinType) {
        SimpleType simpleType2;
        SimpleType simpleType3;
        Intrinsics.checkNotNullParameter($this$getContinuationOfTypeOrAny, "<this>");
        Intrinsics.checkNotNullParameter(kotlinType, "kotlinType");
        ClassDescriptor classDescriptor = DescriptorUtilKt.findContinuationClassDescriptorOrNull(DescriptorUtilsKt.getModule($this$getContinuationOfTypeOrAny), NoLookupLocation.FROM_DESERIALIZATION);
        if (classDescriptor != null && (simpleType3 = classDescriptor.getDefaultType()) != null) {
            SimpleType it = simpleType3;
            boolean bl = false;
            SimpleType simpleType4 = KotlinTypeFactory.simpleType$default(it, null, null, CollectionsKt.listOf(TypeUtilsKt.asTypeProjection(kotlinType)), false, 22, null);
            if (simpleType4 != null) {
                simpleType2 = simpleType4;
                return simpleType2;
            }
        }
        SimpleType simpleType5 = DescriptorUtilsKt.getModule($this$getContinuationOfTypeOrAny).getBuiltIns().getNullableAnyType();
        simpleType2 = simpleType5;
        Intrinsics.checkNotNullExpressionValue(simpleType5, "getNullableAnyType(...)");
        return simpleType2;
    }

    public static final boolean isTopLevelInPackage(@NotNull DeclarationDescriptor $this$isTopLevelInPackage, @NotNull String name, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter($this$isTopLevelInPackage, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        if (!Intrinsics.areEqual(name, $this$isTopLevelInPackage.getName().asString())) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = $this$isTopLevelInPackage.getContainingDeclaration();
        PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
        if (packageFragmentDescriptor == null) {
            return false;
        }
        PackageFragmentDescriptor containingDeclaration = packageFragmentDescriptor;
        String packageFqName = containingDeclaration.getFqName().asString();
        return Intrinsics.areEqual(packageName, packageFqName);
    }

    public static final boolean isTopLevelInPackage(@NotNull DeclarationDescriptor $this$isTopLevelInPackage) {
        Intrinsics.checkNotNullParameter($this$isTopLevelInPackage, "<this>");
        return $this$isTopLevelInPackage.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    @Nullable
    public static final ClassifierDescriptor getTopLevelContainingClassifier(@NotNull DeclarationDescriptor $this$getTopLevelContainingClassifier) {
        Intrinsics.checkNotNullParameter($this$getTopLevelContainingClassifier, "<this>");
        DeclarationDescriptor containingDeclaration = $this$getTopLevelContainingClassifier.getContainingDeclaration();
        if (containingDeclaration == null || $this$getTopLevelContainingClassifier instanceof PackageFragmentDescriptor) {
            return null;
        }
        return !DescriptorUtilKt.isTopLevelInPackage(containingDeclaration) ? DescriptorUtilKt.getTopLevelContainingClassifier(containingDeclaration) : (containingDeclaration instanceof ClassifierDescriptor ? (ClassifierDescriptor)containingDeclaration : null);
    }

    public static final boolean isSupportedForCallableReference(@NotNull CallableDescriptor $this$isSupportedForCallableReference) {
        Intrinsics.checkNotNullParameter($this$isSupportedForCallableReference, "<this>");
        return $this$isSupportedForCallableReference instanceof PropertyDescriptor || $this$isSupportedForCallableReference instanceof FunctionDescriptor;
    }

    public static final boolean isSealed(@NotNull DeclarationDescriptor $this$isSealed) {
        Intrinsics.checkNotNullParameter($this$isSealed, "<this>");
        return DescriptorUtils.isSealedClass($this$isSealed);
    }

    @Nullable
    public static final FqName containingPackage(@NotNull DeclarationDescriptor $this$containingPackage) {
        DeclarationDescriptor container;
        Intrinsics.checkNotNullParameter($this$containingPackage, "<this>");
        for (container = $this$containingPackage.getContainingDeclaration(); container != null && !(container instanceof PackageFragmentDescriptor); container = container.getContainingDeclaration()) {
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)container;
        return packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTypedEqualsInValueClass(@NotNull FunctionDescriptor $this$isTypedEqualsInValueClass) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter($this$isTypedEqualsInValueClass, "<this>");
        DeclarationDescriptor declarationDescriptor = $this$isTypedEqualsInValueClass.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) return false;
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        Annotated annotated = classDescriptor2;
        if (classDescriptor2 == null) return false;
        ClassDescriptor it = classDescriptor = annotated;
        boolean bl = false;
        if (!InlineClassesUtilsKt.isValueClass(it)) return false;
        ClassDescriptor classDescriptor3 = classDescriptor;
        annotated = classDescriptor3;
        if (classDescriptor3 == null) return false;
        SimpleType simpleType2 = annotated.getDefaultType();
        annotated = simpleType2;
        if (simpleType2 == null) return false;
        if ((annotated = TypeUtilsKt.replaceArgumentsWithStarProjections((KotlinType)annotated)) == null) {
            return false;
        }
        Annotated annotated2 = annotated;
        KotlinType kotlinType = $this$isTypedEqualsInValueClass.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType = kotlinType;
        if (!Intrinsics.areEqual($this$isTypedEqualsInValueClass.getName(), OperatorNameConventions.EQUALS)) return false;
        if (!TypeUtilsKt.isBoolean(returnType)) {
            if (!TypeUtilsKt.isNothing(returnType)) return false;
        }
        if ($this$isTypedEqualsInValueClass.getValueParameters().size() != 1) return false;
        KotlinType kotlinType2 = $this$isTypedEqualsInValueClass.getValueParameters().get(0).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
        if (!Intrinsics.areEqual(TypeUtilsKt.replaceArgumentsWithStarProjections(kotlinType2), annotated2)) return false;
        if (!$this$isTypedEqualsInValueClass.getContextReceiverParameters().isEmpty()) return false;
        if ($this$isTypedEqualsInValueClass.getExtensionReceiverParameter() != null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean overridesEqualsFromAny(@NotNull FunctionDescriptor $this$overridesEqualsFromAny) {
        Intrinsics.checkNotNullParameter($this$overridesEqualsFromAny, "<this>");
        if (!Intrinsics.areEqual($this$overridesEqualsFromAny.getName(), OperatorNameConventions.EQUALS)) return false;
        if ($this$overridesEqualsFromAny.getValueParameters().size() != 1) return false;
        KotlinType kotlinType = $this$overridesEqualsFromAny.getValueParameters().get(0).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        if (!TypeUtilsKt.isNullableAny(kotlinType)) return false;
        if (!$this$overridesEqualsFromAny.getContextReceiverParameters().isEmpty()) return false;
        if ($this$overridesEqualsFromAny.getExtensionReceiverParameter() != null) return false;
        return true;
    }

    @NotNull
    public static final PackageFragmentDescriptor findPackage(@NotNull DeclarationDescriptor $this$findPackage) {
        Intrinsics.checkNotNullParameter($this$findPackage, "<this>");
        while (!($this$findPackage instanceof PackageFragmentDescriptor)) {
            Intrinsics.checkNotNull($this$findPackage.getContainingDeclaration());
        }
        return (PackageFragmentDescriptor)$this$findPackage;
    }
}

