/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ContractDescriptionValue;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.contracts.parsing.PsiConditionParser;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AbstractTypeParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedType;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u00192\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u001cH\u0002J*\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0013H\u0002J\u001f\u0010&\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010(J\u001f\u0010)\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020*2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010+R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/PsiConditionParser;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "", "collector", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "callContext", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "dispatcher", "Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "<init>", "(Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;)V", "visitIsExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "data", "(Lorg/jetbrains/kotlin/psi/KtIsExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "parseIdentityEquals", "processEquals", "left", "Lorg/jetbrains/kotlin/contracts/description/expressions/ContractDescriptionValue;", "right", "isNegated", "", "reportOn", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "(Lorg/jetbrains/kotlin/psi/KtUnaryExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "(Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "frontend"})
public final class PsiConditionParser
extends KtVisitor<BooleanExpression, Unit> {
    @NotNull
    private final ContractParsingDiagnosticsCollector collector;
    @NotNull
    private final ContractCallContext callContext;
    @NotNull
    private final PsiContractParserDispatcher dispatcher;

    public PsiConditionParser(@NotNull ContractParsingDiagnosticsCollector collector2, @NotNull ContractCallContext callContext, @NotNull PsiContractParserDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter(collector2, "collector");
        Intrinsics.checkNotNullParameter(callContext, "callContext");
        Intrinsics.checkNotNullParameter(dispatcher, "dispatcher");
        this.collector = collector2;
        this.callContext = callContext;
        this.dispatcher = dispatcher;
    }

    @Override
    @Nullable
    public BooleanExpression visitIsExpression(@NotNull KtIsExpression expression, @NotNull Unit data2) {
        boolean reifiedGenericsAllowed;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        VariableReference variableReference = this.dispatcher.parseVariable(expression.getLeftHandSide());
        if (variableReference == null) {
            return null;
        }
        VariableReference variable = variableReference;
        KtTypeReference ktTypeReference = expression.getTypeReference();
        if (ktTypeReference == null) {
            return null;
        }
        KtTypeReference typeReference = ktTypeReference;
        KotlinType kotlinType = (KotlinType)this.callContext.getBindingContext().get(BindingContext.TYPE, typeReference);
        if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (type2 instanceof CapturedType) {
            this.collector.badDescription("references to captured types are forbidden in contracts", typeReference);
            return null;
        }
        if (!(!(descriptor2 instanceof AbstractTypeParameterDescriptor) || (reifiedGenericsAllowed = this.callContext.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowReifiedGenericsInContracts)) && ((AbstractTypeParameterDescriptor)descriptor2).isReified())) {
            String message = reifiedGenericsAllowed ? "references to not reified type parameters are forbidden in contracts" : "references to type parameters are forbidden in contracts";
            this.collector.badDescription(message, typeReference);
            return null;
        }
        KotlinType kotlinType2 = variable.getDescriptor().getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
        KotlinTypeChecker kotlinTypeChecker = KotlinTypeChecker.DEFAULT;
        Intrinsics.checkNotNullExpressionValue(kotlinTypeChecker, "DEFAULT");
        if (CastDiagnosticsUtil.isCastErased(kotlinType2, type2, kotlinTypeChecker)) {
            return null;
        }
        return new IsInstancePredicate(variable, type2, expression.isNegated());
    }

    @Override
    @Nullable
    public BooleanExpression visitKtElement(@NotNull KtElement element, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(data2, "data");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element, this.callContext.getBindingContext());
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 == null || (resolvedCall3 = resolvedCall3.getResultingDescriptor()) == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> descriptor2 = resolvedCall3;
        if (descriptor2 instanceof ValueDescriptor) {
            VariableReference variableReference = this.dispatcher.parseVariable(element instanceof KtExpression ? (KtExpression)element : null);
            if (variableReference == null) {
                return null;
            }
            VariableReference booleanVariable = variableReference;
            return booleanVariable instanceof BooleanVariableReference ? (BooleanVariableReference)booleanVariable : null;
        }
        if (PsiContractsUtilsKt.isEqualsDescriptor((DeclarationDescriptor)((Object)descriptor2))) {
            ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
            ExpressionReceiver expressionReceiver = receiverValue instanceof ExpressionReceiver ? (ExpressionReceiver)receiverValue : null;
            ContractDescriptionValue contractDescriptionValue = this.dispatcher.parseValue(expressionReceiver != null ? expressionReceiver.getExpression() : null);
            if (contractDescriptionValue == null) {
                return null;
            }
            ContractDescriptionValue left = contractDescriptionValue;
            ContractDescriptionValue contractDescriptionValue2 = this.dispatcher.parseValue(PsiContractsUtilsKt.firstArgumentAsExpressionOrNull(resolvedCall2));
            if (contractDescriptionValue2 == null) {
                return null;
            }
            ContractDescriptionValue right = contractDescriptionValue2;
            KtBinaryExpression ktBinaryExpression = element instanceof KtBinaryExpression ? (KtBinaryExpression)element : null;
            IElementType iElementType = ktBinaryExpression != null ? ktBinaryExpression.getOperationToken() : null;
            Object object = KtTokens.EXCLEQ;
            if (object == null) {
                object = false;
            }
            boolean isNegated = Intrinsics.areEqual(iElementType, object);
            return this.processEquals(left, right, isNegated, element);
        }
        this.collector.badDescription("unsupported construction", element);
        return null;
    }

    @Override
    @Nullable
    public BooleanExpression visitConstantExpression(@NotNull KtConstantExpression expression, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        ConstantReference constantReference = this.dispatcher.parseConstant(expression);
        return constantReference instanceof BooleanConstantReference ? (BooleanConstantReference)constantReference : null;
    }

    @Override
    @Nullable
    public BooleanExpression visitCallExpression(@NotNull KtCallExpression expression, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.collector.badDescription("call-expressions are not supported yet", expression);
        return null;
    }

    @Override
    @Nullable
    public BooleanExpression visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull Unit data2) {
        Object object;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        Function2 operationConstructor = null;
        IElementType iElementType = expression.getOperationToken();
        if (Intrinsics.areEqual(iElementType, KtTokens.ANDAND)) {
            operationConstructor = visitBinaryExpression.1.INSTANCE;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.OROR)) {
            operationConstructor = visitBinaryExpression.2.INSTANCE;
        } else {
            if (Intrinsics.areEqual(iElementType, KtTokens.EXCLEQEQEQ) || Intrinsics.areEqual(iElementType, KtTokens.EQEQEQ)) {
                return this.parseIdentityEquals(expression);
            }
            return (BooleanExpression)super.visitBinaryExpression(expression, data2);
        }
        if ((object = expression.getLeft()) == null || (object = (BooleanExpression)object.accept(this, data2)) == null) {
            return null;
        }
        Object left = object;
        Object object2 = expression.getRight();
        if (object2 == null || (object2 = (BooleanExpression)object2.accept(this, data2)) == null) {
            return null;
        }
        Object right = object2;
        return (BooleanExpression)operationConstructor.invoke(left, right);
    }

    private final BooleanExpression parseIdentityEquals(KtBinaryExpression expression) {
        ContractDescriptionValue contractDescriptionValue = this.dispatcher.parseValue(expression.getLeft());
        if (contractDescriptionValue == null) {
            return null;
        }
        ContractDescriptionValue lhs = contractDescriptionValue;
        ContractDescriptionValue contractDescriptionValue2 = this.dispatcher.parseValue(expression.getRight());
        if (contractDescriptionValue2 == null) {
            return null;
        }
        ContractDescriptionValue rhs = contractDescriptionValue2;
        return this.processEquals(lhs, rhs, Intrinsics.areEqual(expression.getOperationToken(), KtTokens.EXCLEQEQEQ), expression);
    }

    private final BooleanExpression processEquals(ContractDescriptionValue left, ContractDescriptionValue right, boolean isNegated, KtElement reportOn) {
        BooleanExpression booleanExpression;
        if (left instanceof ConstantReference && Intrinsics.areEqual(left, ConstantReference.Companion.getNULL()) && right instanceof VariableReference) {
            booleanExpression = new IsNullPredicate((VariableReference)right, isNegated);
        } else if (right instanceof ConstantReference && Intrinsics.areEqual(right, ConstantReference.Companion.getNULL()) && left instanceof VariableReference) {
            booleanExpression = new IsNullPredicate((VariableReference)left, isNegated);
        } else {
            this.collector.badDescription("only equality comparisons with 'null' allowed", reportOn);
            booleanExpression = null;
        }
        return booleanExpression;
    }

    @Override
    @Nullable
    public BooleanExpression visitUnaryExpression(@NotNull KtUnaryExpression expression, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (!Intrinsics.areEqual(expression.getOperationToken(), KtTokens.EXCL)) {
            return (BooleanExpression)super.visitUnaryExpression(expression, data2);
        }
        Object object = expression.getBaseExpression();
        if (object == null || (object = (BooleanExpression)object.accept(this, data2)) == null) {
            return null;
        }
        Object arg = object;
        if (!(arg instanceof ContractDescriptionValue)) {
            KtExpression ktExpression = expression.getBaseExpression();
            Intrinsics.checkNotNull(ktExpression);
            this.collector.badDescription("negations in contract description can be applied only to variables/values", ktExpression);
        }
        return new LogicalNot((BooleanExpression)arg);
    }

    @Override
    @Nullable
    public BooleanExpression visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        KtExpression ktExpression = KtPsiUtil.deparenthesize(expression);
        return ktExpression != null ? (BooleanExpression)ktExpression.accept(this, data2) : null;
    }
}

