/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config.phaser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LoggingContext;
import org.jetbrains.kotlin.config.phaser.ActionState;
import org.jetbrains.kotlin.config.phaser.BeforeOrAfter;
import org.jetbrains.kotlin.config.phaser.CompilerPhase;
import org.jetbrains.kotlin.config.phaser.PhaseConfig;
import org.jetbrains.kotlin.config.phaser.PhaserState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\b\u000e\b&\u0018\u0000*\n\b\u0000\u0010\u0002 \u0000*\u00020\u0001*\u0004\b\u0001\u0010\u0003*\u0004\b\u0002\u0010\u00042\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0005B\u0089\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00000\b\u0012$\b\u0002\u0010\r\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00028\u0001`\f0\b\u0012$\b\u0002\u0010\u000e\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00028\u0002`\f0\b\u00126\b\u0002\u0010\u0012\u001a0\u0012,\u0012*\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u000fj\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000`\u00110\b\u0012N\b\u0002\u0010\u0014\u001aH\u0012D\u0012B\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u000fj\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0013\u0012\u0004\u0012\u00028\u0000`\u00110\b\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001f\u001a\u00028\u00022\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00028\u00022\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001H&\u00a2\u0006\u0004\b!\u0010\"J/\u0010#\u001a\u00028\u00022\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001H&\u00a2\u0006\u0004\b#\u0010 J/\u0010$\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001H\u0002\u00a2\u0006\u0004\b$\u0010%J7\u0010'\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u0002H\u0002\u00a2\u0006\u0004\b'\u0010(J/\u0010*\u001a\u00028\u00022\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u0001H\u0002\u00a2\u0006\u0004\b*\u0010 J7\u0010-\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0015\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00000\u00130,2\u0006\u0010+\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b/\u00100R\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u00101\u001a\u0004\b2\u00100R,\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00000\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u00103\u001a\u0004\b4\u00105R6\u0010\r\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00028\u0001`\f0\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\r\u00103\u001a\u0004\b6\u00105R6\u0010\u000e\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00028\u0002`\f0\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000e\u00103\u001a\u0004\b7\u00105RB\u0010\u0012\u001a0\u0012,\u0012*\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u000fj\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000`\u00110\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u00103RZ\u0010\u0014\u001aH\u0012D\u0012B\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\u000fj\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0013\u0012\u0004\u0012\u00028\u0000`\u00110\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u00103R\u001a\u0010\u0016\u001a\u00020\u00158\u0004X\u0085\u0004\u00a2\u0006\f\n\u0004\b\u0016\u00108\u001a\u0004\b9\u0010:"}, d2={"Lorg/jetbrains/kotlin/config/phaser/NamedCompilerPhase;", "Lorg/jetbrains/kotlin/config/LoggingContext;", "Context", "Input", "Output", "Lorg/jetbrains/kotlin/config/phaser/CompilerPhase;", "", "name", "", "prerequisite", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/config/phaser/Checker;", "preconditions", "postconditions", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/config/phaser/ActionState;", "Lorg/jetbrains/kotlin/config/phaser/Action;", "preactions", "Lkotlin/Pair;", "postactions", "", "nlevels", "<init>", "(Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;I)V", "Lorg/jetbrains/kotlin/config/phaser/PhaseConfig;", "phaseConfig", "Lorg/jetbrains/kotlin/config/phaser/PhaserState;", "phaserState", "context", "input", "invoke", "(Lorg/jetbrains/kotlin/config/phaser/PhaseConfig;Lorg/jetbrains/kotlin/config/phaser/PhaserState;Lorg/jetbrains/kotlin/config/LoggingContext;Ljava/lang/Object;)Ljava/lang/Object;", "phaseBody", "(Lorg/jetbrains/kotlin/config/LoggingContext;Ljava/lang/Object;)Ljava/lang/Object;", "outputIfNotEnabled", "runBefore", "(Lorg/jetbrains/kotlin/config/phaser/PhaseConfig;Lorg/jetbrains/kotlin/config/phaser/PhaserState;Lorg/jetbrains/kotlin/config/LoggingContext;Ljava/lang/Object;)V", "output", "runAfter", "(Lorg/jetbrains/kotlin/config/phaser/PhaseConfig;Lorg/jetbrains/kotlin/config/phaser/PhaserState;Lorg/jetbrains/kotlin/config/LoggingContext;Ljava/lang/Object;Ljava/lang/Object;)V", "source", "runAndProfile", "startDepth", "", "getNamedSubphases", "(I)Ljava/util/List;", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getName", "Ljava/util/Set;", "getPrerequisite", "()Ljava/util/Set;", "getPreconditions", "getPostconditions", "I", "getNlevels", "()I"})
public abstract class NamedCompilerPhase<Context extends LoggingContext, Input, Output>
implements CompilerPhase<Context, Input, Output> {
    @NotNull
    private final String name;
    @NotNull
    private final Set<NamedCompilerPhase<?, ?, ?>> prerequisite;
    @NotNull
    private final Set<Function1<Input, Unit>> preconditions;
    @NotNull
    private final Set<Function1<Output, Unit>> postconditions;
    @NotNull
    private final Set<Function3<ActionState, Input, Context, Unit>> preactions;
    @NotNull
    private final Set<Function3<ActionState, Pair<? extends Input, ? extends Output>, Context, Unit>> postactions;
    private final int nlevels;

    public NamedCompilerPhase(@NotNull String name, @NotNull Set<? extends NamedCompilerPhase<?, ?, ?>> prerequisite, @NotNull Set<? extends Function1<? super Input, Unit>> preconditions, @NotNull Set<? extends Function1<? super Output, Unit>> postconditions, @NotNull Set<? extends Function3<? super ActionState, ? super Input, ? super Context, Unit>> preactions, @NotNull Set<? extends Function3<? super ActionState, ? super Pair<? extends Input, ? extends Output>, ? super Context, Unit>> postactions, int nlevels) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(prerequisite, "prerequisite");
        Intrinsics.checkNotNullParameter(preconditions, "preconditions");
        Intrinsics.checkNotNullParameter(postconditions, "postconditions");
        Intrinsics.checkNotNullParameter(preactions, "preactions");
        Intrinsics.checkNotNullParameter(postactions, "postactions");
        this.name = name;
        this.prerequisite = prerequisite;
        this.preconditions = preconditions;
        this.postconditions = postconditions;
        this.preactions = preactions;
        this.postactions = postactions;
        this.nlevels = nlevels;
    }

    public /* synthetic */ NamedCompilerPhase(String string, Set set, Set set2, Set set3, Set set4, Set set5, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n3 & 4) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n3 & 8) != 0) {
            set3 = SetsKt.emptySet();
        }
        if ((n3 & 0x10) != 0) {
            set4 = SetsKt.emptySet();
        }
        if ((n3 & 0x20) != 0) {
            set5 = SetsKt.emptySet();
        }
        if ((n3 & 0x40) != 0) {
            n2 = 0;
        }
        this(string, set, set2, set3, set4, set5, n2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Set<NamedCompilerPhase<?, ?, ?>> getPrerequisite() {
        return this.prerequisite;
    }

    @NotNull
    public final Set<Function1<Input, Unit>> getPreconditions() {
        return this.preconditions;
    }

    @NotNull
    public final Set<Function1<Output, Unit>> getPostconditions() {
        return this.postconditions;
    }

    protected final int getNlevels() {
        return this.nlevels;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Output invoke(@NotNull PhaseConfig phaseConfig, @NotNull PhaserState phaserState, @NotNull Context context, Input input) {
        Output Output2;
        Intrinsics.checkNotNullParameter(phaseConfig, "phaseConfig");
        Intrinsics.checkNotNullParameter(phaserState, "phaserState");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!phaseConfig.isEnabled(this)) {
            return this.outputIfNotEnabled(phaseConfig, phaserState, context, input);
        }
        boolean bl = phaserState.getAlreadyDone().containsAll((Collection)this.prerequisite);
        if (_Assertions.ENABLED && !bl) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean $i$a$-assert-NamedCompilerPhase$invoke$22 = false;
            Iterable iterable = SetsKt.minus(this.prerequisite, (Iterable)phaserState.getAlreadyDone());
            StringBuilder stringBuilder = new StringBuilder().append("Lowering ").append(this.name).append(": phases ");
            boolean $i$f$map = false;
            void var10_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NamedCompilerPhase namedCompilerPhase = (NamedCompilerPhase)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.name);
            }
            String $i$a$-assert-NamedCompilerPhase$invoke$22 = stringBuilder.append((List)destination$iv$iv).append(" are required, but not satisfied").toString();
            throw new AssertionError((Object)$i$a$-assert-NamedCompilerPhase$invoke$22);
        }
        context.setInVerbosePhase(phaseConfig.isVerbose(this));
        this.runBefore(phaseConfig, phaserState, context, input);
        if (phaseConfig.getNeedProfiling()) {
            Output2 = this.runAndProfile(phaseConfig, phaserState, context, input);
        } else {
            void $this$downlevel$iv;
            PhaserState $i$a$-assert-NamedCompilerPhase$invoke$22 = phaserState;
            int nlevels$iv = this.nlevels;
            boolean $i$f$downlevel = false;
            $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() + nlevels$iv);
            boolean bl3 = false;
            Output result$iv = this.phaseBody(context, input);
            $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() - nlevels$iv);
            Output2 = result$iv;
        }
        Output output = Output2;
        this.runAfter(phaseConfig, phaserState, context, input, output);
        context.setInVerbosePhase(false);
        phaserState.getAlreadyDone().add(this);
        int n2 = phaserState.getPhaseCount();
        phaserState.setPhaseCount(n2 + 1);
        return output;
    }

    public abstract Output phaseBody(@NotNull Context var1, Input var2);

    public abstract Output outputIfNotEnabled(@NotNull PhaseConfig var1, @NotNull PhaserState var2, @NotNull Context var3, Input var4);

    private final void runBefore(PhaseConfig phaseConfig, PhaserState phaserState, Context context, Input input) {
        ActionState state = new ActionState(phaseConfig, this, phaserState.getPhaseCount(), BeforeOrAfter.BEFORE);
        for (Function3<ActionState, Input, Context, Unit> function3 : this.preactions) {
            function3.invoke(state, input, context);
        }
        if (phaseConfig.getCheckConditions()) {
            for (Function1 function1 : this.preconditions) {
                function1.invoke(input);
            }
        }
    }

    private final void runAfter(PhaseConfig phaseConfig, PhaserState phaserState, Context context, Input input, Output output) {
        ActionState state = new ActionState(phaseConfig, this, phaserState.getPhaseCount(), BeforeOrAfter.AFTER);
        for (Function3<ActionState, Pair<Input, Output>, Context, Unit> function3 : this.postactions) {
            function3.invoke(state, TuplesKt.to(input, output), context);
        }
        if (phaseConfig.getCheckConditions()) {
            for (Function1 function1 : this.postconditions) {
                function1.invoke(output);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Output runAndProfile(PhaseConfig phaseConfig, PhaserState phaserState, Context context, Input source) {
        void $this$downlevel$iv;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        PhaserState phaserState2 = phaserState;
        int nlevels$iv = this.nlevels;
        boolean $i$f$downlevel = false;
        $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() + nlevels$iv);
        Ref.ObjectRef objectRef = result2;
        boolean bl2 = false;
        Output result$iv = this.phaseBody(context, source);
        $this$downlevel$iv.setDepth($this$downlevel$iv.getDepth() - nlevels$iv);
        objectRef.element = result$iv;
        long msec = System.currentTimeMillis() - start$iv;
        System.out.println((Object)(StringsKt.repeat("\t", phaserState.getDepth()) + this.name + ": " + msec + " msec"));
        return (Output)result2.element;
    }

    @Override
    @NotNull
    public List<Pair<Integer, NamedCompilerPhase<Context, ?, ?>>> getNamedSubphases(int startDepth) {
        return CollectionsKt.listOf(TuplesKt.to(startDepth, this));
    }

    @NotNull
    public String toString() {
        return "Compiler Phase @" + this.name;
    }
}

