/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u0000 -2\u00020\u0001:\u0001-BI\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u001a\b\u0002\u0010\t\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\u0004\b\r\u0010\u000eJ#\u0010\u0011\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u001f\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\"\u001a\u00020!H\u0017\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b$\u0010%R\u001a\u0010\u0003\u001a\u00020\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010(R\u001a\u0010\u0005\u001a\u00020\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010)\u001a\u0004\b*\u0010+R\"\u0010\t\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0002\b\u00030\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010,R \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010,"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "languageVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "apiVersion", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "analysisFlags", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "specificFeatures", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersion;Lorg/jetbrains/kotlin/config/ApiVersion;Ljava/util/Map;Ljava/util/Map;)V", "T", "flag", "getFlag", "(Lorg/jetbrains/kotlin/config/AnalysisFlag;)Ljava/lang/Object;", "feature", "getFeatureSupport", "(Lorg/jetbrains/kotlin/config/LanguageFeature;)Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "", "getManuallyEnabledLanguageFeatures", "()Ljava/util/List;", "getManuallyDisabledLanguageFeatures", "state", "", "isEnabledOnlyByFlag", "(Lorg/jetbrains/kotlin/config/LanguageFeature;Lorg/jetbrains/kotlin/config/LanguageFeature$State;)Z", "isDisabledOnlyByFlag", "isEnabledByDefault", "(Lorg/jetbrains/kotlin/config/LanguageFeature;)Z", "", "toString", "()Ljava/lang/String;", "isPreRelease", "()Z", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "Ljava/util/Map;", "Companion"})
public final class LanguageVersionSettingsImpl
implements LanguageVersionSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguageVersion languageVersion;
    @NotNull
    private final ApiVersion apiVersion;
    @NotNull
    private final Map<AnalysisFlag<?>, ?> analysisFlags;
    @NotNull
    private final Map<LanguageFeature, LanguageFeature.State> specificFeatures;
    @NotNull
    public static final LanguageVersionSettingsImpl DEFAULT = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST_STABLE, null, null, 12, null);

    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion, @NotNull Map<AnalysisFlag<?>, ? extends Object> analysisFlags, @NotNull Map<LanguageFeature, ? extends LanguageFeature.State> specificFeatures) {
        Intrinsics.checkNotNullParameter(languageVersion, "languageVersion");
        Intrinsics.checkNotNullParameter(apiVersion, "apiVersion");
        Intrinsics.checkNotNullParameter(analysisFlags, "analysisFlags");
        Intrinsics.checkNotNullParameter(specificFeatures, "specificFeatures");
        this.languageVersion = languageVersion;
        this.apiVersion = apiVersion;
        Map<AnalysisFlag<?>, ? extends Object> map2 = Collections.unmodifiableMap(analysisFlags);
        Intrinsics.checkNotNullExpressionValue(map2, "unmodifiableMap(...)");
        this.analysisFlags = map2;
        Map<LanguageFeature, ? extends LanguageFeature.State> map3 = Collections.unmodifiableMap(specificFeatures);
        Intrinsics.checkNotNullExpressionValue(map3, "unmodifiableMap(...)");
        this.specificFeatures = map3;
    }

    public /* synthetic */ LanguageVersionSettingsImpl(LanguageVersion languageVersion, ApiVersion apiVersion, Map map2, Map map3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n2 & 8) != 0) {
            map3 = MapsKt.emptyMap();
        }
        this(languageVersion, apiVersion, map2, map3);
    }

    @Override
    @NotNull
    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    @NotNull
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public <T> T getFlag(@NotNull AnalysisFlag<? extends T> flag) {
        Intrinsics.checkNotNullParameter(flag, "flag");
        Object object = this.analysisFlags.get(flag);
        if (object == null) {
            object = flag.getDefaultValue();
        }
        return (T)object;
    }

    @Override
    @NotNull
    public LanguageFeature.State getFeatureSupport(@NotNull LanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        LanguageFeature.State state = this.specificFeatures.get((Object)feature);
        if (state != null) {
            LanguageFeature.State it = state;
            boolean bl = false;
            return it;
        }
        if (this.isEnabledByDefault(feature)) {
            return feature.isEnabledWithWarning$util() ? LanguageFeature.State.ENABLED_WITH_WARNING : LanguageFeature.State.ENABLED;
        }
        return LanguageFeature.State.DISABLED;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LanguageFeature> getManuallyEnabledLanguageFeatures() {
        void $this$filterTo$iv$iv;
        Map<LanguageFeature, LanguageFeature.State> $this$filter$iv = this.specificFeatures;
        boolean $i$f$filter = false;
        Map<LanguageFeature, LanguageFeature.State> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!this.isEnabledOnlyByFlag((LanguageFeature)((Object)it.getKey()), (LanguageFeature.State)it.getValue())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList(destination$iv$iv.keySet());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LanguageFeature> getManuallyDisabledLanguageFeatures() {
        void $this$filterTo$iv$iv;
        Map<LanguageFeature, LanguageFeature.State> $this$filter$iv = this.specificFeatures;
        boolean $i$f$filter = false;
        Map<LanguageFeature, LanguageFeature.State> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!this.isDisabledOnlyByFlag((LanguageFeature)((Object)it.getKey()), (LanguageFeature.State)it.getValue())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList(destination$iv$iv.keySet());
    }

    private final boolean isEnabledOnlyByFlag(LanguageFeature feature, LanguageFeature.State state) {
        return !this.isEnabledByDefault(feature) && (state == LanguageFeature.State.ENABLED || state == LanguageFeature.State.ENABLED_WITH_WARNING);
    }

    private final boolean isDisabledOnlyByFlag(LanguageFeature feature, LanguageFeature.State state) {
        return this.isEnabledByDefault(feature) && state == LanguageFeature.State.DISABLED;
    }

    private final boolean isEnabledByDefault(LanguageFeature feature) {
        return feature.getSinceVersion() != null && this.getLanguageVersion().compareTo((Enum)feature.getSinceVersion()) >= 0 && this.getApiVersion().compareTo(feature.getSinceApiVersion()) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        Map.Entry entry;
        void $this$forEach$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u247.append("Language = " + this.getLanguageVersion() + ", API = " + this.getApiVersion());
        Iterable $this$sortedBy$iv = this.specificFeatures.entrySet();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                Map.Entry entry = (Map.Entry)a2;
                boolean bl = false;
                LanguageFeature feature = (LanguageFeature)((Object)entry.getKey());
                entry = (Map.Entry)b2;
                Comparable comparable = Integer.valueOf(feature.ordinal());
                bl = false;
                feature = (LanguageFeature)((Object)entry.getKey());
                return ComparisonsKt.compareValues(comparable, feature.ordinal());
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            char c2;
            entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            LanguageFeature feature = (LanguageFeature)((Object)entry.getKey());
            LanguageFeature.State state = (LanguageFeature.State)entry.getValue();
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    c2 = '+';
                    break;
                }
                case 2: {
                    c2 = '~';
                    break;
                }
                case 3: {
                    c2 = '-';
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            char c3 = c2;
            $this$toString_u24lambda_u247.append("" + ' ' + c3 + (Object)((Object)feature));
        }
        $this$sortedBy$iv = this.analysisFlags.entrySet();
        $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                Map.Entry entry = (Map.Entry)a2;
                boolean bl = false;
                AnalysisFlag flag = (AnalysisFlag)entry.getKey();
                entry = (Map.Entry)b2;
                Comparable comparable = (Comparable)((Object)flag.toString());
                bl = false;
                flag = (AnalysisFlag)entry.getKey();
                return ComparisonsKt.compareValues(comparable, (Comparable)((Object)flag.toString()));
            }
        });
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            entry = (Map.Entry)element$iv;
            boolean bl3 = false;
            AnalysisFlag flag = (AnalysisFlag)entry.getKey();
            Object value2 = entry.getValue();
            $this$toString_u24lambda_u247.append("" + ' ' + flag + ':' + value2);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPreRelease() {
        boolean bl;
        if (LanguageVersionSettingsKt.isPreRelease(this.getLanguageVersion())) return true;
        Map<LanguageFeature, LanguageFeature.State> $this$any$iv = this.specificFeatures;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<LanguageFeature, LanguageFeature.State>> iterator2 = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry<LanguageFeature, LanguageFeature.State> element$iv;
            if (!iterator2.hasNext()) return false;
            Map.Entry<LanguageFeature, LanguageFeature.State> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            LanguageFeature feature = entry.getKey();
            LanguageFeature.State state = entry.getValue();
            if (state == LanguageFeature.State.ENABLED && LanguageVersionSettingsKt.forcesPreReleaseBinariesIfEnabled(feature)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion, @NotNull Map<AnalysisFlag<?>, ? extends Object> analysisFlags) {
        Intrinsics.checkNotNullParameter(languageVersion, "languageVersion");
        Intrinsics.checkNotNullParameter(apiVersion, "apiVersion");
        Intrinsics.checkNotNullParameter(analysisFlags, "analysisFlags");
        this(languageVersion, apiVersion, analysisFlags, null, 8, null);
    }

    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion) {
        Intrinsics.checkNotNullParameter(languageVersion, "languageVersion");
        Intrinsics.checkNotNullParameter(apiVersion, "apiVersion");
        this(languageVersion, apiVersion, null, null, 12, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "DEFAULT", "Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageFeature.State.values().length];
            try {
                nArray[LanguageFeature.State.ENABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageFeature.State.ENABLED_WITH_WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageFeature.State.DISABLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

