/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compiler.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a%\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0019\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u000b\u0010\n\u001a'\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"", "pluginId", "", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "options", "cliPluginUsageString", "(Ljava/lang/String;Ljava/util/Collection;)Ljava/lang/String;", "argumentValue", "Lorg/jetbrains/kotlin/compiler/plugin/CliOptionValue;", "parseLegacyPluginOption", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/compiler/plugin/CliOptionValue;", "parseModernPluginOption", "key", "value", "getPluginOptionString", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;"})
public final class CliOptionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cliPluginUsageString(@NotNull String pluginId, @NotNull Collection<? extends AbstractCliOption> options) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Intrinsics.checkNotNullParameter(options, "options");
        int LEFT_INDENT = 2;
        int MAX_OPTION_WIDTH = 26;
        Iterable $this$map$iv = options;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2;
            String string3;
            String[] stringArray;
            int n2;
            String[] stringArray2;
            void it;
            AbstractCliOption abstractCliOption = (AbstractCliOption)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name = it.getOptionName() + ' ' + it.getValueDescription();
            String margin = name.length() > MAX_OPTION_WIDTH ? '\n' + StringsKt.repeat(" ", MAX_OPTION_WIDTH + LEFT_INDENT + 1) : StringsKt.repeat(" ", 1 + MAX_OPTION_WIDTH - name.length());
            String[] stringArray3 = stringArray2 = new String[2];
            int n3 = 0;
            boolean condition$iv = it.getRequired();
            boolean $i$f$runIf = false;
            if (condition$iv) {
                n2 = n3;
                stringArray = stringArray3;
                boolean bl2 = false;
                string3 = "required";
                stringArray3 = stringArray;
                n3 = n2;
                string2 = string3;
            } else {
                string2 = null;
            }
            stringArray3[n3] = string2;
            String[] stringArray4 = stringArray2;
            int n4 = 1;
            condition$iv = it.getAllowMultipleOccurrences();
            $i$f$runIf = false;
            if (condition$iv) {
                n2 = n4;
                stringArray = stringArray4;
                boolean bl3 = false;
                string3 = "multiple";
                stringArray4 = stringArray;
                n4 = n2;
                string = string3;
            } else {
                string = null;
            }
            stringArray4[n4] = string;
            List<String> modifiers = CollectionsKt.listOfNotNull(stringArray2);
            String modifiersEnclosed = modifiers.isEmpty() ? "" : " (" + CollectionsKt.joinToString$default(modifiers, null, null, null, 0, null, null, 63, null) + ')';
            collection.add(StringsKt.repeat(" ", LEFT_INDENT) + name + margin + it.getDescription() + modifiersEnclosed);
        }
        List renderedOptions = (List)destination$iv$iv;
        return "Plugin \"" + pluginId + "\" usage:\n" + CollectionsKt.joinToString$default(renderedOptions, "\n", null, "\n", 0, null, null, 58, null);
    }

    @Nullable
    public static final CliOptionValue parseLegacyPluginOption(@NotNull String argumentValue) {
        Intrinsics.checkNotNullParameter(argumentValue, "argumentValue");
        Pattern pattern = Pattern.compile("^plugin:([^:]*):([^=]*)=(.*)$");
        Matcher matcher = pattern.matcher(argumentValue);
        if (matcher.matches()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            String string2 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            String string3 = matcher.group(3);
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            return new CliOptionValue(string, string2, string3);
        }
        return null;
    }

    @Nullable
    public static final CliOptionValue parseModernPluginOption(@NotNull String argumentValue) {
        Intrinsics.checkNotNullParameter(argumentValue, "argumentValue");
        Pattern pattern = Pattern.compile("^([^=]*)=(.*)$");
        Matcher matcher = pattern.matcher(argumentValue);
        if (matcher.matches()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            String string2 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            return new CliOptionValue("<NO_ID>", string, string2);
        }
        return null;
    }

    @NotNull
    public static final String getPluginOptionString(@NotNull String pluginId, @NotNull String key, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value2, "value");
        return "plugin:" + pluginId + ':' + key + '=' + value2;
    }
}

