/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.signature;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.load.kotlin.JvmTypeFactory;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

public final class AsmTypeFactory
implements JvmTypeFactory<Type> {
    @NotNull
    public static final AsmTypeFactory INSTANCE = new AsmTypeFactory();

    private AsmTypeFactory() {
    }

    @Override
    @NotNull
    public Type boxType(@NotNull Type possiblyPrimitiveType) {
        Intrinsics.checkNotNullParameter(possiblyPrimitiveType, "possiblyPrimitiveType");
        Type type2 = AsmUtil.boxType(possiblyPrimitiveType);
        Intrinsics.checkNotNullExpressionValue(type2, "boxType(...)");
        return type2;
    }

    @Override
    @NotNull
    public Type createFromString(@NotNull String representation) {
        Intrinsics.checkNotNullParameter(representation, "representation");
        Type type2 = Type.getType(representation);
        Intrinsics.checkNotNullExpressionValue(type2, "getType(...)");
        return type2;
    }

    @Override
    @NotNull
    public Type createPrimitiveType(@NotNull PrimitiveType primitiveType) {
        Intrinsics.checkNotNullParameter((Object)primitiveType, "primitiveType");
        Type type2 = AsmTypes.valueTypeForPrimitive(primitiveType);
        Intrinsics.checkNotNullExpressionValue(type2, "valueTypeForPrimitive(...)");
        return type2;
    }

    @Override
    @NotNull
    public Type createObjectType(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        Type type2 = Type.getObjectType(internalName);
        Intrinsics.checkNotNullExpressionValue(type2, "getObjectType(...)");
        return type2;
    }

    @Override
    @NotNull
    public String toString(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        String string = type2.getDescriptor();
        Intrinsics.checkNotNullExpressionValue(string, "getDescriptor(...)");
        return string;
    }

    @Override
    @NotNull
    public Type getJavaLangClassType() {
        Type type2 = AsmTypes.JAVA_CLASS_TYPE;
        Intrinsics.checkNotNullExpressionValue(type2, "JAVA_CLASS_TYPE");
        return type2;
    }
}

