/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;

public class JvmCodegenUtil {
    public static boolean isJvmInterface(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor2).getKind();
            return kind == ClassKind.INTERFACE || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isJvmInterface(KotlinType type2) {
        return JvmCodegenUtil.isJvmInterface(type2.getConstructor().getDeclarationDescriptor());
    }

    @NotNull
    public static String getModuleName(ModuleDescriptor module2) {
        Name stableName = module2.getStableName();
        if (stableName == null) {
            return JvmCodegenUtil.prepareModuleName(module2.getName());
        }
        return JvmCodegenUtil.prepareModuleName(stableName);
    }

    @NotNull
    public static String prepareModuleName(@NotNull Name name) {
        if (name == null) {
            JvmCodegenUtil.$$$reportNull$$$0(1);
        }
        String string = StringsKt.removeSurrounding(name.asString(), (CharSequence)"<", (CharSequence)">");
        if (string == null) {
            JvmCodegenUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/JvmCodegenUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/JvmCodegenUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareModuleName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingFileName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDispatchReceiverParameterForConstructorCall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareModuleName";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMappingFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

