/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CtSymClassVirtualFile
extends VirtualFile {
    @Nullable
    private final VirtualFile parent;
    @NotNull
    private final VirtualFile file;

    public CtSymClassVirtualFile(@Nullable VirtualFile parent2, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.parent = parent2;
        this.file = file;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.file.getFileSystem();
        Intrinsics.checkNotNullExpressionValue(virtualFileSystem, "getFileSystem(...)");
        return virtualFileSystem;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        return string;
    }

    @Override
    public boolean isWritable() {
        return this.file.isWritable();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.file.isValid();
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public VirtualFile[] getChildren() {
        return null;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@Nullable Object p0, long p1, long p2) {
        OutputStream outputStream = this.file.getOutputStream(p0, p1, p2);
        Intrinsics.checkNotNullExpressionValue(outputStream, "getOutputStream(...)");
        return outputStream;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = this.file.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "contentsToByteArray(...)");
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.file.getTimeStamp();
    }

    @Override
    public long getLength() {
        return this.file.getLength();
    }

    @Override
    public void refresh(boolean p0, boolean p1, @Nullable Runnable p2) {
        this.file.refresh(p0, p1, p2);
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = this.file.getInputStream();
        Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
        return inputStream;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(javaClassFileType, "INSTANCE");
        return javaClassFileType;
    }

    @Override
    public long getModificationStamp() {
        return this.file.getModificationStamp();
    }
}

