/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;

public final class CoreJrtVirtualFile
extends VirtualFile {
    @NotNull
    private final CoreJrtFileSystem virtualFileSystem;
    @NotNull
    private final String jdkHomePath;
    @NotNull
    private final Path path;
    @Nullable
    private final CoreJrtVirtualFile parent;
    @Nullable
    private String _name;
    @NotNull
    private final Lazy myChildren$delegate;

    public CoreJrtVirtualFile(@NotNull CoreJrtFileSystem virtualFileSystem, @NotNull String jdkHomePath, @NotNull Path path, @Nullable CoreJrtVirtualFile parent2) {
        Intrinsics.checkNotNullParameter(virtualFileSystem, "virtualFileSystem");
        Intrinsics.checkNotNullParameter(jdkHomePath, "jdkHomePath");
        Intrinsics.checkNotNullParameter(path, "path");
        this.virtualFileSystem = virtualFileSystem;
        this.jdkHomePath = jdkHomePath;
        this.path = path;
        this.parent = parent2;
        this.myChildren$delegate = LazyKt.lazy(() -> CoreJrtVirtualFile.myChildren_delegate$lambda$2(this));
    }

    private final BasicFileAttributes getAttributes() {
        BasicFileAttributes basicFileAttributes = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
        Intrinsics.checkNotNullExpressionValue(basicFileAttributes, "readAttributes(...)");
        return basicFileAttributes;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.virtualFileSystem;
    }

    @Override
    @NotNull
    public String getName() {
        String string;
        String string2 = this._name;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return it;
        }
        String it = string = ((Object)this.path.getFileName()).toString();
        boolean bl = false;
        this._name = it;
        return string;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = FileUtil.toSystemIndependentName(this.jdkHomePath + "!/" + this.path);
        Intrinsics.checkNotNullExpressionValue(string, "toSystemIndependentName(...)");
        return string;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        return this.parent;
    }

    private final VirtualFile[] getMyChildren() {
        Lazy lazy = this.myChildren$delegate;
        return (VirtualFile[])lazy.getValue();
    }

    @Override
    @NotNull
    public VirtualFile[] getChildren() {
        return this.getMyChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final VirtualFile[] computeChildren() {
        VirtualFile[] virtualFileArray;
        List p0;
        List list;
        try {
            list = Files.newDirectoryStream(this.path);
            Throwable throwable = null;
            try {
                p0 = list;
                boolean bl = false;
                p0 = CollectionsKt.toList(p0);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)((Object)list), throwable);
            }
            list = p0;
        }
        catch (IOException iOException) {
            list = CollectionsKt.emptyList();
        }
        List paths2 = list;
        if (paths2.isEmpty()) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue(VirtualFile.EMPTY_ARRAY, "EMPTY_ARRAY");
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = paths2;
            boolean $i$f$map = false;
            p0 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void path;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new CoreJrtVirtualFile(this.virtualFileSystem, this.jdkHomePath, (Path)path, this));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            virtualFileArray = thisCollection$iv.toArray(new CoreJrtVirtualFile[0]);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@NotNull Object requestor, long newModificationStamp, long newTimeStamp) {
        Intrinsics.checkNotNullParameter(requestor, "requestor");
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = Files.readAllBytes(this.path);
        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.getAttributes().lastModifiedTime().toMillis();
    }

    @Override
    public long getLength() {
        return this.getAttributes().size();
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
        InputStream inputStream2 = inputStream;
        int n2 = 8192;
        InputStream inputStream3 = VfsUtilCore.inputStreamSkippingBOM(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n2), this);
        Intrinsics.checkNotNullExpressionValue(inputStream3, "inputStreamSkippingBOM(...)");
        return inputStream3;
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CoreJrtVirtualFile && Intrinsics.areEqual(this.path, ((CoreJrtVirtualFile)other).path) && Intrinsics.areEqual(this.getFileSystem(), ((CoreJrtVirtualFile)other).getFileSystem());
    }

    public int hashCode() {
        return ((Object)this.path).hashCode();
    }

    private static final VirtualFile[] myChildren_delegate$lambda$2(CoreJrtVirtualFile this$0) {
        return this$0.computeChildren();
    }
}

