/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentMap;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtVirtualFile;
import org.jetbrains.kotlin.cli.jvm.modules.JavaVersionUtilsKt;

public final class CoreJrtFileSystem
extends DeprecatedVirtualFileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<String, CoreJrtVirtualFile> roots;
    @NotNull
    private static final ConcurrentMap<String, FileSystem> globalJrtFsCache;

    public CoreJrtFileSystem() {
        ConcurrentMap<Object, CoreJrtVirtualFile> concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> CoreJrtFileSystem.roots$lambda$1(arg_0 -> CoreJrtFileSystem.roots$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createMap(...)");
        this.roots = concurrentMap;
    }

    @Override
    @NotNull
    public String getProtocol() {
        return "jrt";
    }

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Pair<String, String> pair = Companion.splitPath(path);
        String jdkHomePath = pair.component1();
        String pathInImage = pair.component2();
        CoreJrtVirtualFile coreJrtVirtualFile = (CoreJrtVirtualFile)this.roots.get(jdkHomePath);
        if (coreJrtVirtualFile == null) {
            return null;
        }
        CoreJrtVirtualFile root = coreJrtVirtualFile;
        if (((CharSequence)pathInImage).length() == 0) {
            return root;
        }
        return root.findFileByRelativePath(pathInImage);
    }

    @Override
    public void refresh(boolean asynchronous) {
    }

    @Override
    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.findFileByPath(path);
    }

    private static final CoreJrtVirtualFile roots$lambda$0(CoreJrtFileSystem this$0, String jdkHomePath) {
        FileSystem fileSystem = (FileSystem)globalJrtFsCache.get(jdkHomePath);
        if (fileSystem == null) {
            return null;
        }
        FileSystem fileSystem2 = fileSystem;
        Intrinsics.checkNotNull(jdkHomePath);
        Path path = fileSystem2.getPath("", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "getPath(...)");
        return new CoreJrtVirtualFile(this$0, jdkHomePath, path, null);
    }

    private static final CoreJrtVirtualFile roots$lambda$1(Function1 $tmp0, Object p0) {
        return (CoreJrtVirtualFile)$tmp0.invoke(p0);
    }

    private static final FileSystem globalJrtFsCache$lambda$2(String jdkHomePath) {
        FileSystem fileSystem;
        File jdkHome = new File(jdkHomePath);
        File file = CoreJrtFileSystem.Companion.loadJrtFsJar(jdkHome);
        if (file == null) {
            return null;
        }
        File jrtFsJar = file;
        URI rootUri = URI.create("jrt:/");
        if (JavaVersionUtilsKt.isAtLeastJava9()) {
            fileSystem = FileSystems.newFileSystem(rootUri, MapsKt.mapOf(TuplesKt.to("java.home", jdkHome.getAbsolutePath())));
        } else {
            URL[] uRLArray = new URL[]{jrtFsJar.toURI().toURL()};
            URLClassLoader classLoader = new URLClassLoader(uRLArray, null);
            fileSystem = FileSystems.newFileSystem(rootUri, MapsKt.emptyMap(), (ClassLoader)classLoader);
        }
        return fileSystem;
    }

    private static final FileSystem globalJrtFsCache$lambda$3(Function1 $tmp0, Object p0) {
        return (FileSystem)$tmp0.invoke(p0);
    }

    static {
        ConcurrentMap<Object, FileSystem> concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> CoreJrtFileSystem.globalJrtFsCache$lambda$3(CoreJrtFileSystem::globalJrtFsCache$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createMap(...)");
        globalJrtFsCache = concurrentMap;
    }

    public static final class Companion {
        private Companion() {
        }

        private final File loadJrtFsJar(File jdkHome) {
            File file;
            File p0 = file = new File(jdkHome, "lib/jrt-fs.jar");
            boolean bl = false;
            return p0.exists() ? file : null;
        }

        @NotNull
        public final Pair<String, String> splitPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter(path, "path");
            int separator = StringsKt.indexOf$default((CharSequence)path, "!/", 0, false, 6, null);
            if (separator < 0) {
                throw new IllegalArgumentException("Path in CoreJrtFileSystem must contain a separator: " + path);
            }
            String string = path.substring(0, separator);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String localPath = string;
            String string2 = path.substring(separator + 2);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String pathInJar = string2;
            return new Pair<String, String>(localPath, pathInJar);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

