/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.index;

import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public final class SingleJavaFileRootsIndex {
    @NotNull
    private final List<JavaRoot> roots;
    @NotNull
    private final ArrayList<List<ClassId>> classIdsInRoots;

    public SingleJavaFileRootsIndex(@NotNull List<JavaRoot> roots) {
        Intrinsics.checkNotNullParameter(roots, "roots");
        this.roots = roots;
        Iterator<JavaRoot> iterator2 = this.roots.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            VirtualFile file = iterator2.next().component1();
            boolean bl2 = bl = !file.isDirectory();
            if (!_Assertions.ENABLED || bl) continue;
            boolean bl3 = false;
            String string = "Should not be a directory: " + file;
            throw new AssertionError((Object)string);
        }
        this.classIdsInRoots = new ArrayList(this.roots.size());
    }

    @Nullable
    public final VirtualFile findJavaSourceClass(@NotNull ClassId classId) {
        VirtualFile virtualFile;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(classId, "classId");
            Iterable iterable = CollectionsKt.getIndices((Collection)this.roots);
            for (Object t2 : iterable) {
                int index2 = ((Number)t2).intValue();
                boolean bl = false;
                if (!this.getClassIdsForRootAt(index2).contains(classId)) continue;
                v0 = t2;
                break block3;
            }
            v0 = null;
        }
        Integer n2 = v0;
        if (n2 != null) {
            int index3 = ((Number)n2).intValue();
            boolean bl = false;
            virtualFile = this.roots.get(index3).getFile();
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    public final boolean hasPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        int n2 = ((Collection)this.roots).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = this.getClassIdsForRootAt(i2);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ClassId it = (ClassId)element$iv;
                        boolean bl2 = false;
                        if (!it.getPackageFqName().startsWith(packageFqName)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClassId> findJavaSourceClasses(@NotNull FqName packageFqName) {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Iterable $this$flatMap$iv = CollectionsKt.getIndices((Collection)this.roots);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv$iv;
            int p0 = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Iterable list$iv$iv = this.getClassIdsForRootAt(p0);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClassId root = (ClassId)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(root.getPackageFqName(), packageFqName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<ClassId> getClassIdsForRootAt(int index2) {
        int i2 = this.classIdsInRoots.size();
        if (i2 <= index2) {
            while (true) {
                this.classIdsInRoots.add(new JavaSourceClassIdReader(this.roots.get(i2).getFile()).readClassIds());
                if (i2 == index2) break;
                ++i2;
            }
        }
        List<ClassId> list = this.classIdsInRoots.get(index2);
        Intrinsics.checkNotNullExpressionValue(list, "get(...)");
        return list;
    }

    private static final class JavaSourceClassIdReader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JavaLexer lexer;
        private int braceBalance;
        private int parenthesisBalance;
        @NotNull
        private static final Set<IElementType> CLASS_KEYWORDS;

        /*
         * WARNING - void declaration
         */
        public JavaSourceClassIdReader(@NotNull VirtualFile file) {
            void $this$lexer_u24lambda_u240;
            JavaLexer javaLexer;
            Intrinsics.checkNotNullParameter(file, "file");
            JavaLexer javaLexer2 = javaLexer = new JavaLexer(LanguageLevel.HIGHEST);
            JavaSourceClassIdReader javaSourceClassIdReader = this;
            boolean bl = false;
            byte[] byArray = file.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "contentsToByteArray(...)");
            byte[] byArray2 = byArray;
            $this$lexer_u24lambda_u240.start(new String(byArray2, Charsets.UTF_8));
            javaSourceClassIdReader.lexer = javaLexer;
        }

        private final boolean at(IElementType type2) {
            return Intrinsics.areEqual(this.lexer.getTokenType(), type2);
        }

        private final boolean end() {
            return this.lexer.getTokenType() == null;
        }

        private final void advance() {
            IElementType iElementType = ElementType.LBRACE;
            Intrinsics.checkNotNullExpressionValue(iElementType, "LBRACE");
            if (this.at(iElementType)) {
                int n2 = this.braceBalance;
                this.braceBalance = n2 + 1;
            } else {
                IElementType iElementType2 = ElementType.RBRACE;
                Intrinsics.checkNotNullExpressionValue(iElementType2, "RBRACE");
                if (this.at(iElementType2)) {
                    int n3 = this.braceBalance;
                    this.braceBalance = n3 + -1;
                } else {
                    IElementType iElementType3 = ElementType.LPARENTH;
                    Intrinsics.checkNotNullExpressionValue(iElementType3, "LPARENTH");
                    if (this.at(iElementType3)) {
                        int n4 = this.parenthesisBalance;
                        this.parenthesisBalance = n4 + 1;
                    } else {
                        IElementType iElementType4 = ElementType.RPARENTH;
                        Intrinsics.checkNotNullExpressionValue(iElementType4, "RPARENTH");
                        if (this.at(iElementType4)) {
                            int n5 = this.parenthesisBalance;
                            this.parenthesisBalance = n5 + -1;
                        }
                    }
                }
            }
            this.lexer.advance();
        }

        private final String tokenText() {
            String string = this.lexer.getTokenText();
            Intrinsics.checkNotNullExpressionValue(string, "getTokenText(...)");
            return string;
        }

        private final boolean atClass() {
            return this.braceBalance == 0 && this.parenthesisBalance == 0 && (CLASS_KEYWORDS.contains(this.lexer.getTokenType()) || this.atRecord());
        }

        private final boolean atRecord() {
            IElementType iElementType = ElementType.IDENTIFIER;
            Intrinsics.checkNotNullExpressionValue(iElementType, "IDENTIFIER");
            return this.at(iElementType) && Intrinsics.areEqual(this.tokenText(), "record");
        }

        @NotNull
        public final List<ClassId> readClassIds() {
            FqName packageFqName;
            block8: {
                packageFqName = FqName.ROOT;
                while (!this.end()) {
                    IElementType iElementType = ElementType.PACKAGE_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue(iElementType, "PACKAGE_KEYWORD");
                    if (this.at(iElementType) || this.atClass()) break;
                    this.advance();
                }
                IElementType iElementType = ElementType.PACKAGE_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(iElementType, "PACKAGE_KEYWORD");
                if (!this.at(iElementType)) break block8;
                StringBuilder packageName = new StringBuilder();
                while (!this.end()) {
                    block10: {
                        block9: {
                            IElementType iElementType2 = ElementType.SEMICOLON;
                            Intrinsics.checkNotNullExpressionValue(iElementType2, "SEMICOLON");
                            if (this.at(iElementType2)) break;
                            IElementType iElementType3 = ElementType.IDENTIFIER;
                            Intrinsics.checkNotNullExpressionValue(iElementType3, "IDENTIFIER");
                            if (this.at(iElementType3)) break block9;
                            IElementType iElementType4 = ElementType.DOT;
                            Intrinsics.checkNotNullExpressionValue(iElementType4, "DOT");
                            if (!this.at(iElementType4)) break block10;
                        }
                        packageName.append(this.tokenText());
                    }
                    this.advance();
                }
                String string = packageName.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                packageFqName = new FqName(string);
            }
            ArrayList<ClassId> result2 = new ArrayList<ClassId>(1);
            while (true) {
                if (!this.end() && !this.atClass()) {
                    this.advance();
                    continue;
                }
                if (this.end()) break;
                this.advance();
                while (!this.end()) {
                    IElementType iElementType = ElementType.IDENTIFIER;
                    Intrinsics.checkNotNullExpressionValue(iElementType, "IDENTIFIER");
                    if (this.at(iElementType)) break;
                    this.advance();
                }
                if (this.end()) break;
                Name name = Name.identifier(this.tokenText());
                Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
                result2.add(new ClassId(packageFqName, name));
            }
            return result2;
        }

        static {
            IElementType[] iElementTypeArray = new IElementType[]{ElementType.CLASS_KEYWORD, ElementType.INTERFACE_KEYWORD, ElementType.ENUM_KEYWORD};
            CLASS_KEYWORDS = SetsKt.setOf(iElementTypeArray);
        }

        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

