/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.index;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndex;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndexImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

public final class JvmDependenciesDynamicCompoundIndex
implements JvmDependenciesIndex {
    private final boolean shouldOnlyFindFirstClass;
    @NotNull
    private final ArrayList<JvmDependenciesIndex> indices;
    @NotNull
    private final ReentrantReadWriteLock lock;

    public JvmDependenciesDynamicCompoundIndex(boolean shouldOnlyFindFirstClass) {
        this.shouldOnlyFindFirstClass = shouldOnlyFindFirstClass;
        this.indices = new ArrayList();
        this.lock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addIndex(@NotNull JvmDependenciesIndex index2) {
        Intrinsics.checkNotNullParameter(index2, "index");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.indices.add(index2);
        }
        finally {
            for (int i3 = 0; i3 < n2; ++i3) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final JvmDependenciesIndex addNewIndexForRoots(@NotNull Iterable<JavaRoot> roots) {
        JvmDependenciesIndexImpl jvmDependenciesIndexImpl;
        Intrinsics.checkNotNullParameter(roots, "roots");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            JvmDependenciesIndexImpl jvmDependenciesIndexImpl2;
            void $this$filterTo$iv$iv;
            boolean bl = false;
            HashSet<JavaRoot> alreadyIndexed = SequencesKt.toHashSet(this.getIndexedRoots());
            Iterable<JavaRoot> $this$filter$iv = roots;
            boolean $i$f$filter = false;
            Iterable<JavaRoot> iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JavaRoot root = (JavaRoot)element$iv$iv;
                boolean bl2 = false;
                if (!(!alreadyIndexed.contains(root))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List newRoots = (List)destination$iv$iv;
            if (newRoots.isEmpty()) {
                jvmDependenciesIndexImpl2 = null;
            } else {
                JvmDependenciesIndexImpl jvmDependenciesIndexImpl3 = new JvmDependenciesIndexImpl(newRoots, this.shouldOnlyFindFirstClass);
                JvmDependenciesIndex p0 = jvmDependenciesIndexImpl3;
                boolean bl3 = false;
                this.addIndex(p0);
                jvmDependenciesIndexImpl2 = jvmDependenciesIndexImpl3;
            }
            jvmDependenciesIndexImpl = jvmDependenciesIndexImpl2;
        }
        finally {
            readLock.unlock();
        }
        return jvmDependenciesIndexImpl;
    }

    @Override
    @NotNull
    public Sequence<JavaRoot> getIndexedRoots() {
        return SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)this.indices), JvmDependenciesDynamicCompoundIndex::_get_indexedRoots_$lambda$3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> Collection<T> findClasses(@NotNull ClassId classId, @NotNull Set<? extends JavaRoot.RootType> acceptedRootTypes, @NotNull Function2<? super VirtualFile, ? super JavaRoot.RootType, ? extends T> findClassGivenDirectory) {
        List list;
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(acceptedRootTypes, "acceptedRootTypes");
        Intrinsics.checkNotNullParameter(findClassGivenDirectory, "findClassGivenDirectory");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List list2;
            boolean bl = false;
            if (this.shouldOnlyFindFirstClass) {
                list2 = CollectionsKt.listOfNotNull(SequencesKt.firstOrNull(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)this.indices), arg_0 -> JvmDependenciesDynamicCompoundIndex.findClasses$lambda$6$lambda$4(classId, acceptedRootTypes, findClassGivenDirectory, arg_0))));
            } else {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = this.indices;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    JvmDependenciesIndex it = (JvmDependenciesIndex)element$iv$iv;
                    boolean bl2 = false;
                    Iterable list$iv$iv = it.findClasses(classId, acceptedRootTypes, findClassGivenDirectory);
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
            list = list2;
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void traverseDirectoriesInPackage(@NotNull FqName packageFqName, @NotNull Set<? extends JavaRoot.RootType> acceptedRootTypes, @NotNull Function2<? super VirtualFile, ? super JavaRoot.RootType, Boolean> continueSearch) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(acceptedRootTypes, "acceptedRootTypes");
        Intrinsics.checkNotNullParameter(continueSearch, "continueSearch");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = this.indices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JvmDependenciesIndex it = (JvmDependenciesIndex)element$iv;
                boolean bl2 = false;
                it.traverseDirectoriesInPackage(packageFqName, acceptedRootTypes, continueSearch);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    private static final Sequence _get_indexedRoots_$lambda$3(JvmDependenciesIndex it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getIndexedRoots();
    }

    private static final Object findClasses$lambda$6$lambda$4(ClassId $classId, Set $acceptedRootTypes, Function2 $findClassGivenDirectory, JvmDependenciesIndex it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return CollectionsKt.firstOrNull(it.findClasses($classId, $acceptedRootTypes, $findClassGivenDirectory));
    }
}

