/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.index;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;

public final class JavaRoot {
    @NotNull
    public static final RootTypes RootTypes = new RootTypes(null);
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final RootType type;
    @Nullable
    private final FqName prefixFqName;
    @NotNull
    private static final Set<RootType> OnlyBinary;
    @NotNull
    private static final Set<RootType> OnlySource;
    @NotNull
    private static final Set<RootType> SourceAndBinary;

    public JavaRoot(@NotNull VirtualFile file, @NotNull RootType type2, @Nullable FqName prefixFqName) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        this.file = file;
        this.type = type2;
        this.prefixFqName = prefixFqName;
    }

    public /* synthetic */ JavaRoot(VirtualFile virtualFile, RootType rootType, FqName fqName2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            fqName2 = null;
        }
        this(virtualFile, rootType, fqName2);
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final RootType getType() {
        return this.type;
    }

    @Nullable
    public final FqName getPrefixFqName() {
        return this.prefixFqName;
    }

    @NotNull
    public final VirtualFile component1() {
        return this.file;
    }

    @NotNull
    public final RootType component2() {
        return this.type;
    }

    @NotNull
    public String toString() {
        return "JavaRoot(file=" + this.file + ", type=" + (Object)((Object)this.type) + ", prefixFqName=" + this.prefixFqName + ')';
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = result2 * 31 + this.type.hashCode();
        result2 = result2 * 31 + (this.prefixFqName == null ? 0 : this.prefixFqName.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaRoot)) {
            return false;
        }
        JavaRoot javaRoot = (JavaRoot)other;
        if (!Intrinsics.areEqual(this.file, javaRoot.file)) {
            return false;
        }
        if (this.type != javaRoot.type) {
            return false;
        }
        return Intrinsics.areEqual(this.prefixFqName, javaRoot.prefixFqName);
    }

    static {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)RootType.BINARY, (Enum)RootType.BINARY_SIG);
        Intrinsics.checkNotNullExpressionValue(enumSet, "of(...)");
        OnlyBinary = enumSet;
        EnumSet<Enum> enumSet2 = EnumSet.of((Enum)RootType.SOURCE);
        Intrinsics.checkNotNullExpressionValue(enumSet2, "of(...)");
        OnlySource = enumSet2;
        EnumSet<Enum> enumSet3 = EnumSet.of((Enum)RootType.BINARY, (Enum)RootType.BINARY_SIG, (Enum)RootType.SOURCE);
        Intrinsics.checkNotNullExpressionValue(enumSet3, "of(...)");
        SourceAndBinary = enumSet3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "", "<init>", "(Ljava/lang/String;I)V", "SOURCE", "BINARY", "BINARY_SIG", "cli-base"})
    public static final class RootType
    extends Enum<RootType> {
        public static final /* enum */ RootType SOURCE = new RootType();
        public static final /* enum */ RootType BINARY = new RootType();
        public static final /* enum */ RootType BINARY_SIG = new RootType();
        private static final /* synthetic */ RootType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RootType[] values() {
            return (RootType[])$VALUES.clone();
        }

        public static RootType valueOf(String value2) {
            return Enum.valueOf(RootType.class, value2);
        }

        @NotNull
        public static EnumEntries<RootType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rootTypeArray = new RootType[]{RootType.SOURCE, RootType.BINARY, RootType.BINARY_SIG};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public static final class RootTypes {
        private RootTypes() {
        }

        @NotNull
        public final Set<RootType> getOnlyBinary() {
            return OnlyBinary;
        }

        @NotNull
        public final Set<RootType> getOnlySource() {
            return OnlySource;
        }

        @NotNull
        public final Set<RootType> getSourceAndBinary() {
            return SourceAndBinary;
        }

        public /* synthetic */ RootTypes(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

