/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.config;

import java.io.File;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRootBase;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRoot;

public final class JvmClasspathRoot
implements JvmClasspathRootBase,
JvmContentRoot {
    @NotNull
    private final File file;
    private final boolean isSdkRoot;

    public JvmClasspathRoot(@NotNull File file, boolean isSdkRoot) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.file = file;
        this.isSdkRoot = isSdkRoot;
    }

    @Override
    @NotNull
    public File getFile() {
        return this.file;
    }

    public JvmClasspathRoot(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        this(file, false);
    }

    @NotNull
    public String toString() {
        return "JvmClasspathRoot(file=" + this.file + ", isSdkRoot=" + this.isSdkRoot + ')';
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isSdkRoot);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JvmClasspathRoot)) {
            return false;
        }
        JvmClasspathRoot jvmClasspathRoot = (JvmClasspathRoot)other;
        if (!Intrinsics.areEqual(this.file, jvmClasspathRoot.file)) {
            return false;
        }
        return this.isSdkRoot == jvmClasspathRoot.isSdkRoot;
    }
}

