/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.config;

import java.io.File;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRoot;

public final class JavaSourceRoot
implements JvmContentRoot {
    @NotNull
    private final File file;
    @Nullable
    private final String packagePrefix;

    public JavaSourceRoot(@NotNull File file, @Nullable String packagePrefix) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.file = file;
        this.packagePrefix = packagePrefix;
    }

    @Override
    @NotNull
    public File getFile() {
        return this.file;
    }

    @Nullable
    public final String getPackagePrefix() {
        return this.packagePrefix;
    }

    @NotNull
    public String toString() {
        return "JavaSourceRoot(file=" + this.file + ", packagePrefix=" + this.packagePrefix + ')';
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = result2 * 31 + (this.packagePrefix == null ? 0 : this.packagePrefix.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaSourceRoot)) {
            return false;
        }
        JavaSourceRoot javaSourceRoot = (JavaSourceRoot)other;
        if (!Intrinsics.areEqual(this.file, javaSourceRoot.file)) {
            return false;
        }
        return Intrinsics.areEqual(this.packagePrefix, javaSourceRoot.packagePrefix);
    }
}

