/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.Inflater;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ByteArrayCharSequence;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.LargeDynamicMappedBuffer;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipEntryDescription;

public final class ZipImplementationKt {
    @NotNull
    public static final byte[] contentsToByteArray(@NotNull LargeDynamicMappedBuffer $this$contentsToByteArray, @NotNull ZipEntryDescription zipEntryDescription) {
        Intrinsics.checkNotNullParameter($this$contentsToByteArray, "<this>");
        Intrinsics.checkNotNullParameter(zipEntryDescription, "zipEntryDescription");
        return $this$contentsToByteArray.withMappedRangeFrom(zipEntryDescription.getOffsetInFile(), arg_0 -> ZipImplementationKt.contentsToByteArray$lambda$1(zipEntryDescription, arg_0));
    }

    @NotNull
    public static final List<ZipEntryDescription> parseCentralDirectory(@NotNull LargeDynamicMappedBuffer $this$parseCentralDirectory) {
        Intrinsics.checkNotNullParameter($this$parseCentralDirectory, "<this>");
        Pair<Long, Long> pair = ZipImplementationKt.parseCentralDirectoryRecordsNumberAndOffset($this$parseCentralDirectory);
        long entriesNumber = ((Number)pair.component1()).longValue();
        long offsetOfCentralDirectory = ((Number)pair.component2()).longValue();
        Ref.LongRef currentStart = new Ref.LongRef();
        currentStart.element = offsetOfCentralDirectory;
        List result2 = new ArrayList();
        for (long i2 = 0L; i2 < entriesNumber; ++i2) {
            $this$parseCentralDirectory.withMappedRangeFrom(currentStart.element, arg_0 -> ZipImplementationKt.parseCentralDirectory$lambda$5(currentStart, result2, i2, arg_0));
        }
        return result2;
    }

    private static final Pair<Long, Long> parseCentralDirectoryRecordsNumberAndOffset(LargeDynamicMappedBuffer $this$parseCentralDirectoryRecordsNumberAndOffset) {
        return $this$parseCentralDirectoryRecordsNumberAndOffset.withMappedTail(ZipImplementationKt::parseCentralDirectoryRecordsNumberAndOffset$lambda$6);
    }

    private static final Pair<Long, Long> parseZip64CentralDirectoryRecordsNumberAndOffset(LargeDynamicMappedBuffer.Mapping $this$parseZip64CentralDirectoryRecordsNumberAndOffset) {
        int endOfCentralDirectoryOffset;
        for (endOfCentralDirectoryOffset = $this$parseZip64CentralDirectoryRecordsNumberAndOffset.endOffset() - 56; endOfCentralDirectoryOffset >= 0 && $this$parseZip64CentralDirectoryRecordsNumberAndOffset.getInt(endOfCentralDirectoryOffset) != 101075792; --endOfCentralDirectoryOffset) {
        }
        long entriesNumber = $this$parseZip64CentralDirectoryRecordsNumberAndOffset.getLong(endOfCentralDirectoryOffset + 32);
        long offsetOfCentralDirectory = $this$parseZip64CentralDirectoryRecordsNumberAndOffset.getLong(endOfCentralDirectoryOffset + 48);
        return new Pair<Long, Long>(entriesNumber, offsetOfCentralDirectory);
    }

    private static final int getUnsignedShort(LargeDynamicMappedBuffer.Mapping $this$getUnsignedShort, int offset) {
        return Short.toUnsignedInt($this$getUnsignedShort.getShort(offset));
    }

    private static final byte[] contentsToByteArray$lambda$1(ZipEntryDescription $zipEntryDescription, LargeDynamicMappedBuffer.Mapping $this$withMappedRangeFrom) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$withMappedRangeFrom, "$this$withMappedRangeFrom");
        int extraSize = ZipImplementationKt.getUnsignedShort($this$withMappedRangeFrom, 28);
        int startPos = 30 + $zipEntryDescription.getFileNameSize() + extraSize;
        if (!($zipEntryDescription.getCompressedSize() - (long)startPos < Integer.MAX_VALUE && $zipEntryDescription.getUncompressedSize() <= Integer.MAX_VALUE)) {
            boolean bl = false;
            String string = "Reading files bigger than Int.MAX_VALUE - " + startPos + " is not supported yet";
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[$zipEntryDescription.getCompressionKind().ordinal()]) {
            case 1: {
                Inflater inflater = new Inflater(true);
                inflater.setInput($this$withMappedRangeFrom.getBytes(startPos, (int)$zipEntryDescription.getCompressedSize()));
                byte[] result2 = new byte[(int)$zipEntryDescription.getUncompressedSize()];
                inflater.inflate(result2);
                inflater.end();
                byArray = result2;
                break;
            }
            case 2: {
                byArray = $this$withMappedRangeFrom.getBytes(startPos, (int)$zipEntryDescription.getCompressedSize());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byArray;
    }

    private static final long parseCentralDirectory$lambda$5$toLongOrNextZip64ExtrField(int $this$parseCentralDirectory_u24lambda_u245_u24toLongOrNextZip64ExtrField, short extraFieldsSize, Ref.IntRef extraFieldNo, LargeDynamicMappedBuffer.Mapping $this_withMappedRangeFrom, int extraFieldOffset) {
        long l2;
        if ($this$parseCentralDirectory_u24lambda_u245_u24toLongOrNextZip64ExtrField != -1) {
            l2 = (long)UInt.constructor-impl($this$parseCentralDirectory_u24lambda_u245_u24toLongOrNextZip64ExtrField) & 0xFFFFFFFFL;
        } else {
            long l3;
            if (!(extraFieldsSize >= (extraFieldNo.element + 1) * 8)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long it = l3 = $this_withMappedRangeFrom.getLong(extraFieldOffset + 4 + extraFieldNo.element * 8);
            boolean bl = false;
            int n2 = extraFieldNo.element;
            extraFieldNo.element = n2 + 1;
            l2 = l3;
        }
        return l2;
    }

    private static final Unit parseCentralDirectory$lambda$5(Ref.LongRef $currentStart, List $result, long $i, LargeDynamicMappedBuffer.Mapping $this$withMappedRangeFrom) {
        ZipEntryDescription.CompressionKind compressionKind;
        boolean bl;
        byte[] bytesForName;
        long offsetOfFileData;
        long uncompressedSize;
        long compressedSize;
        int fileCommentLength;
        int extraLength;
        int fileNameLength;
        short compressionMethod;
        block6: {
            Intrinsics.checkNotNullParameter($this$withMappedRangeFrom, "$this$withMappedRangeFrom");
            int headerConst = $this$withMappedRangeFrom.getInt(0);
            if (!(headerConst == 33639248)) {
                boolean $i$a$-require-ZipImplementationKt$parseCentralDirectory$1$22 = false;
                String $i$a$-require-ZipImplementationKt$parseCentralDirectory$1$22 = $i + ": " + headerConst;
                throw new IllegalArgumentException($i$a$-require-ZipImplementationKt$parseCentralDirectory$1$22.toString());
            }
            compressionMethod = $this$withMappedRangeFrom.getShort(10);
            fileNameLength = ZipImplementationKt.getUnsignedShort($this$withMappedRangeFrom, 28);
            extraLength = ZipImplementationKt.getUnsignedShort($this$withMappedRangeFrom, 30);
            int extraFieldOffset = 46 + fileNameLength;
            int compressedSize32 = $this$withMappedRangeFrom.getInt(20);
            int uncompressedSize32 = $this$withMappedRangeFrom.getInt(24);
            fileCommentLength = ZipImplementationKt.getUnsignedShort($this$withMappedRangeFrom, 32);
            int offsetOfFileData32 = $this$withMappedRangeFrom.getInt(42);
            Ref.IntRef extraFieldNo = new Ref.IntRef();
            short extraFieldsSize = $this$withMappedRangeFrom.getShort(extraFieldOffset + 2);
            compressedSize = ZipImplementationKt.parseCentralDirectory$lambda$5$toLongOrNextZip64ExtrField(compressedSize32, extraFieldsSize, extraFieldNo, $this$withMappedRangeFrom, extraFieldOffset);
            uncompressedSize = ZipImplementationKt.parseCentralDirectory$lambda$5$toLongOrNextZip64ExtrField(uncompressedSize32, extraFieldsSize, extraFieldNo, $this$withMappedRangeFrom, extraFieldOffset);
            offsetOfFileData = ZipImplementationKt.parseCentralDirectory$lambda$5$toLongOrNextZip64ExtrField(offsetOfFileData32, extraFieldsSize, extraFieldNo, $this$withMappedRangeFrom, extraFieldOffset);
            byte[] $this$all$iv = bytesForName = $this$withMappedRangeFrom.getBytes(46, fileNameLength);
            boolean $i$f$all = false;
            int n2 = $this$all$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                byte element$iv;
                byte it = element$iv = $this$all$iv[i2];
                boolean bl2 = false;
                if (it >= 0) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        CharSequence name = bl ? (CharSequence)new ByteArrayCharSequence(bytesForName, 0, 0, 6, null) : (CharSequence)new String(bytesForName, Charsets.UTF_8);
        $currentStart.element += (long)(46 + fileNameLength + extraLength + fileCommentLength);
        switch (compressionMethod) {
            case 0: {
                compressionKind = ZipEntryDescription.CompressionKind.PLAIN;
                break;
            }
            case 8: {
                compressionKind = ZipEntryDescription.CompressionKind.DEFLATE;
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected compression method (" + compressionMethod + ") at " + name).toString());
            }
        }
        ZipEntryDescription.CompressionKind compressionKind2 = compressionKind;
        ((Collection)$result).add(new ZipEntryDescription(name, compressedSize, uncompressedSize, offsetOfFileData, compressionKind2, fileNameLength));
        return Unit.INSTANCE;
    }

    private static final Pair parseCentralDirectoryRecordsNumberAndOffset$lambda$6(LargeDynamicMappedBuffer.Mapping $this$withMappedTail) {
        int endOfCentralDirectoryOffset;
        Intrinsics.checkNotNullParameter($this$withMappedTail, "$this$withMappedTail");
        for (endOfCentralDirectoryOffset = $this$withMappedTail.endOffset() - 22; endOfCentralDirectoryOffset >= 0 && $this$withMappedTail.getInt(endOfCentralDirectoryOffset) != 101010256; --endOfCentralDirectoryOffset) {
        }
        int entriesNumber = ZipImplementationKt.getUnsignedShort($this$withMappedTail, endOfCentralDirectoryOffset + 10);
        int offsetOfCentralDirectory = $this$withMappedTail.getInt(endOfCentralDirectoryOffset + 16);
        return entriesNumber == 65535 || offsetOfCentralDirectory == -1 ? ZipImplementationKt.parseZip64CentralDirectoryRecordsNumberAndOffset($this$withMappedTail) : new Pair<Long, Long>(Long.valueOf(entriesNumber), (long)UInt.constructor-impl(offsetOfCentralDirectory) & 0xFFFFFFFFL);
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ZipEntryDescription.CompressionKind.values().length];
            try {
                nArray[ZipEntryDescription.CompressionKind.DEFLATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZipEntryDescription.CompressionKind.PLAIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

