/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class ZipEntryDescription {
    @NotNull
    private final CharSequence relativePath;
    private final long compressedSize;
    private final long uncompressedSize;
    private final long offsetInFile;
    @NotNull
    private final CompressionKind compressionKind;
    private final int fileNameSize;

    public ZipEntryDescription(@NotNull CharSequence relativePath, long compressedSize, long uncompressedSize, long offsetInFile, @NotNull CompressionKind compressionKind, int fileNameSize) {
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        Intrinsics.checkNotNullParameter((Object)compressionKind, "compressionKind");
        this.relativePath = relativePath;
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
        this.offsetInFile = offsetInFile;
        this.compressionKind = compressionKind;
        this.fileNameSize = fileNameSize;
    }

    @NotNull
    public final CharSequence getRelativePath() {
        return this.relativePath;
    }

    public final long getCompressedSize() {
        return this.compressedSize;
    }

    public final long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public final long getOffsetInFile() {
        return this.offsetInFile;
    }

    @NotNull
    public final CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public final int getFileNameSize() {
        return this.fileNameSize;
    }

    public final boolean isDirectory() {
        return this.uncompressedSize == 0L;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/ZipEntryDescription$CompressionKind;", "", "<init>", "(Ljava/lang/String;I)V", "PLAIN", "DEFLATE", "cli-base"})
    public static final class CompressionKind
    extends Enum<CompressionKind> {
        public static final /* enum */ CompressionKind PLAIN = new CompressionKind();
        public static final /* enum */ CompressionKind DEFLATE = new CompressionKind();
        private static final /* synthetic */ CompressionKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CompressionKind[] values() {
            return (CompressionKind[])$VALUES.clone();
        }

        public static CompressionKind valueOf(String value2) {
            return Enum.valueOf(CompressionKind.class, value2);
        }

        @NotNull
        public static EnumEntries<CompressionKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = compressionKindArray = new CompressionKind[]{CompressionKind.PLAIN, CompressionKind.DEFLATE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

