/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import com.google.common.primitives.Longs;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LargeDynamicMappedBuffer {
    private final long dataSize;
    @NotNull
    private final Function2<Long, Long, MappedByteBuffer> mapBuffer;
    @NotNull
    private final Function1<MappedByteBuffer, Unit> unmapBuffer;
    @NotNull
    private final ByteOrder defaultByteOrder;
    @Nullable
    private MappedByteBuffer currentMappedBuffer;
    private long currentStart;
    private long currentEnd;

    public LargeDynamicMappedBuffer(long dataSize, @NotNull Function2<? super Long, ? super Long, ? extends MappedByteBuffer> mapBuffer, @NotNull Function1<? super MappedByteBuffer, Unit> unmapBuffer, @NotNull ByteOrder defaultByteOrder) {
        Intrinsics.checkNotNullParameter(mapBuffer, "mapBuffer");
        Intrinsics.checkNotNullParameter(unmapBuffer, "unmapBuffer");
        Intrinsics.checkNotNullParameter(defaultByteOrder, "defaultByteOrder");
        this.dataSize = dataSize;
        this.mapBuffer = mapBuffer;
        this.unmapBuffer = unmapBuffer;
        this.defaultByteOrder = defaultByteOrder;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized <R> R withMappedRange(long start, long end, @NotNull Function1<? super Mapping, ? extends R> body) {
        Intrinsics.checkNotNullParameter(body, "body");
        long l2 = start + 1L;
        if (!((end <= this.dataSize ? l2 <= end : false) && end - start <= Integer.MAX_VALUE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long currentSize = Integer.MAX_VALUE;
        if (this.currentMappedBuffer == null || this.currentStart > start || this.currentEnd < end) {
            void it;
            MappedByteBuffer mappedByteBuffer;
            if (this.dataSize <= Integer.MAX_VALUE) {
                this.currentStart = 0L;
                this.currentEnd = this.dataSize;
                currentSize = this.dataSize;
            } else if (start + (long)Integer.MAX_VALUE > this.dataSize) {
                this.currentStart = this.dataSize - (long)Integer.MAX_VALUE;
                this.currentEnd = this.dataSize;
            } else {
                this.currentStart = start;
                this.currentEnd = start + (long)Integer.MAX_VALUE;
            }
            this.unmap();
            MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer = this.mapBuffer.invoke(this.currentStart, currentSize);
            LargeDynamicMappedBuffer largeDynamicMappedBuffer = this;
            boolean bl = false;
            it.order(this.defaultByteOrder);
            largeDynamicMappedBuffer.currentMappedBuffer = mappedByteBuffer;
        }
        MappedByteBuffer mappedByteBuffer = this.currentMappedBuffer;
        Intrinsics.checkNotNull(mappedByteBuffer);
        MappedByteBuffer buffer = mappedByteBuffer;
        if (!(this.currentStart <= start && this.currentEnd >= end && start - this.currentStart < Integer.MAX_VALUE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        buffer.position((int)(start - this.currentStart));
        return body.invoke(new Mapping(buffer, buffer.position()));
    }

    public final <R> R withMappedTail(@NotNull Function1<? super Mapping, ? extends R> body) {
        Intrinsics.checkNotNullParameter(body, "body");
        long[] lArray = new long[]{this.dataSize, Integer.MAX_VALUE};
        long size = Longs.min(lArray);
        return this.withMappedRange(this.dataSize - size, this.dataSize, body);
    }

    public final <R> R withMappedRangeFrom(long start, @NotNull Function1<? super Mapping, ? extends R> body) {
        Intrinsics.checkNotNullParameter(body, "body");
        if (!(start < this.dataSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long[] lArray = new long[]{this.dataSize - start, Integer.MAX_VALUE};
        long size = Longs.min(lArray);
        return this.withMappedRange(start, start + size, body);
    }

    public final void unmap() {
        MappedByteBuffer mappedByteBuffer = this.currentMappedBuffer;
        if (mappedByteBuffer != null) {
            this.unmapBuffer.invoke(mappedByteBuffer);
        }
    }

    public static final class Mapping {
        @NotNull
        private final MappedByteBuffer buffer;
        private final int baseOffset;

        public Mapping(@NotNull MappedByteBuffer buffer, int baseOffset) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this.buffer = buffer;
            this.baseOffset = baseOffset;
        }

        public final int getInt(int offset) {
            return this.buffer.getInt(this.baseOffset + offset);
        }

        public final long getLong(int offset) {
            return this.buffer.getLong(this.baseOffset + offset);
        }

        public final short getShort(int offset) {
            return this.buffer.getShort(this.baseOffset + offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] getBytes(int offset, int length) {
            byte[] bytes = new byte[length];
            this.buffer.position(this.baseOffset + offset);
            try {
                this.buffer.get(bytes, 0, length);
                byte[] byArray = bytes;
                return byArray;
            }
            finally {
                this.buffer.position(this.baseOffset);
            }
        }

        public final int endOffset() {
            return this.buffer.capacity() - this.baseOffset;
        }
    }
}

