/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarHandler;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarVirtualFileKt;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipEntryDescription;

public final class FastJarVirtualFile
extends VirtualFile {
    @NotNull
    private final FastJarHandler handler;
    @NotNull
    private final CharSequence name;
    private final long length;
    @Nullable
    private final FastJarVirtualFile parent;
    @Nullable
    private final ZipEntryDescription entryDescription;
    private VirtualFile[] myChildrenArray;
    @NotNull
    private final List<VirtualFile> myChildrenList;

    public FastJarVirtualFile(@NotNull FastJarHandler handler2, @NotNull CharSequence name, long length, @Nullable FastJarVirtualFile parent2, @Nullable ZipEntryDescription entryDescription) {
        block0: {
            Intrinsics.checkNotNullParameter(handler2, "handler");
            Intrinsics.checkNotNullParameter(name, "name");
            this.handler = handler2;
            this.name = name;
            this.length = length;
            this.parent = parent2;
            this.entryDescription = entryDescription;
            this.myChildrenArray = VirtualFile.EMPTY_ARRAY;
            this.myChildrenList = new ArrayList();
            Object object = this.parent;
            if (object == null || (object = ((FastJarVirtualFile)object).myChildrenList) == null) break block0;
            object.add(this);
        }
    }

    public final void initChildrenArrayFromList() {
        Collection $this$toTypedArray$iv = this.myChildrenList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.myChildrenArray = thisCollection$iv.toArray(new VirtualFile[0]);
        this.myChildrenList.clear();
    }

    @Override
    @NotNull
    public String getName() {
        return ((Object)this.name).toString();
    }

    @Override
    @NotNull
    public CharSequence getNameSequence() {
        return this.name;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.handler.getFileSystem();
    }

    @Override
    @NotNull
    public String getPath() {
        if (this.parent == null) {
            return FileUtil.toSystemIndependentName(this.handler.getFile$cli_base().getPath()) + "!/";
        }
        String parentPath = this.parent.getPath();
        StringBuilder answer = new StringBuilder(parentPath.length() + 1 + this.name.length());
        answer.append(parentPath);
        if (answer.charAt(answer.length() - 1) != '/') {
            answer.append('/');
        }
        answer.append(this.name);
        String string = answer.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.length < 0L;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public VirtualFile[] getChildren() {
        Intrinsics.checkNotNullExpressionValue(this.myChildrenArray, "myChildrenArray");
        return this.myChildrenArray;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@NotNull Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        Intrinsics.checkNotNullParameter(requestor, "requestor");
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (this.entryDescription == null) {
            return FastJarVirtualFileKt.access$getEMPTY_BYTE_ARRAY$p();
        }
        return this.handler.contentsToByteArray(this.entryDescription);
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray());
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }
}

