/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.io.FileAccessorCache;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarFileSystem;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarFileSystemKt;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.FastJarHandler;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.LargeDynamicMappedBuffer;

public final class FastJarFileSystem
extends DeprecatedVirtualFileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<MappedByteBuffer, Unit> unmapBuffer;
    @NotNull
    private final Map<String, FastJarHandler> myHandlers;
    @NotNull
    private final FileAccessorCache<File, Pair<RandomAccessFile, LargeDynamicMappedBuffer>> cachedOpenFileHandles;

    private FastJarFileSystem(Function1<? super MappedByteBuffer, Unit> unmapBuffer) {
        this.unmapBuffer = unmapBuffer;
        ConcurrentMap<Object, FastJarHandler> concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> FastJarFileSystem.myHandlers$lambda$1(arg_0 -> FastJarFileSystem.myHandlers$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createMap(...)");
        this.myHandlers = concurrentMap;
        this.cachedOpenFileHandles = new FileAccessorCache<File, Pair<? extends RandomAccessFile, ? extends LargeDynamicMappedBuffer>>(this){
            final /* synthetic */ FastJarFileSystem this$0;
            {
                this.this$0 = $receiver;
                super(20, 10);
            }

            protected Pair<RandomAccessFile, LargeDynamicMappedBuffer> createAccessor(File file) throws IOException {
                Intrinsics.checkNotNullParameter(file, "file");
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                long l2 = randomAccessFile.length();
                Function2<Long, Long, MappedByteBuffer> function2 = (arg_0, arg_1) -> cachedOpenFileHandles.1.createAccessor$lambda$0(randomAccessFile, arg_0, arg_1);
                Function1<MappedByteBuffer, Unit> function1 = this.this$0.getUnmapBuffer$cli_base();
                ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
                Intrinsics.checkNotNullExpressionValue(byteOrder, "LITTLE_ENDIAN");
                LargeDynamicMappedBuffer buffer = new LargeDynamicMappedBuffer(l2, function2, function1, byteOrder);
                return new Pair<RandomAccessFile, LargeDynamicMappedBuffer>(randomAccessFile, buffer);
            }

            protected void disposeAccessor(Pair<? extends RandomAccessFile, LargeDynamicMappedBuffer> fileAccessor) throws IOException {
                Intrinsics.checkNotNullParameter(fileAccessor, "fileAccessor");
                fileAccessor.getFirst().close();
                fileAccessor.getSecond().unmap();
            }

            public boolean isEqual(File val1, File val2) {
                Intrinsics.checkNotNullParameter(val1, "val1");
                Intrinsics.checkNotNullParameter(val2, "val2");
                return Intrinsics.areEqual(val1, val2);
            }

            private static final MappedByteBuffer createAccessor$lambda$0(RandomAccessFile $randomAccessFile, long offset, long size) {
                MappedByteBuffer mappedByteBuffer = $randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, offset, size);
                Intrinsics.checkNotNullExpressionValue(mappedByteBuffer, "map(...)");
                return mappedByteBuffer;
            }
        };
    }

    @NotNull
    public final Function1<MappedByteBuffer, Unit> getUnmapBuffer$cli_base() {
        return this.unmapBuffer;
    }

    @NotNull
    public final FileAccessorCache<File, Pair<RandomAccessFile, LargeDynamicMappedBuffer>> getCachedOpenFileHandles$cli_base() {
        return this.cachedOpenFileHandles;
    }

    @Override
    @NotNull
    public String getProtocol() {
        return "jar";
    }

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Couple<String> pair = Companion.splitPath(path);
        FastJarHandler fastJarHandler = this.myHandlers.get(pair.first);
        Intrinsics.checkNotNull(fastJarHandler);
        Object object = pair.second;
        Intrinsics.checkNotNullExpressionValue(object, "second");
        return fastJarHandler.findFileByPath((String)object);
    }

    @Override
    public void refresh(boolean asynchronous) {
    }

    @Override
    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.findFileByPath(path);
    }

    public final void clearHandlersCache() {
        this.myHandlers.clear();
        this.cleanOpenFilesCache();
    }

    public final void cleanOpenFilesCache() {
        this.cachedOpenFileHandles.clear();
    }

    private static final FastJarHandler myHandlers$lambda$0(FastJarFileSystem this$0, String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return new FastJarHandler(this$0, key);
    }

    private static final FastJarHandler myHandlers$lambda$1(Function1 $tmp0, Object p0) {
        return (FastJarHandler)$tmp0.invoke(p0);
    }

    public /* synthetic */ FastJarFileSystem(Function1 unmapBuffer, DefaultConstructorMarker $constructor_marker) {
        this(unmapBuffer);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Couple<String> splitPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter(path, "path");
            int separator = StringsKt.indexOf$default((CharSequence)path, "!/", 0, false, 6, null);
            if (!(separator >= 0)) {
                boolean $i$a$-require-FastJarFileSystem$Companion$splitPath$22 = false;
                String $i$a$-require-FastJarFileSystem$Companion$splitPath$22 = "Path in JarFileSystem must contain a separator: " + path;
                throw new IllegalArgumentException($i$a$-require-FastJarFileSystem$Companion$splitPath$22.toString());
            }
            String string = path.substring(0, separator);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String localPath = string;
            String string2 = path.substring(separator + 2);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String pathInJar = string2;
            Couple<String> couple = Couple.of(localPath, pathInJar);
            Intrinsics.checkNotNullExpressionValue(couple, "of(...)");
            return couple;
        }

        @Nullable
        public final FastJarFileSystem createIfUnmappingPossible() {
            Function1 function1 = FastJarFileSystemKt.access$prepareCleanerCallback();
            if (function1 == null) {
                return null;
            }
            Function1 cleanerCallBack = function1;
            return new FastJarFileSystem(cleanerCallBack, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

