/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteArrayCharSequence
implements CharSequence {
    @NotNull
    private final byte[] bytes;
    private final int start;
    private final int end;

    public ByteArrayCharSequence(@NotNull byte[] bytes, int start, int end) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        this.bytes = bytes;
        this.start = start;
        this.end = end;
    }

    public /* synthetic */ ByteArrayCharSequence(byte[] byArray, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = byArray.length;
        }
        this(byArray, n2, n3);
    }

    public int hashCode() {
        throw new IllegalStateException("Do not try computing hashCode ByteArrayCharSequence".toString());
    }

    public boolean equals(@Nullable Object other) {
        throw new IllegalStateException("Do not try comparing ByteArrayCharSequence".toString());
    }

    public int getLength() {
        return this.end - this.start;
    }

    public char get(int index2) {
        return (char)this.bytes[index2 + this.start];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        if (startIndex == 0 && endIndex == this.length()) {
            return this;
        }
        return new ByteArrayCharSequence(this.bytes, this.start + startIndex, this.start + endIndex);
    }

    @Override
    @NotNull
    public String toString() {
        char[] chars = new char[this.length()];
        int n2 = this.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            chars[i2] = (char)this.bytes[i2 + this.start];
        }
        return new String(chars);
    }
}

