/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.core.CoreJavaFileManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.GlobalSearchScope;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCliJavaFileManagerImplKt;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndex;
import org.jetbrains.kotlin.cli.jvm.index.SingleJavaFileRootsIndex;
import org.jetbrains.kotlin.load.java.JavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryClassSignatureParser;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.ClassifierResolutionContext;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.OtherKt;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementPsiSource;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementSourceFactory;
import org.jetbrains.kotlin.load.kotlin.PackagePartProvider;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.util.PerformanceManager;
import org.jetbrains.kotlin.util.PerformanceManagerKt;
import org.jetbrains.kotlin.util.PhaseSideType;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.SmartList;

public final class KotlinCliJavaFileManagerImpl
extends CoreJavaFileManager
implements KotlinCliJavaFileManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiManager myPsiManager;
    @Nullable
    private PerformanceManager perfManager;
    private JvmDependenciesIndex index;
    private SingleJavaFileRootsIndex singleJavaFileRootsIndex;
    private List<? extends PackagePartProvider> packagePartProviders;
    @NotNull
    private final Map<FqName, SmartList<VirtualFile>> topLevelClassesCache;
    @NotNull
    private final GlobalSearchScope allScope;
    private boolean usePsiClassFilesReading;
    @NotNull
    private final Map<ClassId, JavaClass> binaryCache;
    @NotNull
    private final BinaryClassSignatureParser signatureParsingComponent;
    @NotNull
    private static final Logger LOG;

    public KotlinCliJavaFileManagerImpl(@NotNull PsiManager myPsiManager) {
        Intrinsics.checkNotNullParameter(myPsiManager, "myPsiManager");
        super(myPsiManager);
        this.myPsiManager = myPsiManager;
        this.topLevelClassesCache = new Object2ObjectOpenHashMap();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.myPsiManager.getProject());
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "allScope(...)");
        this.allScope = globalSearchScope;
        this.binaryCache = new Object2ObjectOpenHashMap();
        this.signatureParsingComponent = new BinaryClassSignatureParser();
    }

    public final void initialize(@NotNull JvmDependenciesIndex index2, @NotNull List<? extends PackagePartProvider> packagePartProviders, @NotNull SingleJavaFileRootsIndex singleJavaFileRootsIndex, boolean usePsiClassFilesReading, @Nullable PerformanceManager perfManager) {
        Intrinsics.checkNotNullParameter(index2, "index");
        Intrinsics.checkNotNullParameter(packagePartProviders, "packagePartProviders");
        Intrinsics.checkNotNullParameter(singleJavaFileRootsIndex, "singleJavaFileRootsIndex");
        this.index = index2;
        this.packagePartProviders = packagePartProviders;
        this.singleJavaFileRootsIndex = singleJavaFileRootsIndex;
        this.usePsiClassFilesReading = usePsiClassFilesReading;
        this.perfManager = perfManager;
    }

    private final PsiClass findPsiClass(ClassId classId, GlobalSearchScope searchScope) {
        return PerformanceManagerKt.tryMeasureSideTime(this.perfManager, PhaseSideType.FindJavaClass, () -> KotlinCliJavaFileManagerImpl.findPsiClass$lambda$0(this, classId, searchScope));
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile findVirtualFileForTopLevelClass(ClassId classId, GlobalSearchScope searchScope) {
        VirtualFile virtualFile;
        SmartList<VirtualFile> smartList;
        SmartList<VirtualFile> smartList2;
        String relativeClassName = classId.getRelativeClassName().asString();
        FqName outerMostClassFqName = classId.getPackageFqName().child(kotlin.collections.CollectionsKt.first(classId.getRelativeClassName().pathSegments()));
        Object $this$getOrPut$iv = this.topLevelClassesCache;
        boolean $i$f$getOrPut = false;
        SmartList<VirtualFile> value$iv = $this$getOrPut$iv.get(outerMostClassFqName);
        if (value$iv == null) {
            SmartList<VirtualFile> smartList3;
            Object it;
            boolean bl = false;
            ClassId outerMostClassId = ClassId.Companion.topLevel(outerMostClassFqName);
            SingleJavaFileRootsIndex singleJavaFileRootsIndex = this.singleJavaFileRootsIndex;
            if (singleJavaFileRootsIndex == null) {
                Intrinsics.throwUninitializedPropertyAccessException("singleJavaFileRootsIndex");
                singleJavaFileRootsIndex = null;
            }
            VirtualFile virtualFile2 = singleJavaFileRootsIndex.findJavaSourceClass(outerMostClassId);
            if (virtualFile2 != null) {
                it = virtualFile2;
                boolean bl2 = false;
                smartList3 = new SmartList<VirtualFile>((VirtualFile)it);
            } else {
                JvmDependenciesIndex jvmDependenciesIndex = this.index;
                if (jvmDependenciesIndex == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("index");
                    jvmDependenciesIndex = null;
                }
                SmartList smartList4 = new SmartList(JvmDependenciesIndex.findClasses$default(jvmDependenciesIndex, outerMostClassId, null, (arg_0, arg_1) -> KotlinCliJavaFileManagerImpl.findVirtualFileForTopLevelClass$lambda$4$lambda$2(this, relativeClassName, arg_0, arg_1), 2, null));
                it = smartList4;
                boolean bl3 = false;
                smartList3 = !((Collection)it).isEmpty() ? smartList4 : null;
            }
            SmartList<VirtualFile> answer$iv = smartList3;
            $this$getOrPut$iv.put(outerMostClassFqName, answer$iv);
            smartList2 = answer$iv;
        } else {
            smartList2 = value$iv;
        }
        if ((smartList = smartList2) != null) {
            Object v5;
            block9: {
                void $this$firstOrNull$iv;
                $this$getOrPut$iv = smartList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl = false;
                    if (!searchScope.contains(it)) continue;
                    v5 = element$iv;
                    break block9;
                }
                v5 = null;
            }
            virtualFile = v5;
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Nullable
    public final JavaClass findClass(@NotNull ClassId classId, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(searchScope, "searchScope");
        return this.findClass(new JavaClassFinder.Request(classId, null, null, 6, null), searchScope);
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull JavaClassFinder.Request request, @NotNull GlobalSearchScope searchScope) {
        JavaClassImpl javaClassImpl;
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(searchScope, "searchScope");
        ClassId classId = request.component1();
        byte[] classFileContentFromRequest = request.component2();
        JavaClass outerClassFromRequest = request.component3();
        VirtualFile virtualFile = this.findVirtualFileForTopLevelClass(classId, searchScope);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!this.usePsiClassFilesReading && (Intrinsics.areEqual(virtualFile2.getExtension(), "class") || Intrinsics.areEqual(virtualFile2.getExtension(), "sig"))) {
            JavaClass javaClass;
            Map<ClassId, JavaClass> $this$getOrPut$iv = this.binaryCache;
            boolean $i$f$getOrPut = false;
            JavaClass value$iv = $this$getOrPut$iv.get(classId);
            if (value$iv == null) {
                JavaClass javaClass2;
                boolean bl = false;
                ClassId classId2 = classId.getOuterClassId();
                if (classId2 != null) {
                    JavaClass outerClass;
                    ClassId outerClassId = classId2;
                    boolean bl2 = false;
                    JavaClass javaClass3 = outerClassFromRequest;
                    if (javaClass3 == null) {
                        javaClass3 = this.findClass(outerClassId, searchScope);
                    }
                    if ((outerClass = javaClass3) instanceof BinaryJavaClass) {
                        javaClass2 = ((BinaryJavaClass)outerClass).findInnerClass(classId.getShortClassName(), classFileContentFromRequest);
                    } else {
                        JavaClass javaClass4 = outerClass;
                        javaClass2 = javaClass4 != null ? javaClass4.findInnerClass(classId.getShortClassName()) : null;
                    }
                } else {
                    byte[] byArray = classFileContentFromRequest;
                    if (classFileContentFromRequest == null) {
                        byte[] byArray2 = virtualFile2.contentsToByteArray();
                        byArray = byArray2;
                        Intrinsics.checkNotNullExpressionValue(byArray2, "contentsToByteArray(...)");
                    }
                    byte[] classContent = byArray;
                    String string = virtualFile2.getNameWithoutExtension();
                    Intrinsics.checkNotNullExpressionValue(string, "getNameWithoutExtension(...)");
                    if (StringsKt.contains$default((CharSequence)string, "$", false, 2, null) && OtherKt.isNotTopLevelClass(classContent)) {
                        javaClass2 = null;
                    } else {
                        ClassifierResolutionContext resolver = new ClassifierResolutionContext(arg_0 -> KotlinCliJavaFileManagerImpl.findClass$lambda$8$lambda$7(this, arg_0));
                        javaClass2 = new BinaryJavaClass(virtualFile2, classId.asSingleFqName(), resolver, this.signatureParsingComponent, 0, null, classContent, 16, null);
                    }
                }
                JavaClass answer$iv = javaClass2;
                $this$getOrPut$iv.put(classId, answer$iv);
                javaClass = answer$iv;
            } else {
                javaClass = value$iv;
            }
            return javaClass;
        }
        PsiClass psiClass = this.findPsiClassInVirtualFile(virtualFile2, classId.getRelativeClassName().asString());
        if (psiClass != null) {
            PsiClass it = psiClass;
            boolean bl = false;
            javaClassImpl = this.createJavaClassByPsiClass(it);
        } else {
            javaClassImpl = null;
        }
        return javaClassImpl;
    }

    private final JavaClassImpl createJavaClassByPsiClass(PsiClass psiClass) {
        Project project = this.myPsiManager.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        Project project2 = project;
        JavaElementSourceFactory sourceFactory = JavaElementSourceFactory.Companion.getInstance(project2);
        return new JavaClassImpl((JavaElementPsiSource<PsiClass>)sourceFactory.createPsiSource((PsiElement)psiClass));
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(qName, "qName");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        KotlinCliJavaFileManagerImpl this_$iv = this;
        boolean $i$f$forEachClassId = false;
        ClassId classId = KotlinCliJavaFileManagerImplKt.access$toSafeTopLevelClassId(qName);
        if (classId != null) {
            ClassId classId$iv = classId;
            while (true) {
                ClassId classId2 = classId$iv;
                boolean bl = false;
                PsiClass psiClass = this.findPsiClass(classId2, scope2);
                if (psiClass != null) {
                    PsiClass it = psiClass;
                    boolean bl2 = false;
                    return it;
                }
                FqName packageFqName$iv = classId$iv.getPackageFqName();
                if (packageFqName$iv.isRoot()) break;
                classId$iv = new ClassId(packageFqName$iv.parent(), new FqName(packageFqName$iv.shortName().asString() + '.' + classId$iv.getRelativeClassName().asString()), false);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qName, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(qName, "qName");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return PerformanceManagerKt.tryMeasureSideTime(this.perfManager, PhaseSideType.FindJavaClass, () -> KotlinCliJavaFileManagerImpl.findClasses$lambda$16(this, qName, scope2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PsiPackage findPackage(@NotNull String packageName) {
        Object object;
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Ref.BooleanRef found = new Ref.BooleanRef();
        FqName fqName2 = KotlinCliJavaFileManagerImplKt.access$toSafeFqName(packageName);
        if (fqName2 == null) {
            return null;
        }
        FqName packageFqName = fqName2;
        JvmDependenciesIndex jvmDependenciesIndex = this.index;
        if (jvmDependenciesIndex == null) {
            Intrinsics.throwUninitializedPropertyAccessException("index");
            jvmDependenciesIndex = null;
        }
        JvmDependenciesIndex.traverseDirectoriesInPackage$default(jvmDependenciesIndex, packageFqName, null, (arg_0, arg_1) -> KotlinCliJavaFileManagerImpl.findPackage$lambda$17(found, arg_0, arg_1), 2, null);
        if (!found.element) {
            boolean bl;
            boolean bl2;
            block10: {
                void $this$any$iv;
                List<? extends PackagePartProvider> list = this.packagePartProviders;
                if (list == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("packagePartProviders");
                    list = null;
                }
                object = list;
                Ref.BooleanRef booleanRef = found;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PackagePartProvider it = (PackagePartProvider)element$iv;
                        boolean bl3 = false;
                        boolean bl4 = !((Collection)it.findPackageParts(packageName)).isEmpty();
                        if (!bl4) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            booleanRef.element = bl = bl2;
        }
        if (!found.element) {
            SingleJavaFileRootsIndex singleJavaFileRootsIndex = this.singleJavaFileRootsIndex;
            if (singleJavaFileRootsIndex == null) {
                Intrinsics.throwUninitializedPropertyAccessException("singleJavaFileRootsIndex");
                singleJavaFileRootsIndex = null;
            }
            found.element = singleJavaFileRootsIndex.hasPackage(packageFqName);
        }
        if (!found.element) {
            return null;
        }
        object = this.myPsiManager;
        return new PsiPackageImpl(packageName, (PsiManager)object){

            public boolean isValid() {
                return true;
            }
        };
    }

    private final VirtualFile findVirtualFileGivenPackage(VirtualFile packageDir, String classNameWithInnerClasses, JavaRoot.RootType rootType) {
        VirtualFile virtualFile;
        String topLevelClassName = StringsKt.substringBefore$default(classNameWithInnerClasses, '.', null, 2, null);
        switch (WhenMappings.$EnumSwitchMapping$0[rootType.ordinal()]) {
            case 1: {
                virtualFile = packageDir.findChild(topLevelClassName + ".class");
                break;
            }
            case 2: {
                virtualFile = packageDir.findChild(topLevelClassName + ".sig");
                break;
            }
            case 3: {
                virtualFile = packageDir.findChild(topLevelClassName + ".java");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        if (!vFile.isValid()) {
            LOG.error("Invalid child of valid parent: " + vFile.getPath() + "; " + packageDir.isValid() + " path=" + packageDir.getPath());
            return null;
        }
        return vFile;
    }

    private final PsiClass findPsiClassInVirtualFile(VirtualFile $this$findPsiClassInVirtualFile, String classNameWithInnerClasses) {
        PsiFile psiFile = this.myPsiManager.findFile($this$findPsiClassInVirtualFile);
        PsiClassOwner psiClassOwner = psiFile instanceof PsiClassOwner ? (PsiClassOwner)psiFile : null;
        if (psiClassOwner == null) {
            return null;
        }
        PsiClassOwner file = psiClassOwner;
        return KotlinCliJavaFileManagerImpl.Companion.findClassInPsiFile(classNameWithInnerClasses, file);
    }

    @Override
    @NotNull
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        ObjectOpenHashSet<String> result2 = new ObjectOpenHashSet<String>();
        JvmDependenciesIndex jvmDependenciesIndex = this.index;
        if (jvmDependenciesIndex == null) {
            Intrinsics.throwUninitializedPropertyAccessException("index");
            jvmDependenciesIndex = null;
        }
        JvmDependenciesIndex.traverseDirectoriesInPackage$default(jvmDependenciesIndex, packageFqName, null, (arg_0, arg_1) -> KotlinCliJavaFileManagerImpl.knownClassNamesInPackage$lambda$19(result2, arg_0, arg_1), 2, null);
        SingleJavaFileRootsIndex singleJavaFileRootsIndex = this.singleJavaFileRootsIndex;
        if (singleJavaFileRootsIndex == null) {
            Intrinsics.throwUninitializedPropertyAccessException("singleJavaFileRootsIndex");
            singleJavaFileRootsIndex = null;
        }
        for (ClassId classId : singleJavaFileRootsIndex.findJavaSourceClasses(packageFqName)) {
            boolean bl;
            boolean bl2 = bl = !classId.isNestedClass();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "ClassId of a single .java source class should not be nested: " + classId;
                throw new AssertionError((Object)string);
            }
            result2.add(classId.getShortClassName().asString());
        }
        return result2;
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Collection<String> getNonTrivialPackagePrefixes() {
        return kotlin.collections.CollectionsKt.emptyList();
    }

    private static final PsiClass findPsiClass$lambda$0(KotlinCliJavaFileManagerImpl this$0, ClassId $classId, GlobalSearchScope $searchScope) {
        VirtualFile virtualFile = this$0.findVirtualFileForTopLevelClass($classId, $searchScope);
        return virtualFile != null ? this$0.findPsiClassInVirtualFile(virtualFile, $classId.getRelativeClassName().asString()) : null;
    }

    private static final VirtualFile findVirtualFileForTopLevelClass$lambda$4$lambda$2(KotlinCliJavaFileManagerImpl this$0, String $relativeClassName, VirtualFile dir2, JavaRoot.RootType type2) {
        Intrinsics.checkNotNullParameter(dir2, "dir");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        return this$0.findVirtualFileGivenPackage(dir2, $relativeClassName, type2);
    }

    private static final JavaClass findClass$lambda$8$lambda$7(KotlinCliJavaFileManagerImpl this$0, ClassId it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.findClass(it, this$0.allScope);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findClasses$lambda$16$lambda$15$lambda$14(KotlinCliJavaFileManagerImpl this$0, String $relativeClassName, ArrayList $result, GlobalSearchScope $scope, VirtualFile dir2, JavaRoot.RootType rootType) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter(dir2, "dir");
        Intrinsics.checkNotNullParameter((Object)rootType, "rootType");
        VirtualFile virtualFile2 = this$0.findVirtualFileGivenPackage(dir2, $relativeClassName, rootType);
        if (virtualFile2 == null) return true;
        VirtualFile it = virtualFile = virtualFile2;
        boolean bl = false;
        if (!$scope.contains(it)) return true;
        VirtualFile virtualFile3 = virtualFile;
        VirtualFile virtualFile4 = virtualFile3;
        if (virtualFile4 == null) return true;
        PsiClass psiClass = this$0.findPsiClassInVirtualFile(virtualFile4, $relativeClassName);
        PsiClass psiClass2 = psiClass;
        if (psiClass2 == null) return true;
        $result.add(psiClass2);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static final PsiClass[] findClasses$lambda$16(KotlinCliJavaFileManagerImpl this$0, String $qName, GlobalSearchScope $scope) {
        block6: {
            result = new ArrayList<E>(1);
            this_$iv = this$0;
            $i$f$forEachClassId = false;
            v0 = KotlinCliJavaFileManagerImplKt.access$toSafeTopLevelClassId($qName);
            if (v0 == null) break block6;
            classId$iv = v0;
            while (true) {
                classId = classId$iv;
                $i$a$-forEachClassId-KotlinCliJavaFileManagerImpl$findClasses$1$1 = false;
                relativeClassName = classId.getRelativeClassName().asString();
                v1 = result;
                v2 = this$0.singleJavaFileRootsIndex;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("singleJavaFileRootsIndex");
                    v2 = null;
                }
                if ((var10_10 = v2.findJavaSourceClass(classId)) == null) ** GOTO lbl-1000
                var12_12 = var11_11 = var10_10;
                var13_13 = v1;
                $i$a$-takeIf-KotlinCliJavaFileManagerImpl$findClasses$1$1$1 = false;
                v1 = var13_13;
                v3 = var15_15 = Boolean.valueOf($scope.contains((VirtualFile)it)) != false ? var11_11 : null;
                if (var15_15 != null) {
                    v4 = this$0.findPsiClassInVirtualFile(var15_15, relativeClassName);
                } else lbl-1000:
                // 2 sources

                {
                    v4 = null;
                }
                CollectionsKt.addIfNotNull(v1, v4);
                v5 = this$0.index;
                if (v5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("index");
                    v5 = null;
                }
                JvmDependenciesIndex.traverseDirectoriesInPackage$default(v5, classId.getPackageFqName(), null, (Function2<VirtualFile, JavaRoot.RootType, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, findClasses$lambda$16$lambda$15$lambda$14(org.jetbrains.kotlin.cli.jvm.compiler.KotlinCliJavaFileManagerImpl java.lang.String java.util.ArrayList com.intellij.psi.search.GlobalSearchScope com.intellij.openapi.vfs.VirtualFile org.jetbrains.kotlin.cli.jvm.index.JavaRoot$RootType ), (Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;)Ljava/lang/Boolean;)((KotlinCliJavaFileManagerImpl)this$0, (String)relativeClassName, result, (GlobalSearchScope)$scope), 2, null);
                if (((Collection)result).isEmpty() == false) {
                    $this$toTypedArray$iv = result;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    return thisCollection$iv.toArray(new PsiClass[0]);
                }
                packageFqName$iv = classId$iv.getPackageFqName();
                if (packageFqName$iv.isRoot()) break;
                classId$iv = new ClassId(packageFqName$iv.parent(), new FqName(packageFqName$iv.shortName().asString() + '.' + classId$iv.getRelativeClassName().asString()), false);
            }
        }
        Intrinsics.checkNotNullExpressionValue(PsiClass.EMPTY_ARRAY, "EMPTY_ARRAY");
        return PsiClass.EMPTY_ARRAY;
    }

    private static final boolean findPackage$lambda$17(Ref.BooleanRef $found, VirtualFile virtualFile, JavaRoot.RootType rootType) {
        Intrinsics.checkNotNullParameter(virtualFile, "<unused var>");
        Intrinsics.checkNotNullParameter((Object)rootType, "<unused var>");
        $found.element = true;
        return false;
    }

    private static final boolean knownClassNamesInPackage$lambda$19(ObjectOpenHashSet $result, VirtualFile dir2, JavaRoot.RootType rootType) {
        Intrinsics.checkNotNullParameter(dir2, "dir");
        Intrinsics.checkNotNullParameter((Object)rootType, "<unused var>");
        Iterator<VirtualFile> iterator2 = ArrayIteratorKt.iterator(dir2.getChildren());
        while (iterator2.hasNext()) {
            VirtualFile child = iterator2.next();
            if (!Intrinsics.areEqual(child.getExtension(), "class") && !Intrinsics.areEqual(child.getExtension(), "java") && !Intrinsics.areEqual(child.getExtension(), "sig")) continue;
            $result.add(child.getNameWithoutExtension());
        }
        return true;
    }

    static {
        Logger logger = Logger.getInstance(KotlinCliJavaFileManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
    }

    public static final class Companion {
        private Companion() {
        }

        private final PsiClass findClassInPsiFile(String classNameWithInnerClassesDotSeparated, PsiClassOwner file) {
            for (PsiClass topLevelClass : file.getClasses()) {
                Intrinsics.checkNotNull(topLevelClass);
                PsiClass candidate = this.findClassByTopLevelClass(classNameWithInnerClassesDotSeparated, topLevelClass);
                if (candidate == null) continue;
                return candidate;
            }
            return null;
        }

        private final PsiClass findClassByTopLevelClass(String className, PsiClass topLevelClass) {
            if (StringsKt.indexOf$default((CharSequence)className, '.', 0, false, 6, null) < 0) {
                return Intrinsics.areEqual(className, topLevelClass.getName()) ? topLevelClass : null;
            }
            Iterator<String> segments = StringUtil.split(className, ".").iterator();
            if (!segments.hasNext() || !Intrinsics.areEqual(segments.next(), topLevelClass.getName())) {
                return null;
            }
            PsiClass curClass = topLevelClass;
            while (segments.hasNext()) {
                PsiClass innerClass;
                String innerClassName = segments.next();
                if (curClass.findInnerClassByName(innerClassName, false) == null) {
                    return null;
                }
                curClass = innerClass;
            }
            return curClass;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JavaRoot.RootType.values().length];
            try {
                nArray[JavaRoot.RootType.BINARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaRoot.RootType.BINARY_SIG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaRoot.RootType.SOURCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

