/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.OutputStream;
import java.io.PrintStream;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.load.kotlin.ModuleMappingUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping;
import org.jetbrains.kotlin.resolve.JvmCompilerDeserializationConfiguration;

public final class JvmPackagePartProviderKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ModuleMapping tryLoadModuleMapping(@NotNull Function0<byte[]> getModuleBytes, @NotNull String debugName, @NotNull String modulePath, @NotNull JvmCompilerDeserializationConfiguration deserializationConfiguration2, @NotNull MessageCollector messageCollector) {
        ModuleMapping moduleMapping;
        Intrinsics.checkNotNullParameter(getModuleBytes, "getModuleBytes");
        Intrinsics.checkNotNullParameter(debugName, "debugName");
        Intrinsics.checkNotNullParameter(modulePath, "modulePath");
        Intrinsics.checkNotNullParameter(deserializationConfiguration2, "deserializationConfiguration");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        try {
            moduleMapping = ModuleMappingUtilKt.loadModuleMapping(ModuleMapping.Companion, getModuleBytes.invoke(), debugName, deserializationConfiguration2, arg_0 -> JvmPackagePartProviderKt.tryLoadModuleMapping$lambda$0(messageCollector, modulePath, arg_0));
        }
        catch (EOFException e2) {
            void it;
            ByteArrayOutputStream byteArrayOutputStream;
            messageCollector.report(CompilerMessageSeverity.ERROR, "Error occurred when reading the module: " + e2.getMessage(), CompilerMessageLocation.Companion.create(modulePath));
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = new ByteArrayOutputStream();
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.LOGGING;
            MessageCollector messageCollector2 = messageCollector;
            boolean bl = false;
            e2.printStackTrace(new PrintStream((OutputStream)it));
            Unit unit = Unit.INSTANCE;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
            byte[] byArray2 = byArray;
            messageCollector2.report(compilerMessageSeverity, new String(byArray2, Charsets.UTF_8), CompilerMessageLocation.Companion.create(modulePath));
            moduleMapping = null;
        }
        return moduleMapping;
    }

    private static final Unit tryLoadModuleMapping$lambda$0(MessageCollector $messageCollector, String $modulePath, MetadataVersion incompatibleVersion) {
        Intrinsics.checkNotNullParameter(incompatibleVersion, "incompatibleVersion");
        $messageCollector.report(CompilerMessageSeverity.ERROR, "Module was compiled with an incompatible version of Kotlin. The binary version of its metadata is " + incompatibleVersion + ", expected version is " + MetadataVersion.INSTANCE + '.', CompilerMessageLocation.Companion.create($modulePath));
        return Unit.INSTANCE;
    }
}

