/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class IdeaStandaloneExecutionSetup {
    @NotNull
    public static final IdeaStandaloneExecutionSetup INSTANCE = new IdeaStandaloneExecutionSetup();
    @NotNull
    private static final Logger LOG;

    private IdeaStandaloneExecutionSetup() {
    }

    public final void doSetup() {
        this.checkInHeadlessMode();
        System.setProperty("project.structure.add.tools.jar.to.new.jdk", "false");
        System.setProperty("psi.track.invalidation", "true");
        System.setProperty("psi.incremental.reparse.depth.limit", "1000");
        System.setProperty("psi.sleep.in.validity.check", "false");
        System.setProperty("ide.hide.excluded.files", "false");
        System.setProperty("ast.loading.filter", "false");
        System.setProperty("idea.ignore.disabled.plugins", "true");
        System.setProperty("platform.random.idempotence.check.rate", "1000");
        this.workaroundEarlyAccessRegistryQueryProblem();
        System.setProperty("idea.plugins.compatible.build", "999.SNAPSHOT");
    }

    private final void workaroundEarlyAccessRegistryQueryProblem() {
        String key = "idea.config.path";
        if (System.getProperty(key) == null) {
            System.setProperty(key, "some/non/existent/path");
        }
    }

    private final void checkInHeadlessMode() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return;
        }
        Application application2 = application;
        if (!application2.isHeadlessEnvironment()) {
            LOG.error(new Throwable("IdeaStandaloneExecutionSetup should be called only in headless environment"));
        }
    }

    static {
        Logger logger = Logger.getInstance(IdeaStandaloneExecutionSetup.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
    }
}

