/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.extensions.CompilerConfigurationExtension;
import org.jetbrains.kotlin.extensions.PreprocessedFileCreator;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;

public final class CoreEnvironmentUtilsKt {
    public static final void report(@NotNull CompilerConfiguration $this$report, @NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageLocation location) {
        Intrinsics.checkNotNullParameter($this$report, "<this>");
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        Intrinsics.checkNotNullParameter(message, "message");
        CommonConfigurationKeysKt.getMessageCollector($this$report).report(severity, message, location);
    }

    public static /* synthetic */ void report$default(CompilerConfiguration compilerConfiguration, CompilerMessageSeverity compilerMessageSeverity, String string, CompilerMessageLocation compilerMessageLocation, int n2, Object object) {
        if ((n2 & 4) != 0) {
            compilerMessageLocation = null;
        }
        CoreEnvironmentUtilsKt.report(compilerConfiguration, compilerMessageSeverity, string, compilerMessageLocation);
    }

    public static final void forAllFiles(@NotNull List<KotlinSourceRoot> $this$forAllFiles, @NotNull CompilerConfiguration configuration2, @NotNull Project project, @Nullable CompilerMessageLocation reportLocation, @NotNull Function3<? super VirtualFile, ? super Boolean, ? super String, Unit> body) {
        Intrinsics.checkNotNullParameter($this$forAllFiles, "<this>");
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(body, "body");
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        HashSet<VirtualFile> processedFiles = new HashSet<VirtualFile>();
        PreprocessedFileCreator virtualFileCreator = new PreprocessedFileCreator(project);
        Ref.BooleanRef pluginsConfigured = new Ref.BooleanRef();
        for (KotlinSourceRoot kotlinSourceRoot : $this$forAllFiles) {
            String sourceRootPath = kotlinSourceRoot.component1();
            boolean isCommon = kotlinSourceRoot.component2();
            String hmppModuleName = kotlinSourceRoot.component3();
            File sourceRoot = new File(sourceRootPath);
            VirtualFile vFile = localFileSystem.findFileByPath(FilesKt.normalize(sourceRoot).getPath());
            if (vFile == null) {
                String message = "Source file or directory not found: " + sourceRootPath;
                File buildFilePath = configuration2.get(JVMConfigurationKeys.MODULE_XML_FILE);
                if (buildFilePath != null && Logger.isInitialized()) {
                    Logger.getInstance(KotlinCoreEnvironment.class).warn(message + "\n\nbuild file path: " + buildFilePath + "\ncontent:\n" + FilesKt.readText$default(buildFilePath, null, 1, null));
                }
                CoreEnvironmentUtilsKt.report(configuration2, CompilerMessageSeverity.ERROR, message, reportLocation);
                continue;
            }
            if (!vFile.isDirectory() && !Intrinsics.areEqual(vFile.getExtension(), "kt")) {
                CoreEnvironmentUtilsKt.forAllFiles$ensurePluginsConfigured(pluginsConfigured, project);
                if (!Intrinsics.areEqual(vFile.getFileType(), KotlinFileType.INSTANCE)) {
                    CoreEnvironmentUtilsKt.report(configuration2, CompilerMessageSeverity.ERROR, "Source entry is not a Kotlin file: " + sourceRootPath, reportLocation);
                    continue;
                }
            }
            Iterator<File> iterator2 = FilesKt.walkTopDown(sourceRoot).iterator();
            while (iterator2.hasNext()) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2;
                File file = iterator2.next();
                if (!file.isFile()) continue;
                File file2 = file.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue(file2, "getAbsoluteFile(...)");
                if (localFileSystem.findFileByPath(FilesKt.normalize(file2).getPath()) != null) {
                    VirtualFile p0;
                    boolean bl = false;
                    virtualFile2 = virtualFileCreator.create(p0);
                } else {
                    virtualFile2 = null;
                }
                if ((virtualFile = virtualFile2) == null || !processedFiles.add(virtualFile)) continue;
                if (!Intrinsics.areEqual(virtualFile.getExtension(), "kt")) {
                    CoreEnvironmentUtilsKt.forAllFiles$ensurePluginsConfigured(pluginsConfigured, project);
                }
                if (!Intrinsics.areEqual(virtualFile.getExtension(), "kt") && !Intrinsics.areEqual(virtualFile.getFileType(), KotlinFileType.INSTANCE)) continue;
                body.invoke(virtualFile, (Boolean)isCommon, hmppModuleName);
            }
        }
    }

    @NotNull
    public static final List<KtFile> createSourceFilesFromSourceRoots(@NotNull CompilerConfiguration configuration2, @NotNull Project project, @NotNull List<KotlinSourceRoot> sourceRoots, @Nullable CompilerMessageLocation reportLocation) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(sourceRoots, "sourceRoots");
        PsiManager psiManager = PsiManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue(psiManager, "getInstance(...)");
        PsiManager psiManager2 = psiManager;
        List result2 = new ArrayList();
        CoreEnvironmentUtilsKt.forAllFiles(sourceRoots, configuration2, project, reportLocation, (arg_0, arg_1, arg_2) -> CoreEnvironmentUtilsKt.createSourceFilesFromSourceRoots$lambda$1(psiManager2, result2, arg_0, arg_1, arg_2));
        return result2;
    }

    public static /* synthetic */ List createSourceFilesFromSourceRoots$default(CompilerConfiguration compilerConfiguration, Project project, List list, CompilerMessageLocation compilerMessageLocation, int n2, Object object) {
        if ((n2 & 8) != 0) {
            compilerMessageLocation = null;
        }
        return CoreEnvironmentUtilsKt.createSourceFilesFromSourceRoots(compilerConfiguration, project, list, compilerMessageLocation);
    }

    @NotNull
    public static final List<KotlinSourceRoot> getSourceRootsCheckingForDuplicates(@NotNull CompilerConfiguration configuration2, @Nullable MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        HashSet<String> uniqueSourceRoots = new HashSet<String>();
        List result2 = new ArrayList();
        for (KotlinSourceRoot root : ContentRootsKt.getKotlinSourceRoots(configuration2)) {
            if (!uniqueSourceRoots.add(root.getPath())) {
                MessageCollector messageCollector2 = messageCollector;
                if (messageCollector2 != null) {
                    MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, "Duplicate source root: " + root.getPath(), null, 4, null);
                }
            }
            result2.add(root);
        }
        return result2;
    }

    private static final void forAllFiles$ensurePluginsConfigured(Ref.BooleanRef pluginsConfigured, Project $project) {
        if (!pluginsConfigured.element) {
            for (CompilerConfigurationExtension extension : CompilerConfigurationExtension.Companion.getInstances($project)) {
                extension.updateFileRegistry();
            }
            pluginsConfigured.element = true;
        }
    }

    private static final Unit createSourceFilesFromSourceRoots$lambda$1(PsiManager $psiManager, List $result, VirtualFile virtualFile, boolean isCommon, String moduleName) {
        block2: {
            Intrinsics.checkNotNullParameter(virtualFile, "virtualFile");
            PsiFile psiFile = $psiManager.findFile(virtualFile);
            if (psiFile == null) break block2;
            PsiFile it = psiFile;
            boolean bl = false;
            if (it instanceof KtFile) {
                IsCommonSourceKt.setCommonSource((KtFile)it, isCommon);
                if (moduleName != null) {
                    IsCommonSourceKt.setHmppModuleName((KtFile)it, moduleName);
                }
                $result.add(it);
            }
        }
        return Unit.INSTANCE;
    }
}

