/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.CliVirtualFileFinder;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndex;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.util.PerformanceManager;

public final class CliVirtualFileFinderFactory
implements VirtualFileFinderFactory {
    @NotNull
    private final JvmDependenciesIndex index;
    private final boolean enableSearchInCtSym;
    @Nullable
    private final PerformanceManager perfManager;

    public CliVirtualFileFinderFactory(@NotNull JvmDependenciesIndex index2, boolean enableSearchInCtSym, @Nullable PerformanceManager perfManager) {
        Intrinsics.checkNotNullParameter(index2, "index");
        this.index = index2;
        this.enableSearchInCtSym = enableSearchInCtSym;
        this.perfManager = perfManager;
    }

    @Override
    @NotNull
    public VirtualFileFinder create(@NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return new CliVirtualFileFinder(this.index, scope2, this.enableSearchInCtSym, this.perfManager);
    }

    @Override
    @NotNull
    public VirtualFileFinder create(@NotNull Project project, @NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(module2, "module");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project);
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "allScope(...)");
        return new CliVirtualFileFinder(this.index, globalSearchScope, this.enableSearchInCtSym, this.perfManager);
    }
}

