/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.project.Project;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.CliBindingTrace;
import org.jetbrains.kotlin.cli.jvm.compiler.NoScopeRecordCliBindingTrace;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.jvm.JvmCodeAnalyzerInitializer;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;

public final class CliTraceHolder
extends JvmCodeAnalyzerInitializer {
    @NotNull
    private final Project project;
    private BindingContext bindingContext;
    private ModuleDescriptor module;
    private LanguageVersionSettings languageVersionSettings;

    public CliTraceHolder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.project = project;
    }

    @NotNull
    public final BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingContext;
        if (bindingContext != null) {
            return bindingContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException("bindingContext");
        return null;
    }

    @NotNull
    public final ModuleDescriptor getModule() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor != null) {
            return moduleDescriptor;
        }
        Intrinsics.throwUninitializedPropertyAccessException("module");
        return null;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        LanguageVersionSettings languageVersionSettings = this.languageVersionSettings;
        if (languageVersionSettings != null) {
            return languageVersionSettings;
        }
        Intrinsics.throwUninitializedPropertyAccessException("languageVersionSettings");
        return null;
    }

    @Override
    public void initialize(@NotNull BindingTrace trace, @NotNull ModuleDescriptor module2, @NotNull KotlinCodeAnalyzer codeAnalyzer, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull JvmTarget jvmTarget) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(codeAnalyzer, "codeAnalyzer");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(jvmTarget, "jvmTarget");
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        this.bindingContext = bindingContext;
        this.module = module2;
        this.languageVersionSettings = languageVersionSettings;
        if (!(trace instanceof CliBindingTrace)) {
            throw new IllegalArgumentException("Shared trace is expected to be subclass of " + CliBindingTrace.class.getSimpleName() + " class");
        }
        ((CliBindingTrace)trace).setKotlinCodeAnalyzer(codeAnalyzer);
    }

    @Override
    @NotNull
    public BindingTraceContext createTrace() {
        return new NoScopeRecordCliBindingTrace(this.project);
    }
}

