/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.config.ContentRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.CliJavaModuleUtilsKt;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRootBase;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootBase;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CliJavaModuleFinder;
import org.jetbrains.kotlin.cli.jvm.modules.JavaModuleGraph;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModule;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;

public final class ClasspathRootsResolver {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiManager psiManager;
    @Nullable
    private final MessageCollector messageCollector;
    @NotNull
    private final List<String> additionalModules;
    @NotNull
    private final Function1<JvmContentRootBase, VirtualFile> contentRootToVirtualFile;
    @NotNull
    private final CliJavaModuleFinder javaModuleFinder;
    private final boolean requireStdlibModule;
    @Nullable
    private final VirtualFile outputDirectory;
    @NotNull
    private final KotlinCliJavaFileManager javaFileManager;
    @Nullable
    private final Integer jdkRelease;
    @NotNull
    private final JavaModuleGraph javaModuleGraph;
    @NotNull
    private final GlobalSearchScope searchScope;
    private final boolean reportErrors;

    public ClasspathRootsResolver(@NotNull PsiManager psiManager, @Nullable MessageCollector messageCollector, @NotNull List<String> additionalModules, @NotNull Function1<? super JvmContentRootBase, ? extends VirtualFile> contentRootToVirtualFile, @NotNull CliJavaModuleFinder javaModuleFinder, boolean requireStdlibModule, @Nullable VirtualFile outputDirectory, @NotNull KotlinCliJavaFileManager javaFileManager, @Nullable Integer jdkRelease, boolean hasKotlinSources) {
        Intrinsics.checkNotNullParameter(psiManager, "psiManager");
        Intrinsics.checkNotNullParameter(additionalModules, "additionalModules");
        Intrinsics.checkNotNullParameter(contentRootToVirtualFile, "contentRootToVirtualFile");
        Intrinsics.checkNotNullParameter(javaModuleFinder, "javaModuleFinder");
        Intrinsics.checkNotNullParameter(javaFileManager, "javaFileManager");
        this.psiManager = psiManager;
        this.messageCollector = messageCollector;
        this.additionalModules = additionalModules;
        this.contentRootToVirtualFile = contentRootToVirtualFile;
        this.javaModuleFinder = javaModuleFinder;
        this.requireStdlibModule = requireStdlibModule;
        this.outputDirectory = outputDirectory;
        this.javaFileManager = javaFileManager;
        this.jdkRelease = jdkRelease;
        this.javaModuleGraph = new JavaModuleGraph(this.javaModuleFinder);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.psiManager.getProject());
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "allScope(...)");
        this.searchScope = globalSearchScope;
        this.reportErrors = hasKotlinSources;
    }

    @NotNull
    public final JavaModuleGraph getJavaModuleGraph() {
        return this.javaModuleGraph;
    }

    @NotNull
    public final RootsAndModules convertClasspathRoots(@NotNull List<? extends ContentRoot> contentRoots) {
        Intrinsics.checkNotNullParameter(contentRoots, "contentRoots");
        List javaSourceRoots = new ArrayList();
        List jvmClasspathRoots = new ArrayList();
        List jvmModulePathRoots = new ArrayList();
        for (ContentRoot contentRoot : contentRoots) {
            VirtualFile root;
            if (!(contentRoot instanceof JvmContentRootBase) || this.contentRootToVirtualFile.invoke((JvmContentRootBase)contentRoot) == null) continue;
            JvmContentRootBase jvmContentRootBase = (JvmContentRootBase)contentRoot;
            if (jvmContentRootBase instanceof JavaSourceRoot) {
                ((Collection)javaSourceRoots).add(new RootWithPrefix(root, ((JavaSourceRoot)contentRoot).getPackagePrefix()));
                continue;
            }
            if (jvmContentRootBase instanceof JvmClasspathRootBase) {
                ((Collection)jvmClasspathRoots).add(root);
                continue;
            }
            if (jvmContentRootBase instanceof JvmModulePathRoot) {
                ((Collection)jvmModulePathRoots).add(root);
                continue;
            }
            throw new IllegalStateException(("Unknown root type: " + contentRoot).toString());
        }
        return this.computeRoots(javaSourceRoots, jvmClasspathRoots, jvmModulePathRoots);
    }

    /*
     * WARNING - void declaration
     */
    private final RootsAndModules computeRoots(List<RootWithPrefix> javaSourceRoots, List<? extends VirtualFile> jvmClasspathRoots, List<? extends VirtualFile> jvmModulePathRoots) {
        boolean bl;
        List modules;
        List result2;
        block17: {
            result2 = new ArrayList();
            modules = new ArrayList();
            boolean hasOutputDirectoryInClasspath = CollectionsKt.contains((Iterable)jvmClasspathRoots, this.outputDirectory) || CollectionsKt.contains((Iterable)jvmModulePathRoots, this.outputDirectory);
            for (RootWithPrefix object : javaSourceRoots) {
                FqName fqName2;
                VirtualFile virtualFile = object.component1();
                String packagePrefix = object.component2();
                JavaModule.Explicit modularRoot = this.modularSourceRoot(virtualFile, hasOutputDirectoryInClasspath);
                if (modularRoot != null) {
                    ((Collection)modules).add(modularRoot);
                    continue;
                }
                Collection collection = result2;
                VirtualFile virtualFile2 = virtualFile;
                JavaRoot.RootType rootType = JavaRoot.RootType.SOURCE;
                if (packagePrefix != null) {
                    Object object2;
                    void prefix;
                    JavaRoot.RootType rootType2 = rootType;
                    VirtualFile virtualFile3 = virtualFile2;
                    boolean bl2 = false;
                    if (FqNamesUtilKt.isValidJavaFqName((String)prefix)) {
                        object2 = new FqName((String)prefix);
                    } else {
                        Iterator iterator2;
                        Iterator it = iterator2 = null;
                        boolean bl3 = false;
                        ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.STRONG_WARNING, "Invalid package prefix name is ignored: " + (String)prefix, null, 4, null);
                        object2 = iterator2;
                    }
                    FqName fqName3 = object2;
                    virtualFile2 = virtualFile3;
                    rootType = rootType2;
                    fqName2 = fqName3;
                } else {
                    fqName2 = null;
                }
                FqName fqName4 = fqName2;
                JavaRoot.RootType rootType3 = rootType;
                VirtualFile virtualFile4 = virtualFile2;
                collection.add(new JavaRoot(virtualFile4, rootType3, fqName4));
            }
            for (VirtualFile virtualFile : jvmClasspathRoots) {
                ((Collection)result2).add(new JavaRoot(virtualFile, JavaRoot.RootType.BINARY, null, 4, null));
            }
            Iterable iterable = modules;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable) {
                    boolean bl3;
                    block16: {
                        JavaModule module2 = (JavaModule)element$iv;
                        boolean bl5 = false;
                        Iterable $this$any$iv2 = module2.getModuleRoots();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                JavaModule.Root it = (JavaModule.Root)element$iv2;
                                boolean bl6 = false;
                                if (!Intrinsics.areEqual(it.getFile(), this.outputDirectory)) continue;
                                bl3 = true;
                                break block16;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        boolean outputDirectoryAddedAsPartOfModule = bl;
        for (VirtualFile virtualFile : jvmModulePathRoots) {
            JavaModule module3;
            if (outputDirectoryAddedAsPartOfModule && Intrinsics.areEqual(virtualFile, this.outputDirectory) || (module3 = this.modularBinaryRoot(virtualFile)) == null) continue;
            ((Collection)modules).add(module3);
        }
        if (this.jdkRelease == null || this.jdkRelease >= 9) {
            this.addModularRoots(modules, result2);
        } else {
            ((Collection)result2).add(new JavaRoot(this.javaModuleFinder.getNonModuleRoot().getFile(), JavaRoot.RootType.BINARY_SIG, null, 4, null));
        }
        return new RootsAndModules(result2, modules);
    }

    private final Pair<VirtualFile, PsiJavaModule> findSourceModuleInfo(VirtualFile root) {
        Object object;
        VirtualFile moduleInfoFile;
        block5: {
            VirtualFile virtualFile = root.isDirectory() ? root.findChild("module-info.java") : (Intrinsics.areEqual(root.getName(), "module-info.java") ? root : null);
            if (virtualFile == null) {
                return null;
            }
            moduleInfoFile = virtualFile;
            PsiFile psiFile = this.psiManager.findFile(moduleInfoFile);
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            PsiElement[] psiElementArray = psiFile2.getChildren();
            Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
            Object[] $this$singleOrNull$iv = psiElementArray;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof PsiJavaModule)) continue;
                if (found$iv) {
                    object = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : single$iv;
        }
        Object object2 = object;
        PsiJavaModule psiJavaModule = object2 instanceof PsiJavaModule ? (PsiJavaModule)object2 : null;
        if (psiJavaModule == null) {
            return null;
        }
        PsiJavaModule psiJavaModule2 = psiJavaModule;
        return TuplesKt.to(moduleInfoFile, psiJavaModule2);
    }

    private final JavaModule.Explicit modularSourceRoot(VirtualFile root, boolean hasOutputDirectoryInClasspath) {
        List<JavaModule.Root> list;
        Pair<VirtualFile, PsiJavaModule> pair = this.findSourceModuleInfo(root);
        if (pair == null) {
            return null;
        }
        Pair<VirtualFile, PsiJavaModule> pair2 = pair;
        VirtualFile moduleInfoFile = pair2.component1();
        PsiJavaModule psiJavaModule = pair2.component2();
        JavaModule.Root sourceRoot = new JavaModule.Root(root, false, false, 4, null);
        if (hasOutputDirectoryInClasspath) {
            JavaModule.Root[] rootArray = new JavaModule.Root[2];
            rootArray[0] = sourceRoot;
            VirtualFile virtualFile = this.outputDirectory;
            Intrinsics.checkNotNull(virtualFile);
            rootArray[1] = new JavaModule.Root(virtualFile, true, false, 4, null);
            list = CollectionsKt.listOf(rootArray);
        } else {
            list = CollectionsKt.listOf(sourceRoot);
        }
        List<JavaModule.Root> roots = list;
        return new JavaModule.Explicit(JavaModuleInfo.Companion.create(psiJavaModule), roots, moduleInfoFile, false, 8, null);
    }

    private final JavaModule modularBinaryRoot(VirtualFile root) {
        VirtualFile moduleInfoFile;
        boolean isJar = Intrinsics.areEqual(root.getFileSystem().getProtocol(), "jar");
        Lazy<Attributes> manifest = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> ClasspathRootsResolver.modularBinaryRoot$lambda$5(this, root));
        VirtualFile virtualFile = root.findChild("module-info.class");
        if (virtualFile == null) {
            virtualFile = isJar ? this.tryLoadVersionSpecificModuleInfo(root, manifest) : null;
        }
        if ((moduleInfoFile = virtualFile) != null) {
            JavaModuleInfo javaModuleInfo = JavaModuleInfo.Companion.read(moduleInfoFile, this.javaFileManager, this.searchScope);
            if (javaModuleInfo == null) {
                return null;
            }
            JavaModuleInfo moduleInfo = javaModuleInfo;
            return new JavaModule.Explicit(moduleInfo, CollectionsKt.listOf(new JavaModule.Root(root, true, false, 4, null)), moduleInfoFile, false, 8, null);
        }
        if (isJar) {
            String automaticModuleName;
            List<JavaModule.Root> moduleRoot = CollectionsKt.listOf(new JavaModule.Root(root, true, false, 4, null));
            Attributes attributes = manifest.getValue();
            String string = automaticModuleName = attributes != null ? attributes.getValue("Automatic-Module-Name") : null;
            if (automaticModuleName != null) {
                return new JavaModule.Automatic(automaticModuleName, moduleRoot);
            }
            File file = VfsUtilCore.virtualToIoFile(root);
            Intrinsics.checkNotNullExpressionValue(file, "virtualToIoFile(...)");
            File originalFile = file;
            String string2 = LightJavaModule.moduleName(FilesKt.getNameWithoutExtension(originalFile));
            Intrinsics.checkNotNullExpressionValue(string2, "moduleName(...)");
            String moduleName = string2;
            if (((CharSequence)moduleName).length() == 0) {
                VirtualFile virtualFile2 = VfsUtilCore.getVirtualFileForJar(root);
                if (virtualFile2 == null) {
                    virtualFile2 = root;
                }
                this.report(CompilerMessageSeverity.ERROR, "Cannot infer automatic module name for the file", virtualFile2);
                return null;
            }
            return new JavaModule.Automatic(moduleName, moduleRoot);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile tryLoadVersionSpecificModuleInfo(VirtualFile root, Lazy<? extends Attributes> manifest) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Boolean isMultiReleaseJar;
        VirtualFile virtualFile = root.findChild("META-INF");
        if (virtualFile == null || (virtualFile = virtualFile.findChild("versions")) == null) {
            return null;
        }
        VirtualFile versionsDir = virtualFile;
        Object object = manifest.getValue();
        Boolean bl = object != null && (object = ((Attributes)object).getValue("Multi-Release")) != null ? Boolean.valueOf(StringsKt.equals((String)object, "true", true)) : (isMultiReleaseJar = null);
        if (!Intrinsics.areEqual(isMultiReleaseJar, true)) {
            return null;
        }
        VirtualFile[] virtualFileArray = versionsDir.getChildren();
        Intrinsics.checkNotNullExpressionValue(virtualFileArray, "getChildren(...)");
        Object $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            Integer version = StringsKt.toIntOrNull(string);
            if (!(version != null && version >= 9)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List<VirtualFile> versions2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                VirtualFile it = (VirtualFile)a2;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                it = (VirtualFile)b2;
                Comparable comparable = Integer.valueOf(Integer.parseInt(string));
                bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                return ComparisonsKt.compareValues(comparable, Integer.parseInt(string2));
            }
        });
        for (VirtualFile version : versions2) {
            VirtualFile file;
            VirtualFile virtualFile2 = file = version.findChild("module-info.class");
            if (virtualFile2 == null) continue;
            return virtualFile2;
        }
        return null;
    }

    private final Attributes readManifestAttributes(VirtualFile jarRoot) {
        Attributes attributes;
        VirtualFile virtualFile = jarRoot.findChild("META-INF");
        VirtualFile manifestFile = virtualFile != null ? virtualFile.findChild("MANIFEST.MF") : null;
        try {
            Attributes attributes2;
            Object object = manifestFile;
            if (object != null && (object = ((VirtualFile)object).getInputStream()) != null) {
                Object p0 = object;
                boolean bl = false;
                attributes2 = new Manifest((InputStream)p0).getMainAttributes();
            } else {
                attributes2 = null;
            }
            attributes = attributes2;
        }
        catch (IOException e2) {
            attributes = null;
        }
        return attributes;
    }

    /*
     * WARNING - void declaration
     */
    private final void addModularRoots(List<? extends JavaModule> modules, List<JavaRoot> result2) {
        boolean bl;
        LinkedHashSet<String> allDependencies;
        JavaModule.Explicit sourceModule;
        block21: {
            List list;
            void $this$filterTo$iv$iv;
            Iterator<Object> $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = modules;
            boolean bl2 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof JavaModule.Explicit)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean bl3 = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JavaModule p0 = (JavaModule)element$iv$iv;
                boolean bl22 = false;
                if (!p0.isSourceModule()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List sourceModules = (List)destination$iv$iv;
            if (sourceModules.size() > 1) {
                for (JavaModule.Explicit explicit : sourceModules) {
                    this.report(CompilerMessageSeverity.ERROR, "Too many source module declarations found", explicit.getModuleInfoFile());
                }
                return;
            }
            for (JavaModule javaModule : modules) {
                JavaModule existing = this.javaModuleFinder.findModule(javaModule.getName());
                if (existing == null) {
                    this.javaModuleFinder.addUserModule(javaModule);
                    continue;
                }
                if (Intrinsics.areEqual(javaModule.getModuleRoots(), existing.getModuleRoots())) continue;
                VirtualFile thisFile = ClasspathRootsResolver.addModularRoots$getRootFile(javaModule);
                VirtualFile existingFile = ClasspathRootsResolver.addModularRoots$getRootFile(existing);
                String string = existingFile == null ? "" : " at: " + existingFile.getPath();
                this.report(CompilerMessageSeverity.STRONG_WARNING, "The root is ignored because a module with the same name '" + javaModule.getName() + "' has been found earlier on the module path" + string, thisFile);
            }
            if (SequencesKt.none(this.javaModuleFinder.getAllObservableModules())) {
                return;
            }
            sourceModule = (JavaModule.Explicit)CollectionsKt.singleOrNull(sourceModules);
            boolean bl4 = this.additionalModules.contains("ALL-MODULE-PATH");
            if (bl4 && sourceModule != null) {
                ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.ERROR, "-Xadd-modules=ALL-MODULE-PATH can only be used when compiling the unnamed module", null, 4, null);
                return;
            }
            JavaModule.Explicit explicit = sourceModule;
            if (explicit != null) {
                list = CollectionsKt.plus((Collection)CollectionsKt.listOf(explicit.getName()), (Iterable)this.additionalModules);
            } else if (bl4) {
                Iterable $this$map$iv = modules;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : iterable2) {
                    void p0;
                    JavaModule javaModule = (JavaModule)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl32 = false;
                    collection.add(p0.getName());
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.plus((Collection)CliJavaModuleUtilsKt.computeDefaultRootModules(this.javaModuleFinder), (Iterable)this.additionalModules);
            }
            List rootModules = list;
            allDependencies = this.javaModuleGraph.getAllDependencies(rootModules);
            Iterable $this$any$iv = allDependencies;
            boolean bl5 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String moduleName = (String)element$iv;
                    boolean bl42 = false;
                    if (!(this.javaModuleFinder.findModule(moduleName) instanceof JavaModule.Automatic)) continue;
                    bl = true;
                    break block21;
                }
                bl = false;
            }
        }
        if (bl) {
            for (JavaModule javaModule : modules) {
                if (!(javaModule instanceof JavaModule.Automatic)) continue;
                ((Collection)allDependencies).add(((JavaModule.Automatic)javaModule).getName());
            }
        }
        ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.LOGGING, "Loading modules: " + allDependencies, null, 4, null);
        Iterator iterator2 = allDependencies.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<JavaModule> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            JavaModule javaModule = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(javaModule, "next(...)");
            String string = (String)((Object)javaModule);
            JavaModule module5 = this.javaModuleFinder.findModule(string);
            if (module5 == null) {
                ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.ERROR, "Module " + string + " cannot be found in the module graph", null, 4, null);
                continue;
            }
            result2.addAll((Collection<JavaRoot>)CliJavaModuleUtilsKt.getJavaModuleRoots(module5));
        }
        if (this.requireStdlibModule && sourceModule != null && !this.javaModuleGraph.reads(sourceModule.getName(), "kotlin.stdlib")) {
            this.report(CompilerMessageSeverity.ERROR, "The Kotlin standard library is not found in the module graph. Please ensure you have the 'requires kotlin.stdlib' clause in your module definition", sourceModule.getModuleInfoFile());
        }
    }

    private final void report(CompilerMessageSeverity severity, String message, VirtualFile file) {
        if (this.messageCollector == null) {
            throw new IllegalStateException((file != null ? file.getPath() + ':' : "") + (Object)((Object)severity) + ": " + message + " (no MessageCollector configured)");
        }
        if (severity == CompilerMessageSeverity.ERROR && !this.reportErrors) {
            return;
        }
        VirtualFile virtualFile = file;
        this.messageCollector.report(severity, message, virtualFile == null ? null : CompilerMessageLocation.Companion.create(MessageUtil.virtualFileToPath(virtualFile)));
    }

    static /* synthetic */ void report$default(ClasspathRootsResolver classpathRootsResolver, CompilerMessageSeverity compilerMessageSeverity, String string, VirtualFile virtualFile, int n2, Object object) {
        if ((n2 & 4) != 0) {
            virtualFile = null;
        }
        classpathRootsResolver.report(compilerMessageSeverity, string, virtualFile);
    }

    private static final Attributes modularBinaryRoot$lambda$5(ClasspathRootsResolver this$0, VirtualFile $root) {
        return this$0.readManifestAttributes($root);
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile addModularRoots$getRootFile(JavaModule $this$addModularRoots_u24getRootFile) {
        VirtualFile virtualFile;
        Object object = CollectionsKt.firstOrNull($this$addModularRoots_u24getRootFile.getModuleRoots());
        if (object != null && (object = ((JavaModule.Root)object).getFile()) != null) {
            Object it = object;
            boolean bl = false;
            virtualFile = VfsUtilCore.getVirtualFileForJar((VirtualFile)it);
            if (virtualFile == null) {
                void var1_1;
                virtualFile = var1_1;
            }
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private static final class RootWithPrefix {
        @NotNull
        private final VirtualFile root;
        @Nullable
        private final String packagePrefix;

        public RootWithPrefix(@NotNull VirtualFile root, @Nullable String packagePrefix) {
            Intrinsics.checkNotNullParameter(root, "root");
            this.root = root;
            this.packagePrefix = packagePrefix;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @Nullable
        public final String component2() {
            return this.packagePrefix;
        }

        @NotNull
        public String toString() {
            return "RootWithPrefix(root=" + this.root + ", packagePrefix=" + this.packagePrefix + ')';
        }

        public int hashCode() {
            int result2 = this.root.hashCode();
            result2 = result2 * 31 + (this.packagePrefix == null ? 0 : this.packagePrefix.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RootWithPrefix)) {
                return false;
            }
            RootWithPrefix rootWithPrefix = (RootWithPrefix)other;
            if (!Intrinsics.areEqual(this.root, rootWithPrefix.root)) {
                return false;
            }
            return Intrinsics.areEqual(this.packagePrefix, rootWithPrefix.packagePrefix);
        }
    }

    public static final class RootsAndModules {
        @NotNull
        private final List<JavaRoot> roots;
        @NotNull
        private final List<JavaModule> modules;

        public RootsAndModules(@NotNull List<JavaRoot> roots, @NotNull List<? extends JavaModule> modules) {
            Intrinsics.checkNotNullParameter(roots, "roots");
            Intrinsics.checkNotNullParameter(modules, "modules");
            this.roots = roots;
            this.modules = modules;
        }

        @NotNull
        public final List<JavaRoot> getRoots() {
            return this.roots;
        }

        @NotNull
        public final List<JavaRoot> component1() {
            return this.roots;
        }

        @NotNull
        public final List<JavaModule> component2() {
            return this.modules;
        }

        @NotNull
        public String toString() {
            return "RootsAndModules(roots=" + this.roots + ", modules=" + this.modules + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.roots).hashCode();
            result2 = result2 * 31 + ((Object)this.modules).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RootsAndModules)) {
                return false;
            }
            RootsAndModules rootsAndModules = (RootsAndModules)other;
            if (!Intrinsics.areEqual(this.roots, rootsAndModules.roots)) {
                return false;
            }
            return Intrinsics.areEqual(this.modules, rootsAndModules.modules);
        }
    }
}

