/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;

public final class CompilerMessageLocation
implements CompilerMessageSourceLocation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    private final int line;
    private final int column;
    @Nullable
    private final String lineContent;
    private static final long serialVersionUID = 8228357578L;

    private CompilerMessageLocation(String path, int line, int column, String lineContent) {
        this.path = path;
        this.line = line;
        this.column = column;
        this.lineContent = lineContent;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @NotNull
    public String toString() {
        return this.getPath() + (this.getLine() != -1 || this.getColumn() != -1 ? " (" + this.getLine() + ':' + this.getColumn() + ')' : "");
    }

    public int hashCode() {
        int result2 = this.path.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.line);
        result2 = result2 * 31 + Integer.hashCode(this.column);
        result2 = result2 * 31 + (this.lineContent == null ? 0 : this.lineContent.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompilerMessageLocation)) {
            return false;
        }
        CompilerMessageLocation compilerMessageLocation = (CompilerMessageLocation)other;
        if (!Intrinsics.areEqual(this.path, compilerMessageLocation.path)) {
            return false;
        }
        if (this.line != compilerMessageLocation.line) {
            return false;
        }
        if (this.column != compilerMessageLocation.column) {
            return false;
        }
        return Intrinsics.areEqual(this.lineContent, compilerMessageLocation.lineContent);
    }

    public /* synthetic */ CompilerMessageLocation(String path, int line, int column, String lineContent, DefaultConstructorMarker $constructor_marker) {
        this(path, line, column, lineContent);
    }

    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CompilerMessageLocation create(@Nullable String path) {
            return this.create(path, -1, -1, null);
        }

        @Nullable
        public final CompilerMessageLocation create(@Nullable String path, int line, int column, @Nullable String lineContent) {
            return path == null ? null : new CompilerMessageLocation(path, line, column, lineContent, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

