/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.localfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.localfs.KotlinLocalVirtualFile;

public final class KotlinLocalFileSystem
extends CoreLocalFileSystem {
    @Override
    @NotNull
    public String getProtocol() {
        return "file";
    }

    @Override
    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.findFileByIoFile(new File(path));
    }

    @Override
    public void refresh(boolean asynchronous) {
    }

    @Override
    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.findFileByPath(path);
    }

    @Override
    @Nullable
    public Path getNioPath(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter(file, "file");
        Serializable serializable = file instanceof KotlinLocalVirtualFile ? (KotlinLocalVirtualFile)file : null;
        return serializable != null && (serializable = ((KotlinLocalVirtualFile)serializable).getFile()) != null ? ((File)serializable).toPath() : null;
    }

    @Override
    @Nullable
    public VirtualFile findFileByIoFile(@NotNull File file) {
        KotlinLocalVirtualFile kotlinLocalVirtualFile;
        Intrinsics.checkNotNullParameter(file, "file");
        boolean condition$iv = file.exists();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            kotlinLocalVirtualFile = new KotlinLocalVirtualFile(file, this, null, 4, null);
        } else {
            kotlinLocalVirtualFile = null;
        }
        return kotlinLocalVirtualFile;
    }

    @Override
    @Nullable
    public VirtualFile findFileByNioFile(@NotNull Path file) {
        Intrinsics.checkNotNullParameter(file, "file");
        File file2 = file.toFile();
        Intrinsics.checkNotNullExpressionValue(file2, "toFile(...)");
        return this.findFileByIoFile(file2);
    }
}

