/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import com.intellij.openapi.Disposable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.modules.Module;

public final class CliModuleVisibilityManagerImpl
implements Disposable,
ModuleVisibilityManager {
    private final boolean enabled;
    @NotNull
    private final List<Module> chunk;
    @NotNull
    private final List<String> friendPaths;

    public CliModuleVisibilityManagerImpl(boolean enabled) {
        this.enabled = enabled;
        this.chunk = new ArrayList();
        this.friendPaths = new ArrayList();
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public List<Module> getChunk() {
        return this.chunk;
    }

    @NotNull
    public List<String> getFriendPaths() {
        return this.friendPaths;
    }

    @Override
    public void addModule(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        this.getChunk().add(module2);
    }

    @Override
    public void addFriendPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Collection collection = this.getFriendPaths();
        String string = new File(path).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
        collection.add(string);
    }

    @Override
    public void dispose() {
        this.getChunk().clear();
    }
}

