/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.WhenOnClassExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnExpectExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenOnEnumExhaustivenessChecker;", "Lorg/jetbrains/kotlin/cfg/WhenOnClassExhaustivenessChecker;", "<init>", "()V", "getMissingCases", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "subjectDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "nullable", "", "isApplicable", "subjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
final class WhenOnEnumExhaustivenessChecker
extends WhenOnClassExhaustivenessChecker {
    @NotNull
    public static final WhenOnEnumExhaustivenessChecker INSTANCE = new WhenOnEnumExhaustivenessChecker();

    private WhenOnEnumExhaustivenessChecker() {
    }

    @Override
    @NotNull
    public List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression, @NotNull BindingContext context, @Nullable ClassDescriptor subjectDescriptor, boolean nullable) {
        List list;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean bl = DescriptorUtils.isEnumClass(subjectDescriptor);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WhenOnEnumExhaustivenessChecker$getMissingCases$22 = false;
            String $i$a$-assert-WhenOnEnumExhaustivenessChecker$getMissingCases$22 = "isWhenOnEnumExhaustive should be called with an enum class descriptor";
            throw new AssertionError((Object)$i$a$-assert-WhenOnEnumExhaustivenessChecker$getMissingCases$22);
        }
        List $this$getMissingCases_u24lambda_u241 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl2 = false;
        ClassDescriptor classDescriptor = subjectDescriptor;
        Intrinsics.checkNotNull(classDescriptor);
        $this$getMissingCases_u24lambda_u241.addAll(INSTANCE.getMissingClassCases(expression, INSTANCE.getEnumEntries(classDescriptor), context));
        $this$getMissingCases_u24lambda_u241.addAll(WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression, context, nullable));
        CollectionsKt.addIfNotNull($this$getMissingCases_u24lambda_u241, WhenOnExpectExhaustivenessChecker.INSTANCE.getMissingCase(subjectDescriptor));
        return kotlin.collections.CollectionsKt.build(list);
    }

    @Override
    public boolean isApplicable(@NotNull KotlinType subjectType) {
        Intrinsics.checkNotNullParameter(subjectType, "subjectType");
        return WhenChecker.getClassDescriptorOfTypeIfEnum(subjectType) != null;
    }
}

